#include "cnst.sh"
#include "typedef.sh"

import "reset";

import "homing_test";
import "filter_and_scale";


#ifdef DEBUGOUTPUT
  import "std_includes";         /* testing homing frame */
#endif







behavior Pre_Process (
                      in bit[SAMPLE_WIDTH-1:0] speech_frame[L_FRAME],
                      out Word16 speech_frame_filtered[L_FRAME],
		      out Flag reset_flag_1,
		      out Flag reset_flag_2,
		      in event new_frame
                      )
  implements Ireset

{
  Flag reset_flag;
  Flag reset_next = 0;
  
  Encoder_Homingframe_Test encoder_homingframe_test(speech_frame, reset_next);
  Filter_And_Scale filter_and_scale(reset_flag, speech_frame, 
				    speech_frame_filtered);



  void reset(void)
    {
      filter_and_scale.reset();
    }
  
  void main(void)
    {

      reset_flag_1 = reset_flag = reset_next;     
      reset_flag_2 = reset_flag;
      
      if (reset_next == 1)    /* last frame was a homing frame */
	{
#ifdef DEBUGOUTPUT
	  /* testing homing frame */
	  printf(" ****** homing frame detected -> reset! ******");   
#endif

	  reset_next = 0;
	}
      
      wait(new_frame);

      encoder_homingframe_test.main();

      filter_and_scale.main();

    }
  
};
