#include "cnst.sh"
#include "typedef.sh"

import "reset";

import "prm2bits";
import "cn_encoding";
import "sid_codeword_encode";




behavior Post_Process (
		       in  Word16 prm[PRM_SIZE],
		       in  DTXctrl txdtx_ctrl,
		       in  Flag reset_flag,
		       out unsigned bit[BITS_PER_FRAME-1:0] serial,
		       out DTXctrl txdtx_ctrl_out,
		       out event serialbits_ready
		       )
  implements Ireset

{
  Word16 params[PRM_SIZE];
  unsigned bit[BITS_PER_FRAME-1:0] ser;

  Cn_Encoder cn_encoder(prm, params, txdtx_ctrl, reset_flag);
  Prm2bits_12k2 prm2bits_12k2(params, ser);
  Sid_Codeword_Encoder sid_codeword_encoder(ser, txdtx_ctrl, serial);



  void reset(void)
    {
      cn_encoder.reset();
    }


  void main(void)
    {
      /* Write comfort noise parameters into the parameter frame.  */
      /* Use old parameters in case SID frame is not to be updated */
      cn_encoder.main();
      
      
      /* Parameters to serial bits */
      prm2bits_12k2.main();
      

      /* Insert SID codeword into the serial parameter frame */
      sid_codeword_encoder.main();
      
      txdtx_ctrl_out = txdtx_ctrl;
      notify serialbits_ready;            
    }
  
};
