/**************************************************************************
 *
 *   File Name:  homing_test.sc
 *
 *   Purpose:
 *      This file contains the following behavior:
 *
 *      encoder_homing_frame_test  checks if a frame of input samples 
 *                                 matches the Encoder Homing Frame pattern.
 *
 **************************************************************************/

#include "cnst.sh"
#include "typedef.sh"




//#define EHF_MASK 0000000000001B /* Encoder Homing Frame pattern */

/***************************************************************************
 *
 *   FUNCTION NAME:  encoder_homing_frame_test
 *
 *   PURPOSE:
 *      Checks if a frame of input samples matches the Encoder Homing Frame
 *      pattern, which is EHF_MASK for all 160 samples in the frame.
 *
 *   INPUT:
 *      input_frame[]    one frame of speech samples
 *
 *   OUTPUT:
 *      0       input frame does not match the Encoder Homing Frame pattern.
 *      1       input frame matches the Encoder Homing Frame pattern.
 *
 **************************************************************************/

behavior Encoder_Homingframe_Test (
			   in bit[SAMPLE_WIDTH-1:0] input_frame[L_FRAME],
			   out Flag j
			   )
{
  void main(void)
    {
      Flag f;
      Int i;
      
      for (i = 0; i < L_FRAME; i++)
	{
	  if (!(f = input_frame[i]==1))
            break;
	}
      
      j = f;
    }
};

