
#include "cnst.sh"
#include "typedef.sh"

import "reset";

import "array_op";  // for Set_zero()

import "F_gamma";

import "weight_ai";
import "residu";
import "syn_filt";
import "ol_lag_est";





behavior Open_Loop(
   in  Word16 *p_speech,
   in  Word16 A_t[4][MP1],
       Word16 *wsp,        /* (i/o)  this is the weighted speech */
   out Word16 T0_min_1,   /* range for closed loop pitch search subframes 1&2*/
   out Word16 T0_max_1,
   out Word16 T0_min_2,   /* range for closed loop pitch search subframes 3&4*/
   out Word16 T0_max_2,
   out Flag   ptch,         /* flag to indicate a periodic signal component */
   in  DTXctrl txdtx_ctrl, /* voice activity flags */
   in  Flag   dtx_mode,
   in  Flag   reset_flag		   
   )
implements Ireset

{
  Word16 mem_w[M];

  Word16 ap1[MP1];
  Word16 ap2[MP1];
  Word16 A_t_i[MP1];
  Word16 *p_speech_i;
  Word16 wsp_i[L_SUBFR];

  Weight_Ai  weight_ai_1(A_t_i, F_gamma1, ap1);
  Weight_Ai  weight_ai_2(A_t_i, F_gamma2, ap2);
  Residu     residual(ap1, p_speech_i, wsp_i);
  Syn_Filt   syn_filter(ap2, wsp_i, wsp_i, mem_w, true);
  Ol_Lag_Est ol_lag_estimate(wsp, T0_min_1, T0_max_1, T0_min_2, T0_max_2, 
			     ptch, txdtx_ctrl, dtx_mode, reset_flag);


  void init(void)
    {
      Set_zero(mem_w, M);
    }

  void reset(void)
    {
      init();
      ol_lag_estimate.reset();
    }
 

  void main(void)
    {
      Int i;

      if (reset_flag) init();
      
      for(i = 0; i <= 3; i++)
	{
          A_t_i = A_t[i];
	  p_speech_i = p_speech + i * L_SUBFR;

	  par {
	    weight_ai_1.main();
	    weight_ai_2.main();
	  }
	  residual.main();
	  syn_filter.main();
          
          Copy(wsp_i, wsp + i * L_SUBFR, L_SUBFR);
	}
            
      ol_lag_estimate.main();
    }
};
