#include "cnst.sh"
#include "typedef.sh"

#include "lp_analysis.tab"    // lpc window

import "reset";

import "array_op";   // for Copy();

import "find_az";
import "az_lsp";
import "vad_lp";
import "int_lpc";
import "q_plsf_and_intlpc";
import "no_speech_upd";



behavior LP_Analysis (
  in  Word16 *p_window,     /* (i): input signal                            */
  out Word16 A_t[4][MP1],   /* (o): A(z) unquantized for the 4 subframes    */
  out Word16 Aq_t[4][MP1],  /* (o): A(z) quantized for the 4 subframes      */
  out Word16 ana[PRM_SIZE], /* (o): quantization indices (ana[0..4])        */
  in  Flag   ptch,          /* flag to indicate a periodic signal component */
      DTXctrl txdtx_ctrl,   /* voice activity flags */
  in  Flag   dtx_mode,
  out Word32 L_pn_seed_tx,
  in  Flag   reset_flag
  )
implements Ireset
{
  Word16 old_A[MP1];               /* Last A(z) for case of unstable filter */

  Word16 lsp_old[M], lsp_old_q[M];
  Word16 lsp_new[M], lsp_new_q[M];      /* LSPs at 4th subframe             */
  Word16 lsp_mid[M], lsp_mid_q[M];      /* LSPs at 2nd subframe             */

  Word16 rc[4];                         /* First 4 reflection coefficients  */

  Word16 A_t_1[MP1];
  Word16 A_t_3[MP1];
  Word16 A[4][MP1];
  Word16 dummy_fac;
  Word16 dummy_rc[4];
  Word16 dummy_r_h[MP1];
  Word16 dummy_r_l[MP1];
  Word16 scal_fac;
  Word16 r_l[MP1], r_h[MP1];

  /* LP analysis centered at 2nd subframe */
  Find_Az find_az_1(p_window, window_160_80, dummy_r_h, dummy_r_l, old_A, 
		    dummy_fac, A_t_1, dummy_rc);

  /* LP analysis centered at 4th subframe */
  Find_Az find_az_2(p_window, window_232_8,  r_h, r_l, old_A, scal_fac, 
		    A_t_3, rc);
  
  Az_Lsp az_lsp_1(A_t_1, lsp_mid, lsp_old);
  Az_Lsp az_lsp_2(A_t_3, lsp_new, lsp_mid);

  Vad_Lp vad_lp(r_l, r_h, scal_fac, rc, ptch, txdtx_ctrl, dtx_mode,
		L_pn_seed_tx, reset_flag);

  Int_Lpc2 int_lpc2(lsp_old, lsp_mid, lsp_new, A);

  Q_Plsf_And_Intlpc q_plsf_and_intlpc(Aq_t, lsp_old, lsp_mid, lsp_new, 
				      lsp_old_q, lsp_mid_q, lsp_new_q, ana, 
				      txdtx_ctrl, reset_flag);

  No_Speech_Upd no_speech_upd(A, Aq_t, lsp_old, lsp_new, lsp_old_q, 
			      lsp_new_q, txdtx_ctrl);



  void init(void)
    {
      Int i;
      
      old_A[0] = 4096;            /* Last A(z) for case of unstable filter */
      for (i = 1; i < MP1; i++)
	{
	  old_A[i] = 0;
	}

      /* Initialize lsp_old[] */
      lsp_old[0] = 30000;
      lsp_old[1] = 26000;
      lsp_old[2] = 21000;
      lsp_old[3] = 15000;
      lsp_old[4] = 8000;
      lsp_old[5] = 0;
      lsp_old[6] = -8000;
      lsp_old[7] = -15000;
      lsp_old[8] = -21000;
      lsp_old[9] = -26000;
      
      /* Initialize lsp_old_q[] */
      Copy (lsp_old, lsp_old_q, M);
      
    }
  

  void reset(void)
    {
      init();
      q_plsf_and_intlpc.reset();
      vad_lp.reset();
    }
  

  void main(void)
    {
      if (reset_flag) init();
      
      par 
	{	  
	  find_az_1.main();    
	  find_az_2.main();    
	}

      az_lsp_1.main();   A[1] = A_t_1;
      az_lsp_2.main();   A[3] = A_t_3;
      
      vad_lp.main();

      par
        {
	  int_lpc2.main();
	  q_plsf_and_intlpc.main();     
        }

      
      no_speech_upd.main();

      A_t = A;
    }
};
