//
// 04/07/03  <gerstl>	Updated to use signals for wires (SpecC 2.0)
// 01/08/02  <gerstl>	Updated to comply with extended port checking
// 05/24/00  <doemer>	pointers replaced by arrays

#include "typedef.sh"
#include "cnst.sh"

#include "bus.sh"
import "bus";

import "codebook";



/*------------------ DSP56600 bus protocol handling ---------------- */


interface ISendReceive
{
  bit[15:0] receive(bit[15:0] addr);
  void send(bit[15:0] addr, bit[15:0] data);
};

channel SendReceive(in    signal bit[15:0] A,        // address
		    inout signal bit[23:0] D,        // data
		    in    signal bit[1]    MCS,      // chip select
		    in    signal bit[1]    nRD,      // control lines
		    in    signal bit[1]    nWR)
  implements ISendReceive
{
  bit[15:0] receive(bit[15:0] addr)
  {
    bit[15:0] data;
    
    t1: wait(rising MCS);
    if (A != addr) goto t1;
    waitfor(20);
    if (nWR) goto t1;
    data = D;
    
    return data;
  }
  
  void send(bit[15:0] addr, bit[15:0] data)
  {
    t1: wait(rising MCS);
    if (A != addr) goto t1;
    waitfor(15);
    if (nRD) goto t1;
    D = data;
  }
};


/*------------------  Bus driver (application layer) ---------------- */

channel HwBusDriver(in    signal bit[15:0] A,        // address
		    inout signal bit[23:0] D,        // data
		    in    signal bit[1]    MCS,      // chip select
		    in    signal bit[1]    nRD,      // control lines
		    in    signal bit[1]    nWR,
		    out   signal bit[1]    intC)     // interrupt
  implements IBus
{
  SendReceive io(A, D, MCS, nRD, nWR);

  void sendWord(Word16 data, int addr)
  {
    intC = 1;
    waitfor(5);
    intC = 0;
    io.send(addr, data);
  }
  
  void sendWordP(Word16* data, int len, int addr)
  {
    int i;
    
    for (i = 0; i < len; i++) {
      sendWord(data[i], addr);
    }
  }

  void recvWord(Word16* data, int addr)
  {
    intC = 1;
    waitfor(5);
    intC = 0;
    *data = io.receive(addr);
  }
  
  void recvWordP(Word16* data, int len, int addr)
  {
    int i;
    
    for (i = 0; i < len; i++) {
      recvWord(&data[i], addr);
    }
  }  
};


/*------------------ Codebook coprocessor ---------------- */


behavior Codebook_Start(
			IBus bus,
			out Word16 exc[L_SUBFR],
			out Word16 xn[L_SUBFR],
			out Word16 res2[L_SUBFR],
			out Word16 y1[L_SUBFR],
			out Word16 gain_pit,
			out Word16 T0,
			out Word16 h1[L_SUBFR]
			)
{
  void main(void)
  {
    bus.recvWordP(&exc[0], L_SUBFR, ADDR_HW);
    bus.recvWordP(&xn[0], L_SUBFR, ADDR_HW);
    bus.recvWordP(&res2[0], L_SUBFR, ADDR_HW);
    bus.recvWordP(&y1[0], L_SUBFR, ADDR_HW);
    bus.recvWord(&gain_pit, ADDR_HW);
    bus.recvWord(&T0, ADDR_HW);
    bus.recvWordP(&h1[0], L_SUBFR, ADDR_HW);
  }
};


behavior Codebook_Done(
		       in Word16 code[L_SUBFR],
		       in Word16 y2[L_SUBFR],
		       in Word16 gain_code,
		       in Word16 ana[10],
		       IBus bus
		       )
{
  void main(void)
  {
    bus.sendWordP(&code[0], L_SUBFR, ADDR_HW);
    bus.sendWordP(&y2[0], L_SUBFR, ADDR_HW);
    bus.sendWord(gain_code, ADDR_HW);
    bus.sendWordP(&ana[0], 10, ADDR_HW);
  }
};




behavior Hw (in    signal bit[15:0] A,        // address
	     inout signal bit[23:0] D,        // data
	     in    signal bit[1]    MCS,      // chip select
	     in    signal bit[1]    nRD,      // control lines
	     in    signal bit[1]    nWR,
	     out   signal bit[1]    intC      // interrupt
)
{
  Word16 exc[L_SUBFR];
  Word16 xn[L_SUBFR];
  Word16 res2[L_SUBFR];
  Word16 y1[L_SUBFR];
  Word16 gain_pit;
  Word16 ana[10];
  Word16 T0;
  Word16 h1[L_SUBFR];
  Word16 code[L_SUBFR];
  Word16 y2[L_SUBFR];
  Word16 gain_code;

  HwBusDriver busdriver(A, D, MCS, nRD, nWR, intC);
  
  Codebook_Start start(busdriver, exc, xn, res2, y1, gain_pit, T0, h1);
  Codebook codebook(xn, y1, gain_pit, exc, h1, T0, res2, code, y2, gain_code, ana);
  Codebook_Done  done(code, y2, gain_code, ana, busdriver);
  
  void main(void)
  {
    while (true)
    {
      start.main();
      codebook.main();
      done.main();
    }
  }
};
