// ------------------------------------------------------------------------
// GSM EFR Vocoder  -  File: prefilter.sc
// ------------------------------------------------------------------------
// 
// Include the pitch prefilter contribution into a signal.
//
//
// 01/09/02  <gerstl>	Merged in port splitting from 'arch' branch
// 07/21/98  <gerstl>
// 08/07/98  <szhao>

#include "typedef.sh"
#include "cnst.sh"

import "basic_op";



behavior Prefilter (in    Word16 T0,
		    in    Word16 gain_pit,
		    in    Word16 x_in[L_SUBFR],
                    out   Word16 x_out[L_SUBFR])
{
  void main(void) 
  {
    Int i;
    Word16 temp;
    Word16 pit_sharp;
    Word16 x[L_SUBFR];
    
    x = x_in;
    
    pit_sharp = shl(gain_pit, 3);       // from codebook.sc (R.D.)
    
    for (i = T0; i < L_SUBFR; i++)
    {
	temp = mult (x[i - T0], pit_sharp);
	x[i] = add (x[i], temp);
    }
    
    x_out = x;
  }
};
