// ------------------------------------------------------------------------
// GSM EFR Vocoder  -  File: codebook_stub.sc
// ------------------------------------------------------------------------
// 
// Algebraic fixed codebook search
// -- Stub on DSP side --
//
//
// 01/09/02  <gerstl>	Updated to comply to better port checking.
// 12/08/99  <gerstl>

#include "cnst.sh"
#include "typedef.sh"

#include "bus.sh"
import "bus";


behavior Codebook_Stub(
		       in  Word16 xn[L_SUBFR],
		       in  Word16 y1[L_SUBFR],
		       in  Word16 gain_pit,
		       in  Word16 exc[L_SUBFR],
		       in  Word16 h1[L_SUBFR],
		       in  Word16 T0,
		       in  Word16 res2[L_SUBFR],
		       out Word16 code[L_SUBFR],
		       out Word16 y2[L_SUBFR],
		       out Word16 gain_code,
		       out Word16 ana[10],
		       IBus bus
		       )
{
  void main(void)
  {
    bus.sendWordP(&exc[0], L_SUBFR, ADDR_HW);
    bus.sendWordP(&xn[0], L_SUBFR, ADDR_HW);
    bus.sendWordP(&res2[0], L_SUBFR, ADDR_HW);
    bus.sendWordP(&y1[0], L_SUBFR, ADDR_HW);
    bus.sendWord(gain_pit, ADDR_HW);
    bus.sendWord(T0, ADDR_HW);
    bus.sendWordP(&h1[0], L_SUBFR, ADDR_HW);
    
    bus.recvWordP(&code[0], L_SUBFR, ADDR_HW);
    bus.recvWordP(&y2[0], L_SUBFR, ADDR_HW);
    bus.recvWord(&gain_code, ADDR_HW);    
    bus.recvWordP(&ana[0], 10, ADDR_HW);
  }
};
