#include "cnst.sh"
#include "typedef.sh"


import "array_op";
import "syn_filt";




import "reset";


behavior Imp_Resp (
		   in  Word16 Aq[MP1],
		   in  Word16 Ap1[MP1],
		   in  Word16 Ap2[MP1],
		   out Word16 h1[L_SUBFR],
		   in  DTXctrl txdtx_ctrl,      /* voice activity flags */
		   in  Flag reset_flag
		   )
  implements Ireset

{
  Word16 h1b[L_SUBFR];
  Word16 zero[M];
  Word16 ai_zero[L_SUBFR];

  
  Syn_Filt syn_filt_1(Aq, ai_zero, h1b, zero, false);
  Syn_Filt syn_filt_2(Ap2, h1b, h1, zero, false);



  void init(void)
    {
      Set_zero(zero, M);
      Set_zero(ai_zero, L_SUBFR);
    }
  
  void reset(void)
    {
      init();
    }
 

  void main(void)
    {
      if (reset_flag) init();
      
      if ((txdtx_ctrl & TX_SP_FLAG) != 0)
        {
          Copy(Ap1, ai_zero, MP1);
	  
	  syn_filt_1.main();
	  syn_filt_2.main();
	  
	}
    }
};
