#include "EFR_Coder_public.sh"

import "reset";

behavior Coder (in  bit[SAMPLE_WIDTH-1:0] speech_samples[L_FRAME], /* 13-bit speech sample input                  */
		in  Flag dtx_mode,                                 /* set to 1 for voice activity detection       */
		in  event new_frame,                               /* notify coder of  the arrival of a new sample */
		out unsigned bit[BITS_PER_FRAME-1:0] serial,       /* 244 bits encoded block                      */
		out DTXctrl txdtx_ctrl,                            /* DTX control word (for debugging)            */
		out event serialbits_ready)                        /* a new encoded block is available            */
  implements Ireset;


note Coder.comment = "GSM Enhanced Full Rate speech encoder (GSM 06.60)";

note Coder.functionality = "The EFR Coder maps 160 speech samples in 13-bit uniform PCM format to encoded blocks of 244 bits according to the GSM technical specification GSM 06.60, version 5.1.1.";

note Coder.scc_ReservedSize = 20000u;     // actual value 10764u! (but we keep it secret)
note Coder.scc_Public = true;
