/************************************************************************\
 *                                                                      *
 * Copyright 2003 Stretch, Inc. All rights reserved.                    *
 *                                                                      *
 * THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF *
 * STRETCH, INC. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT *
 * THE PRIOR EXPRESS WRITTEN PERMISSION OF STRETCH, INC.                *
 *                                                                      *
 * THIS SOFTWARE IS CONSIDERED AS "REDISTRIBUTABLES" AND ITS USE IS     *
 * SUBJECT TO THE TERMS AND CONDITIONS OUTLINED IN STRETCH'S SOFTWARE   *
 * LICENSE AGREEMENT                                                    *
 *                                                                      *
 \************************************************************************/


#include <sx-timer.h>
#include "data.h"
#include "rgb2ycc.h"
#include <time.h>

signed char ycc[3 * NP];

int 
rgb2ycc_wrapper(signed char *RGB, signed char *ycc)
{
  WR A, B;
  int i, n;

  unsigned cb, ce;

  cb = clock();

  for (n = 0; n < NUM; n++) {
    WRGET0INIT(0, RGB);	/* initialize input stream from RGB */
    WRPUTINIT(0, ycc);	/* initialize output stream to ycc */

    /* loop over RGB data, converting 5 pixels at a time */
    for (i = 0; i < NP/5; i++) {
      WRGET0I(&A, 15);	/* load 5 RGB pixels to A */
      rgb2ycc(A, &B);	/* convert 5 pixels */
      WRPUTI(B, 15);	/* store 5 YCbCr pixels from B */
    }

    WRPUTFLUSH();  /* flush output stream */
  }

  ce = clock();
  return ce - cb;
}

int main()
{
  int i, err=0;
  unsigned cycles;

  /* dummy instruction to cause ISEF to be loaded */
  WR X, Y;
  rgb2ycc(X, &Y);	

  cycles = rgb2ycc_wrapper(RGB, ycc);

  for (i = 0; i < 3 * NP; i++) {
    err |= YCC[i] != ycc[i];
  }

  if (err) {
    printf("Error\n");
  } else {
    printf("Cycles: %u\n", cycles);
    printf("Pixels: %d\n", NP * NUM);
    printf("Performance: %.2f\n", cycles * 1.0 / (NUM * NP));
    printf("Pass\n", err ? "Error" : "Pass");
  }

  return err;
}
