/*
 * SpecC MPEG 3 audio decoder
 * Copyright (C) 2006-2007 CECS, UC Irvine
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: testbench.sc,v 1.7 2007/09/27 18:17:56 gerstl Exp $
 * 
 * $Log: testbench.sc,v $
 * Revision 1.7  2007/09/27 18:17:56  gerstl
 * Public release of SpecC model (based on libmad MP3 library).
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h> 

import "c_queue";

#ifdef DBG_FRAME_INFO
import "c_handshake";
#endif

import "mp3stimulus";
import "mp3decoder";
import "mp3monitor";

#define S2D_BUFSIZE 1024ul 
#define D2M_BUFSIZE 1152ul * 4ul   // one frame


interface IMP3Decoder {
#if 1
  void open_file(const char* mp3file_name, const char* pcmfile_name);
#else
  int open_file(const char* mp3file_name, const char* pcmfile_name);
#endif
};

behavior MP3Decoder(in unsigned long nframes)
  implements IMP3Decoder
{
  c_queue stream_in((S2D_BUFSIZE));
  c_queue pcm_out((D2M_BUFSIZE));
#ifdef SIGNAL_TYPE_ERROR
  signal enum mad_error decoder_error;
#else
  c_mad_error_double_handshake decoder_error;
#endif
#ifdef DBG_FRAME_INFO
  c_handshake newFrame;
#endif
  

  
  Mad_Stimulus stimulus(stream_in);
  Mad_decoder decoder(stream_in, pcm_out, decoder_error
#ifdef DBG_FRAME_INFO
                      ,newFrame
#endif
#ifdef EXTERN_CONTROL
                      , mp3Continue, mp3Pause
#endif
                      );
  Mad_Monitor monitor(pcm_out, nframes
#ifdef DBG_FRAME_INFO
                      ,newFrame
#endif
                      );
  Mad_Error   error(decoder_error);

  void open_file(const char* mp3file_name, const char* pcmfile_name)
  {
#if 1
    stimulus.open_file(mp3file_name);
    monitor.open_file(pcmfile_name);
#else
    if (!stimulus.open_file(mp3file_name))
      return 0;
    if (!monitor.open_file(pcmfile_name))
      return 0;

    return 1;
#endif
    
  }
  
  void main(void)
  {
    par {
      stimulus.main();
      decoder.main();
      monitor.main();
      error.main();
    }
  }  
};


behavior Main()
{
  unsigned long nframes = -1;
  
  MP3Decoder mp3decoder(nframes);
  
  int main (int argc, char *argv[])
  {
    const char *mp3file_name, *pcmfile_name;

    if((argc < 3) || (argc > 4))
    {
      fprintf(stderr, "Usage: %s <MP3 file> <PCM file> [<number of frames>]\n\n", argv[0]);
      return -1;
    }

    if (argc > 3) {
      if(!sscanf(argv[3], "%lu", &nframes)) {
        fprintf(stderr, "Invalid argument!\n\n");
        return -1;
      }
    }
    
    mp3file_name = argv[1];
    pcmfile_name = argv[2];
    
#if 1
    mp3decoder.open_file(mp3file_name, pcmfile_name);
#else
    if (!mp3decoder.open_file(mp3file_name, pcmfile_name))
      return -1;
#endif

    mp3decoder.main();
    
    return (0);
  }
};

