/*
 * libmad - MPEG audio decoder library
 * Copyright (C) 2006-2007 CECS, UC Irvine
 * Copyright (C) 2000-2004 Underbit Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: sideinfo.sc,v 1.3 2007/09/27 18:17:56 gerstl Exp $
 * 
 * $Log: sideinfo.sc,v $
 * Revision 1.3  2007/09/27 18:17:56  gerstl
 * Public release of SpecC model (based on libmad MP3 library).
 *
 */

# include "global.sh"

# include "stream.sh"
# include "frame.sh"
# include "layer3.sh"

import "bit";


behavior Sideinfo(struct mad_stream stream,
                  struct mad_header header,
                  in unsigned int nch,
                  out unsigned int si_main_data_begin,
                  out unsigned int si_private_bits,
                  out unsigned char si_scfsi[2],
                  out struct sideinfo_channel si_ch0[2],
                  out struct sideinfo_channel si_ch1[2],
                  out unsigned int data_bitlen,
                  out unsigned int priv_bitlen,
                  enum mad_error error)
{
  /*
   * NAME:	III_sideinfo()
   * DESCRIPTION:	decode frame side information from a bitstream
   */
  enum mad_error III_sideinfo(struct mad_bitptr *ptr, int lsf, unsigned ch,
                              unsigned char *si_scfsi,
                              struct sideinfo_channel *si_channel,
                              unsigned int *dbl)                              
  {
    unsigned int i;
    enum mad_error result;
    result = MAD_ERROR_NONE;
    
        si_channel->part2_3_length    = mad_bit_read(ptr, 12);
        si_channel->big_values        = mad_bit_read(ptr, 9);
        si_channel->global_gain       = mad_bit_read(ptr, 8);
        si_channel->scalefac_compress = mad_bit_read(ptr, lsf ? 9 : 4);
        
        *dbl += si_channel->part2_3_length;
        
        if (si_channel->big_values > 288 && result == 0)
          result = MAD_ERROR_BADBIGVALUES;
        
        si_channel->flags = 0;
        
        /* window_switching_flag */
        if (mad_bit_read(ptr, 1)) {
          si_channel->block_type = mad_bit_read(ptr, 2);
          
          if (si_channel->block_type == 0 && result == 0)
            result = MAD_ERROR_BADBLOCKTYPE;
          
          if (!lsf && si_channel->block_type == 2 && si_scfsi[ch] && result == 0)
            result = MAD_ERROR_BADSCFSI;
          
          si_channel->region0_count = 7;
          si_channel->region1_count = 36;
          
          if (mad_bit_read(ptr, 1))
            si_channel->flags |= mixed_block_flag;
          else if (si_channel->block_type == 2)
            si_channel->region0_count = 8;
          
          for (i = 0; i < 2; ++i)
            si_channel->table_select[i] = mad_bit_read(ptr, 5);
          
# if defined(DEBUG)
          si_channel->table_select[2] = 4;  /* not used */
# endif
          
          for (i = 0; i < 3; ++i)
            si_channel->subblock_gain[i] = mad_bit_read(ptr, 3);
        }
        else {
          si_channel->block_type = 0;
          
          for (i = 0; i < 3; ++i)
            si_channel->table_select[i] = mad_bit_read(ptr, 5);
          
          si_channel->region0_count = mad_bit_read(ptr, 4);
          si_channel->region1_count = mad_bit_read(ptr, 3);
        }
        
        /* [preflag,] scalefac_scale, count1table_select */
        si_channel->flags |= mad_bit_read(ptr, lsf ? 2 : 3);
    
    return result;
  }
  

  void main(void)
  {
    struct mad_bitptr *bitptr;
    unsigned int ngr, ch, dbl, pbl, lsf;

    bitptr = &stream.ptr;
    lsf = header.flags & MAD_FLAG_LSF_EXT;
    
    data_bitlen = dbl = 0;
    priv_bitlen = pbl = lsf ? ((nch == 1) ? 1 : 2) : ((nch == 1) ? 5 : 3);
    
    si_main_data_begin = mad_bit_read(bitptr, lsf ? 8 : 9);
    si_private_bits    = mad_bit_read(bitptr, pbl);
    
    ngr = 1;
    if (!lsf) {
      ngr = 2;
      
      for (ch = 0; ch < nch; ++ch)
        si_scfsi[ch] = mad_bit_read(bitptr, 4);
    }
    
    error = III_sideinfo(bitptr, lsf, 0, &si_scfsi[0], &si_ch0[0], &dbl);
    if (error) return;
    if (nch > 1) {
      error = III_sideinfo(bitptr, lsf, 1, &si_scfsi[0], &si_ch1[0], &dbl);
      if (error) return;
    }
    
    if (ngr > 1) {
      error = III_sideinfo(bitptr, lsf, 0, &si_scfsi[0], &si_ch0[1], &dbl);
      if (error) return;
      if (nch > 1) {
        error = III_sideinfo(bitptr, lsf, 1, &si_scfsi[0], &si_ch1[1], &dbl);
        if (error) return;
      }
    }      
        
    data_bitlen = dbl;
    priv_bitlen = pbl;
  }
};
