/*
 * SpecC MPEG 3 audio decoder
 * Copyright (C) 2006-2007 CECS, UC Irvine
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: mp3stimulus.sc,v 1.5 2007/09/27 18:17:56 gerstl Exp $
 * 
 * $Log: mp3stimulus.sc,v $
 * Revision 1.5  2007/09/27 18:17:56  gerstl
 * Public release of SpecC model (based on libmad MP3 library).
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

import "i_sender";

#ifdef EXTERN_CONTROL
import "i_receive";
#endif

#define S2D_CHUNKSIZE 256

interface IMad_Stimulus {
  int open_file (const char* mp3file_name);
};


behavior Mad_Stimulus(i_sender stream_in
#ifdef EXTERN_CONTROL
                  , in char* mp3file_name, i_receive mp3Start
#endif
)
  implements IMad_Stimulus
{
  FILE *file_handle; 
  //unsigned int mp3Pause = 0;
  
  int open_file(const char* pMp3file_name)
  {    
    if ((file_handle = fopen (pMp3file_name, "rb")) == NULL ) {
      fprintf(stderr, "Error opening input file %s!\n", pMp3file_name);
      return 0;
    }
    fprintf (stderr, "Input MP3file:\t%s\n", pMp3file_name);
    return 1;
  }
  
  void main(void) 
  {
    //GS unused int i;
    size_t len;
    char buf[S2D_CHUNKSIZE];

#ifdef EXTERN_CONTROL
    // wait for the initial kick off
    mp3Start.receive();

    if(!file_handle) {
      open_file(mp3file_name);
    }
#endif

    while(1) 
    {

      len = fread(buf, sizeof(char), S2D_CHUNKSIZE, file_handle);
      
      if (!len)
        break;

      stream_in.send(buf, len);
       /* measure time it took for decoding last frame */
   }
    
    fclose(file_handle);
    file_handle = 0;
    
#ifdef EXTERN_CONTROL
    // NICE: no waitfor no exit from the simulus!!
    // The control behavior pulls the trigger. 
#else    
    /* Empirical results show that it takes about 
       3 frames after the last read. To be safe 
       wait for 7 frames and exit then. */
    waitfor(7*26600000000ull); // 7 frames wait who cares
    printf("MP3 Stimulus exit\n");
    exit (0);
#endif
  }
};


