/*
 * SpecC MPEG 3 audio decoder
 * Copyright (C) 2006-2007 CECS, UC Irvine
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: io.sc,v 1.6 2007/09/27 18:17:56 gerstl Exp $
 * 
 * $Log: io.sc,v $
 * Revision 1.6  2007/09/27 18:17:56  gerstl
 * Public release of SpecC model (based on libmad MP3 library).
 *
 */

# include "global.sh"

import "global";

# include "fixed.sh"
# include "stream.sh"
# include "decoder.sh"

import "i_receiver";

#ifndef SIGNAL_TYPE_ERROR
#include <c_typed_double_handshake.sh>

DEFINE_I_TYPED_SENDER(mad_error, int)
DEFINE_I_TYPED_RECEIVER(mad_error, int)
DEFINE_I_TYPED_TRANCEIVER(mad_error, int)
DEFINE_C_TYPED_DOUBLE_HANDSHAKE(mad_error, int)
#endif


/* size of chunks to send to output (in number of samples = bytes / 4) */
#ifdef PCM_SAMPLEWISE_OUTPUT
#define CHUNK_SAMPLE_SIZE (1152)
#else
#define CHUNK_SAMPLE_SIZE 32
#endif

/*GS do not scale again the samples. Scaling is already performed 
  in the core and double scaling kills the signal */
#define RAW_SAMPLES


behavior Mad_input(i_receiver stream_in,
		   int more_input,
		   out enum mad_flow flow,
		   struct mad_stream stream)
{
  void main(void)
  {
    /* shift data in buffer to left and remove already processed data */
    if (stream.this_frame != stream.buffer) {
      uln delta;
      
      delta = (unsigned char*)stream.this_frame - stream.buffer;

      mymemmove(stream.buffer, stream.this_frame, 
		(stream.bufend - (unsigned char*)stream.this_frame));
      
      stream.this_frame -= delta;
      stream.next_frame -= delta;
      stream.bufend -= delta;
      if(stream.ptr.byte) stream.ptr.byte -= delta;
      if(stream.anc_ptr.byte) stream.anc_ptr.byte -= delta;
    }
    
    if (more_input <= 0) more_input = MAD_BUFFER_GUARD;
    more_input = ((unsigned char*)stream.next_frame + more_input) - stream.bufend;
    if (more_input <= 0) {
      return;
    }
    
    if (((stream.bufend - stream.buffer) + more_input) > MAD_BUFFER_FRAMELEN) {
      stream.error = MAD_ERROR_NOMEM;
      flow = MAD_FLOW_BREAK;
      return;
    }      
    
    stream_in.receive(stream.bufend, more_input);
    
    stream.bufend += more_input;
  }
};

