/*
 * libmad - MPEG audio decoder library 
 * Copyright (C) 2006-2007 CECS, UC Irvine
 * Copyright (C) 2000-2004 Underbit Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: global.sc,v 1.2 2007/09/27 18:17:56 gerstl Exp $
 * 
 * $Log: global.sc,v $
 * Revision 1.2  2007/09/27 18:17:56  gerstl
 * Public release of SpecC model (based on libmad MP3 library).
 *
 */

# include "global.sh"


//PC: introducing my version of memcpy
void mymemcpy (void* dest, const void* src, int size)
{
	char *mDest, *mSrc;
        mDest = (char*)dest;
	mSrc = (char*)src;
	for(; size != 0; --size, ++mDest, ++mSrc)
		*mDest = *mSrc;
}
void mymemmove(void* dest, const void* src, int size)
{
	if (src > dest)
		mymemcpy(dest, src, size);
	else
	{
		char *mDest, *mSrc;
                mDest = (char*)dest+(size-1);
		mSrc = (char*)src+(size-1);
		for(; size != 0; --size, --mDest, --mSrc)
			*mDest = *mSrc;
	}
}

