/*
 * libmad - MPEG audio decoder library
 * Copyright (C) 2006-2007 CECS, UC Irvine
 * Copyright (C) 2000-2004 Underbit Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: frame.sc,v 1.2 2007/09/27 18:17:56 gerstl Exp $
 * 
 * $Log: frame.sc,v $
 * Revision 1.2  2007/09/27 18:17:56  gerstl
 * Public release of SpecC model (based on libmad MP3 library).
 *
 */

# include "global.sh"

# include "stream.sh"
# include "frame.sh"

import "layer3";

  
behavior Mad_frame_decode_init(struct mad_header header, 
			       struct mad_stream stream,
			       out int frame_options,
			       out int result)
{
  void main(void)
  {
    register unsigned char const *ptr;
    
    frame_options = stream.options;
    
    /* header() */
    /* error_check() */
    
    if (!(header.flags & MAD_FLAG_INCOMPLETE)) {
      result = -1;
      stream.error = MAD_ERROR_NONE;
      return;	
    }
    
    header.flags &= ~MAD_FLAG_INCOMPLETE;

    if (header.layer != MAD_LAYER_III) {
      stream.error = MAD_ERROR_BADLAYER;
      result = -1;
      return;
    }
    
    if (!stream.sync) {
      /* check that a valid frame header follows this frame */
      
      ptr = stream.next_frame;
      if (!(ptr[0] == 0xff && (ptr[1] & 0xe0) == 0xe0)) {
	ptr = stream.next_frame = stream.this_frame + 1;
	stream.error = MAD_ERROR_LOSTSYNC;
	result = -1;
	return;
      }
      
      stream.sync = 1;
    }
    
    result = 0;
  }
};


behavior Mad_frame_decode_fail(struct mad_stream stream)
{
  void main(void)
  {
    if (!MAD_RECOVERABLE(stream.error))
      stream.next_frame = stream.this_frame;

    stream.anc_bitlen = 0;
  }
};


/*
 * NAME:	frame->decode()
 * DESCRIPTION:	decode a single frame from a bitstream
 */
behavior Mad_frame_decode(struct mad_header header,
			  struct mad_stream stream,
			      mad_fixed_t frame_overlap[32][18],
			  out mad_fixed_t frame_sbsample[36][32],
			      mad_fixed_t frame_overlap2[32][18],
			  out mad_fixed_t frame_sbsample2[36][32],
			  int result)
{
  int frame_options = 0;
  
  Mad_frame_decode_init init(header, stream, frame_options, result);

  Mad_layer_III layer_III(stream, header, frame_options,
		          frame_overlap, frame_sbsample,
		          frame_overlap2, frame_sbsample2,
			  result);
  
  Mad_frame_decode_fail fail(stream);
  

  void main(void)
  {
    fsm {
      init: {
	if (result < 0) break;
      }
      
      layer_III: {
	if (result < 0) goto fail;
	break;
      }
      
      fail:
    }
  }
};



/*
 * NAME:	frame->mute()
 * DESCRIPTION:	zero all subband values so the frame becomes silent
 */
behavior Mad_frame_mute(out mad_fixed_t frame_overlap[32][18],
			out mad_fixed_t frame_sbsample[36][32],
			out mad_fixed_t frame_overlap2[32][18],
			out mad_fixed_t frame_sbsample2[36][32])
{
  void main(void)
  {    
    unsigned int s, sb;
    
    for (s = 0; s < 36; ++s) {
      for (sb = 0; sb < 32; ++sb) {
	frame_sbsample[s][sb] = 0;
	frame_sbsample2[s][sb] = 0;
      }
    }
    
    for (s = 0; s < 18; ++s) {
      for (sb = 0; sb < 32; ++sb) {
	frame_overlap[sb][s] = 0;
	frame_overlap2[sb][s] = 0;
      }
    }
  }
};

