/* All Rights Reserved - 2000 */

/*--------------------------------------------------------------------------*/

#include "codec.h"

/*--------------------------------------------------------------------------*/

static const short COS_TABLE[8][8] = {
    
    { 32768,  32138,  30273,  27245,  23170,  18204,  12539,   6392 },
    { 32768,  27245,  12539,  -6392, -23170, -32138, -30273, -18204 },
    { 32768,  18204, -12539, -32138, -23170,   6392,  30273,  27245 },
    { 32768,   6392, -30273, -18204,  23170,  27245, -12539, -32138 },
    { 32768,  -6392, -30273,  18204,  23170, -27245, -12539,  32138 },
    { 32768, -18204, -12539,  32138, -23170,  -6392,  30273, -27245 },
    { 32768, -27245,  12539,   6392, -23170,  32138, -30273,  18204 },
    { 32768, -32138,  30273, -27245,  23170, -18204,  12539,  -6392 }
};

/*--------------------------------------------------------------------------*/

static const short ONE_OVER_SQRT_TWO = 23170;

/*--------------------------------------------------------------------------*/

static short buffer[8][8];
static int idx;

/*--------------------------------------------------------------------------*/

static double Y(int a, int b) {
    
    return COS_TABLE[a][b] / 32768.0;
}

/*--------------------------------------------------------------------------*/

static double C(int h) {
    
    return h ? 1.0 : ONE_OVER_SQRT_TWO / 32768.0;
}

/*--------------------------------------------------------------------------*/

static int F(int u, int v, short img[8][8]) {
    
    double s[8], r = 0;
    int x;
    
    for(x=0; x<8; x++) {
        
        s[x] = 
            img[x][0] * Y(0, v) +
            img[x][1] * Y(1, v) +
            img[x][2] * Y(2, v) +
            img[x][3] * Y(3, v) +
            img[x][4] * Y(4, v) +
            img[x][5] * Y(5, v) +
            img[x][6] * Y(6, v) +
            img[x][7] * Y(7, v);
    }
    
    for(x=0; x<8; x++) {
        
        r += s[x] * Y(x, u);
    }
    
    return (short)(r * .25 * C(u) * C(v));
}

/*--------------------------------------------------------------------------*/

void CodecInitialize(void) {
    
    idx = 0;
}

/*--------------------------------------------------------------------------*/

void CodecPushPixel(short p) {
    
    if( idx == 64 ) {
        
        idx = 0;
    }
    
    buffer[idx / 8][idx % 8] = p;
    idx++;
}

/*--------------------------------------------------------------------------*/

short CodecPopPixel(void) {
    
    short p;
    
    if( idx == 64 ) {
        
        idx = 0;
    }
    
    p = buffer[idx / 8][idx % 8];
    idx++;
    return p;
}

/*--------------------------------------------------------------------------*/

void CodecDoFdct(void) {
    
    int x, y;
    short tempBuffer[8][8];
    
    for(x=0; x<8; x++) {
        
        for(y=0; y<8; y++) {
            
            tempBuffer[x][y] = F(x, y, buffer);
        }
    }
    for(x=0; x<8; x++) {
        
        for(y=0; y<8; y++) {
            
            buffer[x][y] = tempBuffer[x][y];
        }
    }
    idx = 0;
}
