--
-- Copyright (c) 1999-2000 University of California, Riverside.
-- Permission to copy is granted provided that this header remains
-- intact.  This software is provided with no warranties.
--
-- Version : 1.0
--

-------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;

-------------------------------------------------------------------------------

entity SDRAM is

    generic(STORAGE_SIZE : INTEGER := 1024);

    port(rst      : in  STD_LOGIC;
         clk      : in  STD_LOGIC;
         addr     : in  UNSIGNED (15 downto 0);
         in_data  : in  UNSIGNED (7 downto 0);
         out_data : out UNSIGNED (7 downto 0);
         rd       : in  STD_LOGIC;
         wr       : in  STD_LOGIC);
end SDRAM;

-------------------------------------------------------------------------------

architecture BHV of SDRAM is

    constant CD_8 : UNSIGNED (7 downto 0) := "--------";
    constant CZ_8 : UNSIGNED (7 downto 0) := "ZZZZZZZZ";

    type MEM_TYPE is array (0 to STORAGE_SIZE-1) of UNSIGNED (7 downto 0);
    
    signal mem : MEM_TYPE;
begin

    process(rst, clk)
    begin

        if( rst = '1' ) then

            for i in 0 to STORAGE_SIZE-1 loop

                mem(i) <= CD_8;
            end loop;

            out_data <= CZ_8;
            
        elsif( clk'event and clk = '1' ) then

            out_data <= CZ_8;

            if( rd = '1' and conv_integer(addr) < storage_size ) then

                out_data <= mem(conv_integer(addr));
            elsif( wr = '1' and conv_integer(addr) < storage_size ) then

                mem(conv_integer(addr)) <= in_data; 
            end if;
        end if;
    end process;
end BHV;
