-- digcam.hex 

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use WORK.I8051_LIB.all;

entity I8051_ROM is
    port(rst      : in  STD_LOGIC;
         clk      : in  STD_LOGIC;
         addr     : in  UNSIGNED (11 downto 0);
         data     : out UNSIGNED (7 downto 0);
         rd       : in  STD_LOGIC);
end I8051_ROM;

architecture BHV of I8051_ROM is

    type ROM_TYPE is array (0 to 791) of UNSIGNED (7 downto 0);

    constant PROGRAM : ROM_TYPE := (

	"00000010",	-- LJMP   
	"00000011",
	"00001010",
	"00100010",	-- RET    
	"10010000",	-- MOV_18 
	"11111111",
	"11111100",
	"01110100",	-- MOV_4  
	"00000001",
	"11110000",	-- MOVX_4 
	"10010000",	-- MOV_18 
	"11111111",
	"11111011",
	"11100000",	-- MOVX_2 
	"01100100",	-- XRL_4  
	"00000001",
	"01100000",	-- JZ     
	"11111000",
	"00100010",	-- RET    
	"10010000",	-- MOV_18 
	"11111111",
	"11111101",
	"11100000",	-- MOVX_2 
	"11111111",	-- MOV_5  
	"00100010",	-- RET    
	"00100010",	-- RET    
	"00010010",	-- LCALL  
	"00000000",
	"00000100",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001000",
	"11110101",	-- MOV_8  
	"00001001",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001010",
	"11110101",	-- MOV_8  
	"00001011",
	"00010010",	-- LCALL  
	"00000000",
	"00010011",
	"11101111",	-- MOV_1  
	"11111101",	-- MOV_5  
	"00110011",	-- RLC    
	"10010101",	-- SUBB_2 
	"11100000",
	"11111100",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001011",
	"00100101",	-- ADD_2  
	"11100000",
	"11111011",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001010",
	"00110011",	-- RLC    
	"11111010",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001001",
	"10101110",	-- MOV_6  
	"00001000",
	"01111000",	-- MOV_7  
	"00000101",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100100",	-- ADD_4  
	"00000000",
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000000",
	"11110101",	-- MOV_8  
	"10000011",
	"11100101",	-- MOV_2  
	"10000010",
	"00101011",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101010",	-- MOV_1  
	"00110101",	-- ADDC_2 
	"10000011",
	"11110101",	-- MOV_8  
	"10000011",
	"11101100",	-- MOV_1  
	"11110000",	-- MOVX_4 
	"10100011",	-- INC_5  
	"11101101",	-- MOV_1  
	"11110000",	-- MOVX_4 
	"00000101",	-- INC_3  
	"00001011",
	"11100101",	-- MOV_2  
	"00001011",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001010",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00001011",
	"10010100",	-- SUBB_4 
	"00010000",
	"11100101",	-- MOV_2  
	"00001010",
	"10010100",	-- SUBB_4 
	"00000000",
	"01000000",	-- JC     
	"10110110",
	"00000101",	-- INC_3  
	"00001001",
	"11100101",	-- MOV_2  
	"00001001",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001000",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00001001",
	"10010100",	-- SUBB_4 
	"00010000",
	"11100101",	-- MOV_2  
	"00001000",
	"10010100",	-- SUBB_4 
	"00000000",
	"01000000",	-- JC     
	"10011110",
	"00100010",	-- RET    
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001000",
	"11110101",	-- MOV_8  
	"00001001",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001010",
	"11110101",	-- MOV_8  
	"00001011",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001100",
	"11110101",	-- MOV_8  
	"00001101",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001110",
	"11110101",	-- MOV_8  
	"00001111",
	"11100101",	-- MOV_2  
	"00001011",
	"10101110",	-- MOV_6  
	"00001010",
	"01111000",	-- MOV_7  
	"00000011",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100101",	-- ADD_2  
	"00001111",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001110",
	"00111110",	-- ADDC_1 
	"11111110",	-- MOV_5  
	"11101111",	-- MOV_1  
	"00100101",	-- ADD_2  
	"11100000",
	"11111101",	-- MOV_5  
	"11101110",	-- MOV_1  
	"00110011",	-- RLC    
	"11111100",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001001",
	"10101110",	-- MOV_6  
	"00001000",
	"01111000",	-- MOV_7  
	"00000011",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100101",	-- ADD_2  
	"00001101",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001100",
	"00111110",	-- ADDC_1 
	"11111110",	-- MOV_5  
	"11101111",	-- MOV_1  
	"01111000",	-- MOV_7  
	"00000101",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100100",	-- ADD_4  
	"00000000",
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000000",
	"11110101",	-- MOV_8  
	"10000011",
	"11100101",	-- MOV_2  
	"10000010",
	"00101101",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101100",	-- MOV_1  
	"00110101",	-- ADDC_2 
	"10000011",
	"11110101",	-- MOV_8  
	"10000011",
	"11100000",	-- MOVX_2 
	"10100011",	-- INC_5  
	"11100000",	-- MOVX_2 
	"11111111",	-- MOV_5  
	"00110011",	-- RLC    
	"10010101",	-- SUBB_2 
	"11100000",
	"11111110",	-- MOV_5  
	"00010010",	-- LCALL  
	"00000010",
	"10101110",
	"00000101",	-- INC_3  
	"00001111",
	"11100101",	-- MOV_2  
	"00001111",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001110",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00001111",
	"10010100",	-- SUBB_4 
	"00001000",
	"11100101",	-- MOV_2  
	"00001110",
	"10010100",	-- SUBB_4 
	"00000000",
	"01000000",	-- JC     
	"10010110",
	"00000101",	-- INC_3  
	"00001101",
	"11100101",	-- MOV_2  
	"00001101",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001100",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00001101",
	"10010100",	-- SUBB_4 
	"00001000",
	"11100101",	-- MOV_2  
	"00001100",
	"10010100",	-- SUBB_4 
	"00000000",
	"01010000",	-- JNC    
	"00000011",
	"00000010",	-- LJMP   
	"00000000",
	"10010100",
	"00010010",	-- LCALL  
	"00000010",
	"11000111",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001100",
	"11110101",	-- MOV_8  
	"00001101",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001110",
	"11110101",	-- MOV_8  
	"00001111",
	"00010010",	-- LCALL  
	"00000010",
	"10110100",
	"11100101",	-- MOV_2  
	"00001101",
	"01110101",	-- MOV_12 
	"11110000",
	"00001000",
	"10100100",	-- MUL    
	"00100100",	-- ADD_4  
	"01101101",
	"11110101",	-- MOV_8  
	"10000010",
	"11100100",	-- CLR_1  
	"00110100",	-- ADDC_4 
	"00000010",
	"11110101",	-- MOV_8  
	"10000011",
	"11100101",	-- MOV_2  
	"10000010",
	"00100101",	-- ADD_2  
	"00001111",
	"11110101",	-- MOV_8  
	"10000010",
	"11100100",	-- CLR_1  
	"00110101",	-- ADDC_2 
	"10000011",
	"11110101",	-- MOV_8  
	"10000011",
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"11111101",	-- MOV_5  
	"11101111",	-- MOV_1  
	"10101000",	-- MOV_6  
	"00000101",
	"00001000",	-- INC_2  
	"10000000",	-- SJMP   
	"00000110",
	"11001110",	-- XCH_1  
	"10100010",	-- MOV_16 
	"11100111",
	"00010011",	-- RRC    
	"11001110",	-- XCH_1  
	"00010011",	-- RRC    
	"11011000",	-- DJNZ_1 
	"11111000",
	"11111101",	-- MOV_5  
	"10101100",	-- MOV_6  
	"00000110",
	"11100101",	-- MOV_2  
	"00001011",
	"10101110",	-- MOV_6  
	"00001010",
	"01111000",	-- MOV_7  
	"00000011",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100101",	-- ADD_2  
	"00001111",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001110",
	"00111110",	-- ADDC_1 
	"11111110",	-- MOV_5  
	"11101111",	-- MOV_1  
	"00100101",	-- ADD_2  
	"11100000",
	"11111011",	-- MOV_5  
	"11101110",	-- MOV_1  
	"00110011",	-- RLC    
	"11111010",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001001",
	"10101110",	-- MOV_6  
	"00001000",
	"01111000",	-- MOV_7  
	"00000011",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100101",	-- ADD_2  
	"00001101",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001100",
	"00111110",	-- ADDC_1 
	"11111110",	-- MOV_5  
	"11101111",	-- MOV_1  
	"01111000",	-- MOV_7  
	"00000101",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100100",	-- ADD_4  
	"00000000",
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000000",
	"11110101",	-- MOV_8  
	"10000011",
	"11100101",	-- MOV_2  
	"10000010",
	"00101011",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101010",	-- MOV_1  
	"00110101",	-- ADDC_2 
	"10000011",
	"11110101",	-- MOV_8  
	"10000011",
	"11101100",	-- MOV_1  
	"11110000",	-- MOVX_4 
	"10100011",	-- INC_5  
	"11101101",	-- MOV_1  
	"11110000",	-- MOVX_4 
	"00000101",	-- INC_3  
	"00001111",
	"11100101",	-- MOV_2  
	"00001111",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001110",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00001111",
	"10010100",	-- SUBB_4 
	"00001000",
	"11100101",	-- MOV_2  
	"00001110",
	"10010100",	-- SUBB_4 
	"00000000",
	"01010000",	-- JNC    
	"00000011",
	"00000010",	-- LJMP   
	"00000001",
	"00100110",
	"00000101",	-- INC_3  
	"00001101",
	"11100101",	-- MOV_2  
	"00001101",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001100",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00001101",
	"10010100",	-- SUBB_4 
	"00001000",
	"11100101",	-- MOV_2  
	"00001100",
	"10010100",	-- SUBB_4 
	"00000000",
	"01010000",	-- JNC    
	"00000011",
	"00000010",	-- LJMP   
	"00000001",
	"00100001",
	"00000101",	-- INC_3  
	"00001011",
	"11100101",	-- MOV_2  
	"00001011",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001010",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00001011",
	"10010100",	-- SUBB_4 
	"00000010",
	"11100101",	-- MOV_2  
	"00001010",
	"10010100",	-- SUBB_4 
	"00000000",
	"01010000",	-- JNC    
	"00000011",
	"00000010",	-- LJMP   
	"00000000",
	"10001111",
	"00000101",	-- INC_3  
	"00001001",
	"11100101",	-- MOV_2  
	"00001001",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001000",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00001001",
	"10010100",	-- SUBB_4 
	"00000010",
	"11100101",	-- MOV_2  
	"00001000",
	"10010100",	-- SUBB_4 
	"00000000",
	"01010000",	-- JNC    
	"00000011",
	"00000010",	-- LJMP   
	"00000000",
	"10001010",
	"00100010",	-- RET    
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001010",
	"11110101",	-- MOV_8  
	"00001011",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001100",
	"11110101",	-- MOV_8  
	"00001101",
	"11100101",	-- MOV_2  
	"00001101",
	"00100101",	-- ADD_2  
	"11100000",
	"11111101",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001100",
	"00110011",	-- RLC    
	"11111100",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001011",
	"10101110",	-- MOV_6  
	"00001010",
	"01111000",	-- MOV_7  
	"00000101",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100100",	-- ADD_4  
	"00000000",
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000000",
	"11110101",	-- MOV_8  
	"10000011",
	"11100101",	-- MOV_2  
	"10000010",
	"00101101",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101100",	-- MOV_1  
	"00110101",	-- ADDC_2 
	"10000011",
	"11110101",	-- MOV_8  
	"10000011",
	"11100000",	-- MOVX_2 
	"11111110",	-- MOV_5  
	"10100011",	-- INC_5  
	"11100000",	-- MOVX_2 
	"10001110",	-- MOV_9  
	"00001000",
	"11110101",	-- MOV_8  
	"00001001",
	"10101111",	-- MOV_6  
	"00001000",
	"00010010",	-- LCALL  
	"00000010",
	"11111110",
	"10101111",	-- MOV_6  
	"00001001",
	"00010010",	-- LCALL  
	"00000010",
	"11111110",
	"00000101",	-- INC_3  
	"00001101",
	"11100101",	-- MOV_2  
	"00001101",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001100",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00001101",
	"10010100",	-- SUBB_4 
	"00010000",
	"11100101",	-- MOV_2  
	"00001100",
	"10010100",	-- SUBB_4 
	"00000000",
	"01000000",	-- JC     
	"10110010",
	"00000101",	-- INC_3  
	"00001011",
	"11100101",	-- MOV_2  
	"00001011",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001010",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00001011",
	"10010100",	-- SUBB_4 
	"00010000",
	"11100101",	-- MOV_2  
	"00001010",
	"10010100",	-- SUBB_4 
	"00000000",
	"01000000",	-- JC     
	"10011010",
	"00100010",	-- RET    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000001",	-- AJMP   
	"00000001",
	"00000001",	-- AJMP   
	"00000001",
	"00000001",	-- AJMP   
	"00000001",
	"00000001",	-- AJMP   
	"00000001",
	"00000001",	-- AJMP   
	"00000001",
	"00000010",	-- LJMP   
	"00000010",
	"00000010",
	"00000010",	-- LJMP   
	"00000010",
	"00000010",
	"00000010",	-- LJMP   
	"00000010",
	"00000010",
	"00000011",	-- RR     
	"00000011",	-- RR     
	"00000011",	-- RR     
	"00000011",	-- RR     
	"00000011",	-- RR     
	"00000011",	-- RR     
	"00000011",	-- RR     
	"00000011",	-- RR     
	"00000100",	-- INC_1  
	"00000100",	-- INC_1  
	"00000100",	-- INC_1  
	"00000100",	-- INC_1  
	"00000100",	-- INC_1  
	"00000100",	-- INC_1  
	"00000100",	-- INC_1  
	"00000101",	-- INC_3  
	"00000101",
	"00000101",	-- INC_3  
	"00000101",
	"00000101",	-- INC_3  
	"00000101",
	"00000110",	-- INC_4  
	"00000110",	-- INC_4  
	"00000110",	-- INC_4  
	"00000110",	-- INC_4  
	"00000110",	-- INC_4  
	"00000111",	-- INC_4  
	"00000111",	-- INC_4  
	"00000111",	-- INC_4  
	"00000111",	-- INC_4  
	"00001000",	-- INC_2  
	"00001000",	-- INC_2  
	"00001000",	-- INC_2  
	"00100010",	-- RET    
	"10010000",	-- MOV_18 
	"11111111",
	"11111010",
	"11101111",	-- MOV_1  
	"11110000",	-- MOVX_4 
	"00100010",	-- RET    
	"10010000",	-- MOV_18 
	"11111111",
	"11111001",
	"11100000",	-- MOVX_2 
	"01111100",	-- MOV_7  
	"00000000",
	"11111011",	-- MOV_5  
	"10101010",	-- MOV_6  
	"00000100",
	"01111011",	-- MOV_7  
	"00000000",
	"11111010",	-- MOV_5  
	"11111011",	-- MOV_5  
	"11101100",	-- MOV_1  
	"10101110",	-- MOV_6  
	"00000010",
	"10101111",	-- MOV_6  
	"00000011",
	"00100010",	-- RET    
	"10010000",	-- MOV_18 
	"11111111",
	"11111000",
	"01110100",	-- MOV_4  
	"00000001",
	"11110000",	-- MOVX_4 
	"10010000",	-- MOV_18 
	"11111111",
	"11110111",
	"11100000",	-- MOVX_2 
	"01100100",	-- XRL_4  
	"00000001",
	"01100000",	-- JZ     
	"11111000",
	"00100010",	-- RET    
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"10000000",
	"00010010",	-- LCALL  
	"00000000",
	"00000011",
	"00010010",	-- LCALL  
	"00000010",
	"10101101",
	"00010010",	-- LCALL  
	"00000010",
	"11111101",
	"00010010",	-- LCALL  
	"00000000",
	"00011001",
	"01110101",	-- MOV_12 
	"10000000",
	"00000001",
	"00010010",	-- LCALL  
	"00000000",
	"00011010",
	"01110101",	-- MOV_12 
	"10000000",
	"00000010",
	"00010010",	-- LCALL  
	"00000000",
	"10000101",
	"01110101",	-- MOV_12 
	"10000000",
	"00000011",
	"00010010",	-- LCALL  
	"00000010",
	"00000001",
	"01110101",	-- MOV_12 
	"10000000",
	"00000100",
	"10000000",	-- SJMP   
	"11111110",
	"00100010",	-- RET    
	"00100010",	-- RET    
	"10010000",	-- MOV_18 
	"11111111",
	"11111110",
	"11100000",	-- MOVX_2 
	"01110000",	-- JNZ    
	"11111010",
	"10010000",	-- MOV_18 
	"11111111",
	"11111111",
	"11101111",	-- MOV_1  
	"11110000",	-- MOVX_4 
	"00100010",	-- RET    
	"01111000",	-- MOV_7  
	"01111111",
	"11100100",	-- CLR_1  
	"11110110",	-- MOV_13 
	"11011000",	-- DJNZ_1 
	"11111101",
	"01110101",	-- MOV_12 
	"10000001",
	"00001111",
	"00000010",	-- LJMP   
	"00000010",
	"11010110",
	"00000000",	-- NOP    
	"00000000");	-- NOP    
begin

    process(rst, clk)
    begin
        if( rst = '1' ) then

            data <= CD_8;
        elsif( clk'event and clk = '1' ) then

            if( rd = '1' ) then

                data <= PROGRAM(conv_integer(addr));
            else

                data <= CD_8;
            end if;
        end if;
    end process;
end BHV;