--
-- Copyright (c) 1999-2000 University of California, Riverside.
-- Permission to copy is granted provided that this header remains
-- intact.  This software is provided with no warranties.
--
-- Version : 1.0
--

-------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;

-------------------------------------------------------------------------------

entity DIGCAM is
        port(rst      : in  STD_LOGIC;
             clk      : in  STD_LOGIC;
             txout    : out STD_LOGIC;
             ccd_rd   : out STD_LOGIC;
             ccd_data : in  UNSIGNED (7 downto 0));
end DIGCAM;

-------------------------------------------------------------------------------

architecture BHV of DIGCAM is

    component I8051_ALL
        port(rst          : in  STD_LOGIC;
             clk          : in  STD_LOGIC;
             xrm_addr     : out UNSIGNED (15 downto 0);
             xrm_out_data : out UNSIGNED (7 downto 0);
             xrm_in_data  : in  UNSIGNED (7 downto 0);
             xrm_rd       : out STD_LOGIC;
             xrm_wr       : out STD_LOGIC;
             p0_in        : in  UNSIGNED (7 downto 0);
             p0_out       : out UNSIGNED (7 downto 0);
             p1_in        : in  UNSIGNED (7 downto 0);
             p1_out       : out UNSIGNED (7 downto 0);
             p2_in        : in  UNSIGNED (7 downto 0);
             p2_out       : out UNSIGNED (7 downto 0);
             p3_in        : in  UNSIGNED (7 downto 0);
             p3_out       : out UNSIGNED (7 downto 0));
    end component;

    component SDRAM

        generic(STORAGE_SIZE : INTEGER := 1024);

        port(rst      : in  STD_LOGIC;
             clk      : in  STD_LOGIC;
             addr     : in  UNSIGNED (15 downto 0);
             in_data  : in  UNSIGNED (7 downto 0);
             out_data : out UNSIGNED (7 downto 0);
             rd       : in  STD_LOGIC;
             wr       : in  STD_LOGIC);
    end component;

    component UAT

        generic(STATUS_REG_ADDR : INTEGER := 65534;
                TX_REG_ADDR : INTEGER := 65535);

        port(rst      : in  STD_LOGIC;
             clk      : in  STD_LOGIC;
             addr     : in  UNSIGNED (15 downto 0);
             in_data  : in  UNSIGNED (7 downto 0);
             out_data : out UNSIGNED (7 downto 0);
             rd       : in  STD_LOGIC;
             wr       : in  STD_LOGIC;
             txout    : out STD_LOGIC);
    end component;

    component CCDPP

        generic(STAT_REG_ADDR : INTEGER := 65531;
                CMND_REG_ADDR : INTEGER := 65532;
                DATA_REG_ADDR : INTEGER := 65533;
                IMAGE_WIDTH   : INTEGER := 16;
                IMAGE_HEIGHT  : INTEGER := 16);
  
        port(rst      : in  STD_LOGIC;
             clk      : in  STD_LOGIC;
             addr     : in  UNSIGNED (15 downto 0);
             in_data  : in  UNSIGNED (7 downto 0);
             out_data : out UNSIGNED (7 downto 0);
             rd       : in  STD_LOGIC;
             wr       : in  STD_LOGIC;
             ccd_rd   : out STD_LOGIC;
             ccd_data : in  UNSIGNED (7 downto 0));
    end component;

    component DCTC is

        generic(STAT_REG_ADDR : INTEGER := 65527;
                CMND_REG_ADDR : INTEGER := 65528;
                DATAI_REG_ADDR : INTEGER := 65530;
                DATAO_REG_ADDR : INTEGER := 65529);
        
        port(rst      : in  STD_LOGIC;
             clk      : in  STD_LOGIC;
             addr     : in  UNSIGNED (15 downto 0);
             in_data  : in  UNSIGNED (7 downto 0);
             out_data : out UNSIGNED (7 downto 0);
             rd       : in  STD_LOGIC;
             wr       : in  STD_LOGIC);
    end component;
    
    signal addr     : UNSIGNED (15 downto 0);
    signal in_data  : UNSIGNED (7 downto 0);
    signal out_data : UNSIGNED (7 downto 0);
    signal rd       : STD_LOGIC;
    signal wr       : STD_LOGIC;
    signal p0_in    : UNSIGNED (7 downto 0);
    signal p0_out   : UNSIGNED (7 downto 0);
    signal p1_in    : UNSIGNED (7 downto 0);
    signal p1_out   : UNSIGNED (7 downto 0);
    signal p2_in    : UNSIGNED (7 downto 0);
    signal p2_out   : UNSIGNED (7 downto 0);
    signal p3_in    : UNSIGNED (7 downto 0);
    signal p3_out   : UNSIGNED (7 downto 0);
begin

    U_8051 : I8051_ALL port map (rst, clk,
                                addr, out_data, in_data, rd, wr,
                                p0_in, p0_out, p1_in, p1_out,
                                p2_in, p2_out, p3_in, p3_out);

    U_SDRAM : SDRAM port map (rst, clk, addr, out_data, in_data, rd, wr);

    U_UAT : UAT port map (rst, clk, addr, out_data, in_data, rd, wr, txout);

    U_CCDPP : CCDPP port map (rst, clk, addr, out_data, in_data, rd, wr,
                              ccd_rd, ccd_data);

    U_DCTC : DCTC port map (rst, clk, addr, out_data, in_data, rd, wr);
end BHV;
