/*
 * Copyright (c) 1999-2000 University of California, Riverside.
 * Permission to copy is granted provided that this header remains
 * intact.  This software is provided with no warranties.
 *
 * Version : 1.0
 */

/*--------------------------------------------------------------------------*/

static const short code COS_TABLE[8][8] = {
    
    {   64,   62,   59,   53,   45,   35,   24,   12 },
    {   64,   53,   24,  -12,  -45,  -62,  -59,  -35 },
    {   64,   35,  -24,  -62,  -45,   12,   59,   53 },
    {   64,   12,  -59,  -35,   45,   53,  -24,  -62 },
    {   64,  -12,  -59,   35,   45,  -53,  -24,   62 },
    {   64,  -35,  -24,   62,  -45,  -12,   59,  -53 },
    {   64,  -53,   24,   12,  -45,   62,  -59,   35 },
    {   64,  -62,   59,  -53,   45,  -35,   24,  -12 }
};

/*--------------------------------------------------------------------------*/

static const short ONE_OVER_SQRT_TWO = 5;

/*--------------------------------------------------------------------------*/

static short xdata inBuffer[8][8];
static short xdata outBuffer[8][8];
static int idx;

/*--------------------------------------------------------------------------*/

static unsigned char C(int h) {
    
    return h ? 64 : ONE_OVER_SQRT_TWO;
}

/*--------------------------------------------------------------------------*/

static int F(int u, int v, short img[8][8]) {
    
    long s[8], r = 0;
    unsigned char x;
    
    for(x=0; x<8; x++) {
        
        s[x] = 
            (img[x][0] * COS_TABLE[0][v]) >> 6 +
            (img[x][1] * COS_TABLE[1][v]) >> 6 +
            (img[x][2] * COS_TABLE[2][v]) >> 6 +
            (img[x][3] * COS_TABLE[3][v]) >> 6 +
            (img[x][4] * COS_TABLE[4][v]) >> 6 +
            (img[x][5] * COS_TABLE[5][v]) >> 6 +
            (img[x][6] * COS_TABLE[6][v]) >> 6 +
            (img[x][7] * COS_TABLE[7][v]) >> 6;
    }
    
    for(x=0; x<8; x++) {
        
        r += (s[x] * COS_TABLE[x][u]) >> 6;
    }
    
    return (short)((((((r * 16) >> 6) * C(u)) >> 6) * C(v)) >> 6);
}

/*--------------------------------------------------------------------------*/

void CodecInitialize(void) {
    
    idx = 0;
}

/*--------------------------------------------------------------------------*/

void CodecPushPixel(short p) {
    
    if( idx == 64 ) {
        
        idx = 0;
    }
    
    inBuffer[idx / 8][idx % 8] = p << 6;
    idx++;
}

/*--------------------------------------------------------------------------*/

short CodecPopPixel(void) {
    
    short p;
    
    if( idx == 64 ) {
        
        idx = 0;
    }
    
    p = outBuffer[idx / 8][idx % 8];
    idx++;
    return p;
}

/*--------------------------------------------------------------------------*/

void CodecDoFdct(void) {
    
    unsigned short x, y;
    
    for(x=0; x<8; x++) {
        
        for(y=0; y<8; y++) {
            
            outBuffer[x][y] = F(x, y, inBuffer);
        }
    }
    idx = 0;
}
