--
-- Copyright (c) 1999-2000 University of California, Riverside.
-- Permission to copy is granted provided that this header remains
-- intact.  This software is provided with no warranties.
--
-- Version : 1.0
--

-------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;

-------------------------------------------------------------------------------

entity TSB is
end TSB;

-------------------------------------------------------------------------------

architecture BHV of TSB is

    constant CLOCK_PERIOD : time := 50 ns;

    component DIGCAM
        port(rst      : in  STD_LOGIC;
             clk      : in  STD_LOGIC;
             txout    : out STD_LOGIC;
             ccd_rd   : out STD_LOGIC;
             ccd_data : in  UNSIGNED (7 downto 0));
    end component;

    component CCD

        port(rst  : in  STD_LOGIC;
             clk  : in  STD_LOGIC;
             rd   : in  STD_LOGIC;
             data : out UNSIGNED (7 downto 0));
    end component;

    signal rst      : STD_LOGIC := '1';
    signal clk      : STD_LOGIC := '0';
    signal txout    : STD_LOGIC;
    signal ccd_rd   : STD_LOGIC;
    signal ccd_data : UNSIGNED (7 downto 0);
begin

    rst <= '0' after CLOCK_PERIOD;
    clk <= not clk after CLOCK_PERIOD / 2;

    U_DIGCAM : DIGCAM port map (rst, clk, txout, ccd_rd, ccd_data);
    U_CCD : CCD port map (rst, clk, ccd_rd, ccd_data);
end BHV;

-------------------------------------------------------------------------------

configuration CFG_TSB of TSB is
    for BHV
    end for;
end CFG_TSB;
