-- digcam.hex 

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use WORK.I8051_LIB.all;

entity I8051_ROM is
    port(rst      : in  STD_LOGIC;
         clk      : in  STD_LOGIC;
         addr     : in  UNSIGNED (11 downto 0);
         data     : out UNSIGNED (7 downto 0);
         rd       : in  STD_LOGIC);
end I8051_ROM;

architecture BHV of I8051_ROM is

    type ROM_TYPE is array (0 to 2411) of UNSIGNED (7 downto 0);

    constant PROGRAM : ROM_TYPE := (

	"00000010",	-- LJMP   
	"00000111",
	"10011111",
	"00100010",	-- RET    
	"10010000",	-- MOV_18 
	"11111111",
	"11111100",
	"01110100",	-- MOV_4  
	"00000001",
	"11110000",	-- MOVX_4 
	"10010000",	-- MOV_18 
	"11111111",
	"11111011",
	"11100000",	-- MOVX_2 
	"01100100",	-- XRL_4  
	"00000001",
	"01100000",	-- JZ     
	"11111000",
	"00100010",	-- RET    
	"10010000",	-- MOV_18 
	"11111111",
	"11111101",
	"11100000",	-- MOVX_2 
	"11111111",	-- MOV_5  
	"00100010",	-- RET    
	"00100010",	-- RET    
	"00010010",	-- LCALL  
	"00000000",
	"00000100",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001100",
	"11110101",	-- MOV_8  
	"00001101",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001110",
	"11110101",	-- MOV_8  
	"00001111",
	"00010010",	-- LCALL  
	"00000000",
	"00010011",
	"11101111",	-- MOV_1  
	"11111101",	-- MOV_5  
	"00110011",	-- RLC    
	"10010101",	-- SUBB_2 
	"11100000",
	"11111100",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001111",
	"00100101",	-- ADD_2  
	"11100000",
	"11111011",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001110",
	"00110011",	-- RLC    
	"11111010",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001101",
	"10101110",	-- MOV_6  
	"00001100",
	"01111000",	-- MOV_7  
	"00000101",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100100",	-- ADD_4  
	"00000000",
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000000",
	"11110101",	-- MOV_8  
	"10000011",
	"11100101",	-- MOV_2  
	"10000010",
	"00101011",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101010",	-- MOV_1  
	"00110101",	-- ADDC_2 
	"10000011",
	"11110101",	-- MOV_8  
	"10000011",
	"11101100",	-- MOV_1  
	"11110000",	-- MOVX_4 
	"10100011",	-- INC_5  
	"11101101",	-- MOV_1  
	"11110000",	-- MOVX_4 
	"00000101",	-- INC_3  
	"00001111",
	"11100101",	-- MOV_2  
	"00001111",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001110",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00001111",
	"10010100",	-- SUBB_4 
	"00010000",
	"11100101",	-- MOV_2  
	"00001110",
	"10010100",	-- SUBB_4 
	"00000000",
	"01000000",	-- JC     
	"10110110",
	"00000101",	-- INC_3  
	"00001101",
	"11100101",	-- MOV_2  
	"00001101",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001100",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00001101",
	"10010100",	-- SUBB_4 
	"00010000",
	"11100101",	-- MOV_2  
	"00001100",
	"10010100",	-- SUBB_4 
	"00000000",
	"01000000",	-- JC     
	"10011110",
	"00100010",	-- RET    
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001100",
	"11110101",	-- MOV_8  
	"00001101",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001110",
	"11110101",	-- MOV_8  
	"00001111",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00010000",
	"11110101",	-- MOV_8  
	"00010001",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00010010",
	"11110101",	-- MOV_8  
	"00010011",
	"11100101",	-- MOV_2  
	"00001111",
	"10101110",	-- MOV_6  
	"00001110",
	"01111000",	-- MOV_7  
	"00000011",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100101",	-- ADD_2  
	"00010011",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00010010",
	"00111110",	-- ADDC_1 
	"11111110",	-- MOV_5  
	"11101111",	-- MOV_1  
	"00100101",	-- ADD_2  
	"11100000",
	"11111101",	-- MOV_5  
	"11101110",	-- MOV_1  
	"00110011",	-- RLC    
	"11111100",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001101",
	"10101110",	-- MOV_6  
	"00001100",
	"01111000",	-- MOV_7  
	"00000011",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100101",	-- ADD_2  
	"00010001",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00010000",
	"00111110",	-- ADDC_1 
	"11111110",	-- MOV_5  
	"11101111",	-- MOV_1  
	"01111000",	-- MOV_7  
	"00000101",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100100",	-- ADD_4  
	"00000000",
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000000",
	"11110101",	-- MOV_8  
	"10000011",
	"11100101",	-- MOV_2  
	"10000010",
	"00101101",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101100",	-- MOV_1  
	"00110101",	-- ADDC_2 
	"10000011",
	"11110101",	-- MOV_8  
	"10000011",
	"11100000",	-- MOVX_2 
	"10100011",	-- INC_5  
	"11100000",	-- MOVX_2 
	"11111111",	-- MOV_5  
	"00110011",	-- RLC    
	"10010101",	-- SUBB_2 
	"11100000",
	"11111110",	-- MOV_5  
	"00010010",	-- LCALL  
	"00000101",
	"10100100",
	"00000101",	-- INC_3  
	"00010011",
	"11100101",	-- MOV_2  
	"00010011",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00010010",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00010011",
	"10010100",	-- SUBB_4 
	"00001000",
	"11100101",	-- MOV_2  
	"00010010",
	"10010100",	-- SUBB_4 
	"00000000",
	"01000000",	-- JC     
	"10010110",
	"00000101",	-- INC_3  
	"00010001",
	"11100101",	-- MOV_2  
	"00010001",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00010000",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00010001",
	"10010100",	-- SUBB_4 
	"00001000",
	"11100101",	-- MOV_2  
	"00010000",
	"10010100",	-- SUBB_4 
	"00000000",
	"01010000",	-- JNC    
	"00000011",
	"00000010",	-- LJMP   
	"00000000",
	"10010100",
	"00010010",	-- LCALL  
	"00000110",
	"01101001",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00010000",
	"11110101",	-- MOV_8  
	"00010001",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00010010",
	"11110101",	-- MOV_8  
	"00010011",
	"00010010",	-- LCALL  
	"00000110",
	"00010000",
	"11100101",	-- MOV_2  
	"00010001",
	"01110101",	-- MOV_12 
	"11110000",
	"00001000",
	"10100100",	-- MUL    
	"00100100",	-- ADD_4  
	"01101101",
	"11110101",	-- MOV_8  
	"10000010",
	"11100100",	-- CLR_1  
	"00110100",	-- ADDC_4 
	"00000010",
	"11110101",	-- MOV_8  
	"10000011",
	"11100101",	-- MOV_2  
	"10000010",
	"00100101",	-- ADD_2  
	"00010011",
	"11110101",	-- MOV_8  
	"10000010",
	"11100100",	-- CLR_1  
	"00110101",	-- ADDC_2 
	"10000011",
	"11110101",	-- MOV_8  
	"10000011",
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"11111101",	-- MOV_5  
	"11101111",	-- MOV_1  
	"10101000",	-- MOV_6  
	"00000101",
	"00001000",	-- INC_2  
	"10000000",	-- SJMP   
	"00000110",
	"11001110",	-- XCH_1  
	"10100010",	-- MOV_16 
	"11100111",
	"00010011",	-- RRC    
	"11001110",	-- XCH_1  
	"00010011",	-- RRC    
	"11011000",	-- DJNZ_1 
	"11111000",
	"11111101",	-- MOV_5  
	"10101100",	-- MOV_6  
	"00000110",
	"11100101",	-- MOV_2  
	"00001111",
	"10101110",	-- MOV_6  
	"00001110",
	"01111000",	-- MOV_7  
	"00000011",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100101",	-- ADD_2  
	"00010011",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00010010",
	"00111110",	-- ADDC_1 
	"11111110",	-- MOV_5  
	"11101111",	-- MOV_1  
	"00100101",	-- ADD_2  
	"11100000",
	"11111011",	-- MOV_5  
	"11101110",	-- MOV_1  
	"00110011",	-- RLC    
	"11111010",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001101",
	"10101110",	-- MOV_6  
	"00001100",
	"01111000",	-- MOV_7  
	"00000011",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100101",	-- ADD_2  
	"00010001",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00010000",
	"00111110",	-- ADDC_1 
	"11111110",	-- MOV_5  
	"11101111",	-- MOV_1  
	"01111000",	-- MOV_7  
	"00000101",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100100",	-- ADD_4  
	"00000000",
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000000",
	"11110101",	-- MOV_8  
	"10000011",
	"11100101",	-- MOV_2  
	"10000010",
	"00101011",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101010",	-- MOV_1  
	"00110101",	-- ADDC_2 
	"10000011",
	"11110101",	-- MOV_8  
	"10000011",
	"11101100",	-- MOV_1  
	"11110000",	-- MOVX_4 
	"10100011",	-- INC_5  
	"11101101",	-- MOV_1  
	"11110000",	-- MOVX_4 
	"00000101",	-- INC_3  
	"00010011",
	"11100101",	-- MOV_2  
	"00010011",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00010010",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00010011",
	"10010100",	-- SUBB_4 
	"00001000",
	"11100101",	-- MOV_2  
	"00010010",
	"10010100",	-- SUBB_4 
	"00000000",
	"01010000",	-- JNC    
	"00000011",
	"00000010",	-- LJMP   
	"00000001",
	"00100110",
	"00000101",	-- INC_3  
	"00010001",
	"11100101",	-- MOV_2  
	"00010001",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00010000",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00010001",
	"10010100",	-- SUBB_4 
	"00001000",
	"11100101",	-- MOV_2  
	"00010000",
	"10010100",	-- SUBB_4 
	"00000000",
	"01010000",	-- JNC    
	"00000011",
	"00000010",	-- LJMP   
	"00000001",
	"00100001",
	"00000101",	-- INC_3  
	"00001111",
	"11100101",	-- MOV_2  
	"00001111",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001110",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00001111",
	"10010100",	-- SUBB_4 
	"00000010",
	"11100101",	-- MOV_2  
	"00001110",
	"10010100",	-- SUBB_4 
	"00000000",
	"01010000",	-- JNC    
	"00000011",
	"00000010",	-- LJMP   
	"00000000",
	"10001111",
	"00000101",	-- INC_3  
	"00001101",
	"11100101",	-- MOV_2  
	"00001101",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001100",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00001101",
	"10010100",	-- SUBB_4 
	"00000010",
	"11100101",	-- MOV_2  
	"00001100",
	"10010100",	-- SUBB_4 
	"00000000",
	"01010000",	-- JNC    
	"00000011",
	"00000010",	-- LJMP   
	"00000000",
	"10001010",
	"00100010",	-- RET    
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001110",
	"11110101",	-- MOV_8  
	"00001111",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00010000",
	"11110101",	-- MOV_8  
	"00010001",
	"11100101",	-- MOV_2  
	"00010001",
	"00100101",	-- ADD_2  
	"11100000",
	"11111101",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00010000",
	"00110011",	-- RLC    
	"11111100",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00001111",
	"10101110",	-- MOV_6  
	"00001110",
	"01111000",	-- MOV_7  
	"00000101",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"00100100",	-- ADD_4  
	"00000000",
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000000",
	"11110101",	-- MOV_8  
	"10000011",
	"11100101",	-- MOV_2  
	"10000010",
	"00101101",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101100",	-- MOV_1  
	"00110101",	-- ADDC_2 
	"10000011",
	"11110101",	-- MOV_8  
	"10000011",
	"11100000",	-- MOVX_2 
	"11111110",	-- MOV_5  
	"10100011",	-- INC_5  
	"11100000",	-- MOVX_2 
	"10001110",	-- MOV_9  
	"00001100",
	"11110101",	-- MOV_8  
	"00001101",
	"10101111",	-- MOV_6  
	"00001100",
	"00010010",	-- LCALL  
	"00000111",
	"10010011",
	"10101111",	-- MOV_6  
	"00001101",
	"00010010",	-- LCALL  
	"00000111",
	"10010011",
	"00000101",	-- INC_3  
	"00010001",
	"11100101",	-- MOV_2  
	"00010001",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00010000",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00010001",
	"10010100",	-- SUBB_4 
	"00010000",
	"11100101",	-- MOV_2  
	"00010000",
	"10010100",	-- SUBB_4 
	"00000000",
	"01000000",	-- JC     
	"10110010",
	"00000101",	-- INC_3  
	"00001111",
	"11100101",	-- MOV_2  
	"00001111",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001110",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00001111",
	"10010100",	-- SUBB_4 
	"00010000",
	"11100101",	-- MOV_2  
	"00001110",
	"10010100",	-- SUBB_4 
	"00000000",
	"01000000",	-- JC     
	"10011010",
	"00100010",	-- RET    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000000",	-- NOP    
	"00000001",	-- AJMP   
	"00000001",
	"00000001",	-- AJMP   
	"00000001",
	"00000001",	-- AJMP   
	"00000001",
	"00000001",	-- AJMP   
	"00000001",
	"00000001",	-- AJMP   
	"00000001",
	"00000010",	-- LJMP   
	"00000010",
	"00000010",
	"00000010",	-- LJMP   
	"00000010",
	"00000010",
	"00000010",	-- LJMP   
	"00000010",
	"00000010",
	"00000011",	-- RR     
	"00000011",	-- RR     
	"00000011",	-- RR     
	"00000011",	-- RR     
	"00000011",	-- RR     
	"00000011",	-- RR     
	"00000011",	-- RR     
	"00000011",	-- RR     
	"00000100",	-- INC_1  
	"00000100",	-- INC_1  
	"00000100",	-- INC_1  
	"00000100",	-- INC_1  
	"00000100",	-- INC_1  
	"00000100",	-- INC_1  
	"00000100",	-- INC_1  
	"00000101",	-- INC_3  
	"00000101",
	"00000101",	-- INC_3  
	"00000101",
	"00000101",	-- INC_3  
	"00000101",
	"00000110",	-- INC_4  
	"00000110",	-- INC_4  
	"00000110",	-- INC_4  
	"00000110",	-- INC_4  
	"00000110",	-- INC_4  
	"00000111",	-- INC_4  
	"00000111",	-- INC_4  
	"00000111",	-- INC_4  
	"00000111",	-- INC_4  
	"00001000",	-- INC_2  
	"00001000",	-- INC_2  
	"00001000",	-- INC_2  
	"11101111",	-- MOV_1  
	"01001110",	-- ORL_1  
	"01100000",	-- JZ     
	"00000100",
	"01111111",	-- MOV_7  
	"01000000",
	"10000000",	-- SJMP   
	"00000010",
	"10101111",	-- MOV_6  
	"00001001",
	"00100010",	-- RET    
	"10001110",	-- MOV_9  
	"00011000",
	"10001111",	-- MOV_9  
	"00011001",
	"10001100",	-- MOV_9  
	"00011010",
	"10001101",	-- MOV_9  
	"00011011",
	"10001011",	-- MOV_9  
	"00011100",
	"10001010",	-- MOV_9  
	"00011101",
	"10001001",	-- MOV_9  
	"00011110",
	"01110101",	-- MOV_12 
	"01000010",
	"00000000",
	"01110101",	-- MOV_12 
	"01000001",
	"00000000",
	"01110101",	-- MOV_12 
	"01000000",
	"00000000",
	"01110101",	-- MOV_12 
	"00111111",
	"00000000",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"01000111",
	"11100101",	-- MOV_2  
	"01000111",
	"01110101",	-- MOV_12 
	"11110000",
	"00010000",
	"10100100",	-- MUL    
	"10101011",	-- MOV_6  
	"00011100",
	"00100101",	-- ADD_2  
	"00011110",
	"11111001",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011101",
	"00110101",	-- ADDC_2 
	"11110000",
	"11111010",	-- MOV_5  
	"10010000",	-- MOV_18 
	"00000000",
	"00000010",
	"00010010",	-- LCALL  
	"00001000",
	"01110101",
	"11111011",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011011",
	"00100101",	-- ADD_2  
	"11100000",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011010",
	"00110011",	-- RLC    
	"11111110",	-- MOV_5  
	"01110100",	-- MOV_4  
	"11111011",
	"00101111",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000110",
	"11110101",	-- MOV_8  
	"10000011",
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"11111100",	-- MOV_5  
	"01110100",	-- MOV_4  
	"00000001",
	"10010011",	-- MOVC_1 
	"11111101",	-- MOV_5  
	"10101111",	-- MOV_6  
	"00000011",
	"10101110",	-- MOV_6  
	"11110000",
	"00010010",	-- LCALL  
	"00001000",
	"00101011",
	"11000000",	-- PUSH   
	"00000110",
	"11000000",	-- PUSH   
	"00000111",
	"10101011",	-- MOV_6  
	"00011100",
	"10101010",	-- MOV_6  
	"00011101",
	"10101001",	-- MOV_6  
	"00011110",
	"01110101",	-- MOV_12 
	"11110000",
	"00010000",
	"11100101",	-- MOV_2  
	"01000111",
	"10100100",	-- MUL    
	"11110101",	-- MOV_8  
	"10000010",
	"10000101",	-- MOV_10 
	"11110000",
	"10000011",
	"00010010",	-- LCALL  
	"00001000",
	"01110101",
	"11111011",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011011",
	"00100101",	-- ADD_2  
	"11100000",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011010",
	"00110011",	-- RLC    
	"11111110",	-- MOV_5  
	"01110100",	-- MOV_4  
	"11101011",
	"00101111",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000110",
	"11110101",	-- MOV_8  
	"10000011",
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"11111100",	-- MOV_5  
	"01110100",	-- MOV_4  
	"00000001",
	"10010011",	-- MOVC_1 
	"11111101",	-- MOV_5  
	"10101111",	-- MOV_6  
	"00000011",
	"10101110",	-- MOV_6  
	"11110000",
	"00010010",	-- LCALL  
	"00001000",
	"00101011",
	"11010000",	-- POP    
	"11100000",
	"00101111",	-- ADD_1  
	"11111101",	-- MOV_5  
	"11010000",	-- POP    
	"11100000",
	"00111110",	-- ADDC_1 
	"11111100",	-- MOV_5  
	"11000000",	-- PUSH   
	"00000100",
	"11000000",	-- PUSH   
	"00000101",
	"11100101",	-- MOV_2  
	"01000111",
	"01110101",	-- MOV_12 
	"11110000",
	"00010000",
	"10100100",	-- MUL    
	"10101011",	-- MOV_6  
	"00011100",
	"00101001",	-- ADD_1  
	"11111001",	-- MOV_5  
	"11101010",	-- MOV_1  
	"00110101",	-- ADDC_2 
	"11110000",
	"11111010",	-- MOV_5  
	"10010000",	-- MOV_18 
	"00000000",
	"00000100",
	"00010010",	-- LCALL  
	"00001000",
	"01110101",
	"11111011",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011011",
	"00100101",	-- ADD_2  
	"11100000",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011010",
	"00110011",	-- RLC    
	"11111110",	-- MOV_5  
	"01110100",	-- MOV_4  
	"00001011",
	"00101111",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000111",
	"11110101",	-- MOV_8  
	"10000011",
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"11111100",	-- MOV_5  
	"01110100",	-- MOV_4  
	"00000001",
	"10010011",	-- MOVC_1 
	"11111101",	-- MOV_5  
	"10101111",	-- MOV_6  
	"00000011",
	"10101110",	-- MOV_6  
	"11110000",
	"00010010",	-- LCALL  
	"00001000",
	"00101011",
	"11010000",	-- POP    
	"11100000",
	"00101111",	-- ADD_1  
	"11111101",	-- MOV_5  
	"11010000",	-- POP    
	"11100000",
	"00111110",	-- ADDC_1 
	"11111100",	-- MOV_5  
	"11000000",	-- PUSH   
	"00000100",
	"11000000",	-- PUSH   
	"00000101",
	"11100101",	-- MOV_2  
	"01000111",
	"01110101",	-- MOV_12 
	"11110000",
	"00010000",
	"10100100",	-- MUL    
	"10101011",	-- MOV_6  
	"00011100",
	"00100101",	-- ADD_2  
	"00011110",
	"11111001",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011101",
	"00110101",	-- ADDC_2 
	"11110000",
	"11111010",	-- MOV_5  
	"10010000",	-- MOV_18 
	"00000000",
	"00000110",
	"00010010",	-- LCALL  
	"00001000",
	"01110101",
	"11111011",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011011",
	"00100101",	-- ADD_2  
	"11100000",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011010",
	"00110011",	-- RLC    
	"11111110",	-- MOV_5  
	"01110100",	-- MOV_4  
	"00011011",
	"00101111",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000111",
	"11110101",	-- MOV_8  
	"10000011",
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"11111100",	-- MOV_5  
	"01110100",	-- MOV_4  
	"00000001",
	"10010011",	-- MOVC_1 
	"11111101",	-- MOV_5  
	"10101111",	-- MOV_6  
	"00000011",
	"10101110",	-- MOV_6  
	"11110000",
	"00010010",	-- LCALL  
	"00001000",
	"00101011",
	"11010000",	-- POP    
	"11100000",
	"00101111",	-- ADD_1  
	"11111101",	-- MOV_5  
	"11010000",	-- POP    
	"11100000",
	"00111110",	-- ADDC_1 
	"11111100",	-- MOV_5  
	"11000000",	-- PUSH   
	"00000100",
	"11000000",	-- PUSH   
	"00000101",
	"11100101",	-- MOV_2  
	"01000111",
	"01110101",	-- MOV_12 
	"11110000",
	"00010000",
	"10100100",	-- MUL    
	"10101011",	-- MOV_6  
	"00011100",
	"00100101",	-- ADD_2  
	"00011110",
	"11111001",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011101",
	"00110101",	-- ADDC_2 
	"11110000",
	"11111010",	-- MOV_5  
	"10010000",	-- MOV_18 
	"00000000",
	"00001000",
	"00010010",	-- LCALL  
	"00001000",
	"01110101",
	"11111011",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011011",
	"00100101",	-- ADD_2  
	"11100000",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011010",
	"00110011",	-- RLC    
	"11111110",	-- MOV_5  
	"01110100",	-- MOV_4  
	"00101011",
	"00101111",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000111",
	"11110101",	-- MOV_8  
	"10000011",
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"11111100",	-- MOV_5  
	"01110100",	-- MOV_4  
	"00000001",
	"10010011",	-- MOVC_1 
	"11111101",	-- MOV_5  
	"10101111",	-- MOV_6  
	"00000011",
	"10101110",	-- MOV_6  
	"11110000",
	"00010010",	-- LCALL  
	"00001000",
	"00101011",
	"11010000",	-- POP    
	"11100000",
	"00101111",	-- ADD_1  
	"11111101",	-- MOV_5  
	"11010000",	-- POP    
	"11100000",
	"00111110",	-- ADDC_1 
	"11111100",	-- MOV_5  
	"11000000",	-- PUSH   
	"00000100",
	"11000000",	-- PUSH   
	"00000101",
	"11100101",	-- MOV_2  
	"01000111",
	"01110101",	-- MOV_12 
	"11110000",
	"00010000",
	"10100100",	-- MUL    
	"10101011",	-- MOV_6  
	"00011100",
	"00100101",	-- ADD_2  
	"00011110",
	"11111001",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011101",
	"00110101",	-- ADDC_2 
	"11110000",
	"11111010",	-- MOV_5  
	"10010000",	-- MOV_18 
	"00000000",
	"00001010",
	"00010010",	-- LCALL  
	"00001000",
	"01110101",
	"11111011",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011011",
	"00100101",	-- ADD_2  
	"11100000",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011010",
	"00110011",	-- RLC    
	"11111110",	-- MOV_5  
	"01110100",	-- MOV_4  
	"00111011",
	"00101111",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000111",
	"11110101",	-- MOV_8  
	"10000011",
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"11111100",	-- MOV_5  
	"01110100",	-- MOV_4  
	"00000001",
	"10010011",	-- MOVC_1 
	"11111101",	-- MOV_5  
	"10101111",	-- MOV_6  
	"00000011",
	"10101110",	-- MOV_6  
	"11110000",
	"00010010",	-- LCALL  
	"00001000",
	"00101011",
	"11010000",	-- POP    
	"11100000",
	"00101111",	-- ADD_1  
	"11111101",	-- MOV_5  
	"11010000",	-- POP    
	"11100000",
	"00111110",	-- ADDC_1 
	"11111100",	-- MOV_5  
	"11000000",	-- PUSH   
	"00000100",
	"11000000",	-- PUSH   
	"00000101",
	"11100101",	-- MOV_2  
	"01000111",
	"01110101",	-- MOV_12 
	"11110000",
	"00010000",
	"10100100",	-- MUL    
	"10101011",	-- MOV_6  
	"00011100",
	"00100101",	-- ADD_2  
	"00011110",
	"11111001",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011101",
	"00110101",	-- ADDC_2 
	"11110000",
	"11111010",	-- MOV_5  
	"10010000",	-- MOV_18 
	"00000000",
	"00001100",
	"00010010",	-- LCALL  
	"00001000",
	"01110101",
	"11111011",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011011",
	"00100101",	-- ADD_2  
	"11100000",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011010",
	"00110011",	-- RLC    
	"11111110",	-- MOV_5  
	"01110100",	-- MOV_4  
	"01001011",
	"00101111",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000111",
	"11110101",	-- MOV_8  
	"10000011",
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"11111100",	-- MOV_5  
	"01110100",	-- MOV_4  
	"00000001",
	"10010011",	-- MOVC_1 
	"11111101",	-- MOV_5  
	"10101111",	-- MOV_6  
	"00000011",
	"10101110",	-- MOV_6  
	"11110000",
	"00010010",	-- LCALL  
	"00001000",
	"00101011",
	"11010000",	-- POP    
	"11100000",
	"00101111",	-- ADD_1  
	"11111101",	-- MOV_5  
	"11010000",	-- POP    
	"11100000",
	"00111110",	-- ADDC_1 
	"11111100",	-- MOV_5  
	"11000000",	-- PUSH   
	"00000100",
	"11000000",	-- PUSH   
	"00000101",
	"11100101",	-- MOV_2  
	"01000111",
	"01110101",	-- MOV_12 
	"11110000",
	"00010000",
	"10100100",	-- MUL    
	"10101011",	-- MOV_6  
	"00011100",
	"00100101",	-- ADD_2  
	"00011110",
	"11111001",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011101",
	"00110101",	-- ADDC_2 
	"11110000",
	"11111010",	-- MOV_5  
	"10010000",	-- MOV_18 
	"00000000",
	"00001110",
	"00010010",	-- LCALL  
	"00001000",
	"01110101",
	"11111011",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011011",
	"00100101",	-- ADD_2  
	"11100000",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011010",
	"00110011",	-- RLC    
	"11111110",	-- MOV_5  
	"01110100",	-- MOV_4  
	"01011011",
	"00101111",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000111",
	"11110101",	-- MOV_8  
	"10000011",
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"11111100",	-- MOV_5  
	"01110100",	-- MOV_4  
	"00000001",
	"10010011",	-- MOVC_1 
	"11111101",	-- MOV_5  
	"10101111",	-- MOV_6  
	"00000011",
	"10101110",	-- MOV_6  
	"11110000",
	"00010010",	-- LCALL  
	"00001000",
	"00101011",
	"11010000",	-- POP    
	"11100000",
	"00101111",	-- ADD_1  
	"11111111",	-- MOV_5  
	"11010000",	-- POP    
	"11100000",
	"00111110",	-- ADDC_1 
	"11111110",	-- MOV_5  
	"00110011",	-- RLC    
	"10010101",	-- SUBB_2 
	"11100000",
	"11111101",	-- MOV_5  
	"11111100",	-- MOV_5  
	"11100101",	-- MOV_2  
	"01000111",
	"00100101",	-- ADD_2  
	"11100000",
	"00100101",	-- ADD_2  
	"11100000",
	"00100100",	-- ADD_4  
	"00011111",
	"11111000",	-- MOV_5  
	"00010010",	-- LCALL  
	"00001001",
	"00001001",
	"00000101",	-- INC_3  
	"01000111",
	"11100101",	-- MOV_2  
	"01000111",
	"01100100",	-- XRL_4  
	"00001000",
	"01100000",	-- JZ     
	"00000011",
	"00000010",	-- LJMP   
	"00000010",
	"11010101",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"01000111",
	"11100101",	-- MOV_2  
	"00011001",
	"00100101",	-- ADD_2  
	"11100000",
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00011000",
	"00110011",	-- RLC    
	"11111110",	-- MOV_5  
	"11100101",	-- MOV_2  
	"01000111",
	"11000100",	-- SWAP   
	"01010100",	-- ANL_4  
	"11110000",
	"00100100",	-- ADD_4  
	"11101011",
	"11110101",	-- MOV_8  
	"10000010",
	"11100100",	-- CLR_1  
	"00110100",	-- ADDC_4 
	"00000110",
	"11110101",	-- MOV_8  
	"10000011",
	"11100101",	-- MOV_2  
	"10000010",
	"00101111",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110101",	-- ADDC_2 
	"10000011",
	"11110101",	-- MOV_8  
	"10000011",
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"11111110",	-- MOV_5  
	"01110100",	-- MOV_4  
	"00000001",
	"10010011",	-- MOVC_1 
	"11111111",	-- MOV_5  
	"11101110",	-- MOV_1  
	"00110011",	-- RLC    
	"10010101",	-- SUBB_2 
	"11100000",
	"11111101",	-- MOV_5  
	"11111100",	-- MOV_5  
	"11100101",	-- MOV_2  
	"01000111",
	"00100101",	-- ADD_2  
	"11100000",
	"00100101",	-- ADD_2  
	"11100000",
	"00100100",	-- ADD_4  
	"00011111",
	"11111000",	-- MOV_5  
	"00010010",	-- LCALL  
	"00001000",
	"11111100",
	"00010010",	-- LCALL  
	"00001000",
	"10101101",
	"11100101",	-- MOV_2  
	"01000010",
	"00101111",	-- ADD_1  
	"11110101",	-- MOV_8  
	"01000010",
	"11100101",	-- MOV_2  
	"01000001",
	"00111110",	-- ADDC_1 
	"11110101",	-- MOV_8  
	"01000001",
	"11100101",	-- MOV_2  
	"01000000",
	"00111101",	-- ADDC_1 
	"11110101",	-- MOV_8  
	"01000000",
	"11100101",	-- MOV_2  
	"00111111",
	"00111100",	-- ADDC_1 
	"11110101",	-- MOV_8  
	"00111111",
	"00000101",	-- INC_3  
	"01000111",
	"11100101",	-- MOV_2  
	"01000111",
	"10110100",	-- CJNE_2 
	"00001000",
	"10101000",
	"10101111",	-- MOV_6  
	"00011001",
	"10101110",	-- MOV_6  
	"00011000",
	"00010010",	-- LCALL  
	"00000010",
	"10101101",
	"11100100",	-- CLR_1  
	"11111100",	-- MOV_5  
	"11111101",	-- MOV_5  
	"11111110",	-- MOV_5  
	"11000000",	-- PUSH   
	"00000100",
	"11000000",	-- PUSH   
	"00000101",
	"11000000",	-- PUSH   
	"00000110",
	"11000000",	-- PUSH   
	"00000111",
	"01111111",	-- MOV_7  
	"00010000",
	"10101011",	-- MOV_6  
	"01000010",
	"10101010",	-- MOV_6  
	"01000001",
	"10101001",	-- MOV_6  
	"01000000",
	"10101000",	-- MOV_6  
	"00111111",
	"00010010",	-- LCALL  
	"00001000",
	"10101101",
	"11010000",	-- POP    
	"00000011",
	"11010000",	-- POP    
	"00000010",
	"11010000",	-- POP    
	"00000001",
	"11010000",	-- POP    
	"00000000",
	"00010010",	-- LCALL  
	"00001000",
	"10101101",
	"10101000",	-- MOV_6  
	"00000100",
	"10101001",	-- MOV_6  
	"00000101",
	"10101010",	-- MOV_6  
	"00000110",
	"10101011",	-- MOV_6  
	"00000111",
	"10101111",	-- MOV_6  
	"00011011",
	"10101110",	-- MOV_6  
	"00011010",
	"00010010",	-- LCALL  
	"00000010",
	"10101101",
	"11100100",	-- CLR_1  
	"11111100",	-- MOV_5  
	"11111101",	-- MOV_5  
	"11111110",	-- MOV_5  
	"00010010",	-- LCALL  
	"00001000",
	"10101101",
	"00100010",	-- RET    
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001010",
	"11110101",	-- MOV_8  
	"00001011",
	"00100010",	-- RET    
	"11100101",	-- MOV_2  
	"00001011",
	"01100100",	-- XRL_4  
	"01000000",
	"01000101",	-- ORL_2  
	"00001010",
	"01110000",	-- JNZ    
	"00000100",
	"11110101",	-- MOV_8  
	"00001010",
	"11110101",	-- MOV_8  
	"00001011",
	"11101111",	-- MOV_1  
	"01111000",	-- MOV_7  
	"00000110",
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"00110011",	-- RLC    
	"11001110",	-- XCH_1  
	"11011000",	-- DJNZ_1 
	"11111001",
	"11111011",	-- MOV_5  
	"10101010",	-- MOV_6  
	"00000110",
	"11000000",	-- PUSH   
	"00000011",
	"11000000",	-- PUSH   
	"00000010",
	"10101110",	-- MOV_6  
	"00001010",
	"10101111",	-- MOV_6  
	"00001011",
	"01111100",	-- MOV_7  
	"00000000",
	"01111101",	-- MOV_7  
	"00001000",
	"00010010",	-- LCALL  
	"00001000",
	"00111111",
	"11101101",	-- MOV_1  
	"00100101",	-- ADD_2  
	"11100000",
	"11111011",	-- MOV_5  
	"11101100",	-- MOV_1  
	"00110011",	-- RLC    
	"11111010",	-- MOV_5  
	"10101110",	-- MOV_6  
	"00001010",
	"10101111",	-- MOV_6  
	"00001011",
	"01111100",	-- MOV_7  
	"00000000",
	"01111101",	-- MOV_7  
	"00001000",
	"00010010",	-- LCALL  
	"00001000",
	"00111111",
	"11101111",	-- MOV_1  
	"11000100",	-- SWAP   
	"11111000",	-- MOV_5  
	"01010100",	-- ANL_4  
	"00001111",
	"11001000",	-- XCH_1  
	"01101000",	-- XRL_1  
	"11111111",	-- MOV_5  
	"11101110",	-- MOV_1  
	"11000100",	-- SWAP   
	"01010100",	-- ANL_4  
	"11110000",
	"01001000",	-- ORL_1  
	"11111110",	-- MOV_5  
	"01110100",	-- MOV_4  
	"00000000",
	"00101111",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000010",
	"11110101",	-- MOV_8  
	"10000011",
	"11100101",	-- MOV_2  
	"10000010",
	"00101011",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101010",	-- MOV_1  
	"00110101",	-- ADDC_2 
	"10000011",
	"11110101",	-- MOV_8  
	"10000011",
	"11010000",	-- POP    
	"11100000",
	"11110000",	-- MOVX_4 
	"10100011",	-- INC_5  
	"11010000",	-- POP    
	"11100000",
	"11110000",	-- MOVX_4 
	"00000101",	-- INC_3  
	"00001011",
	"11100101",	-- MOV_2  
	"00001011",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001010",
	"00100010",	-- RET    
	"11100101",	-- MOV_2  
	"00001011",
	"01100100",	-- XRL_4  
	"01000000",
	"01000101",	-- ORL_2  
	"00001010",
	"01110000",	-- JNZ    
	"00000100",
	"11110101",	-- MOV_8  
	"00001010",
	"11110101",	-- MOV_8  
	"00001011",
	"10101110",	-- MOV_6  
	"00001010",
	"10101111",	-- MOV_6  
	"00001011",
	"01111100",	-- MOV_7  
	"00000000",
	"01111101",	-- MOV_7  
	"00001000",
	"00010010",	-- LCALL  
	"00001000",
	"00111111",
	"11101101",	-- MOV_1  
	"00100101",	-- ADD_2  
	"11100000",
	"11111011",	-- MOV_5  
	"11101100",	-- MOV_1  
	"00110011",	-- RLC    
	"11111010",	-- MOV_5  
	"10101110",	-- MOV_6  
	"00001010",
	"10101111",	-- MOV_6  
	"00001011",
	"01111100",	-- MOV_7  
	"00000000",
	"01111101",	-- MOV_7  
	"00001000",
	"00010010",	-- LCALL  
	"00001000",
	"00111111",
	"11101111",	-- MOV_1  
	"11000100",	-- SWAP   
	"11111000",	-- MOV_5  
	"01010100",	-- ANL_4  
	"00001111",
	"11001000",	-- XCH_1  
	"01101000",	-- XRL_1  
	"11111111",	-- MOV_5  
	"11101110",	-- MOV_1  
	"11000100",	-- SWAP   
	"01010100",	-- ANL_4  
	"11110000",
	"01001000",	-- ORL_1  
	"11111110",	-- MOV_5  
	"01110100",	-- MOV_4  
	"10000000",
	"00101111",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000010",
	"11110101",	-- MOV_8  
	"10000011",
	"11100101",	-- MOV_2  
	"10000010",
	"00101011",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101010",	-- MOV_1  
	"00110101",	-- ADDC_2 
	"10000011",
	"11110101",	-- MOV_8  
	"10000011",
	"11100000",	-- MOVX_2 
	"11111110",	-- MOV_5  
	"10100011",	-- INC_5  
	"11100000",	-- MOVX_2 
	"11111111",	-- MOV_5  
	"00000101",	-- INC_3  
	"00001011",
	"11100101",	-- MOV_2  
	"00001011",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00001010",
	"00100010",	-- RET    
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00010100",
	"11110101",	-- MOV_8  
	"00010101",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00010110",
	"11110101",	-- MOV_8  
	"00010111",
	"10101111",	-- MOV_6  
	"00010101",
	"10101110",	-- MOV_6  
	"00010100",
	"10101101",	-- MOV_6  
	"00010111",
	"10101100",	-- MOV_6  
	"00010110",
	"01111011",	-- MOV_7  
	"00000001",
	"01111010",	-- MOV_7  
	"00000010",
	"01111001",	-- MOV_7  
	"00000000",
	"00010010",	-- LCALL  
	"00000010",
	"10111000",
	"10101100",	-- MOV_6  
	"00000110",
	"10101101",	-- MOV_6  
	"00000111",
	"11100101",	-- MOV_2  
	"00010111",
	"00100101",	-- ADD_2  
	"11100000",
	"11111011",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00010110",
	"00110011",	-- RLC    
	"11111010",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00010101",
	"11000100",	-- SWAP   
	"11111000",	-- MOV_5  
	"01010100",	-- ANL_4  
	"00001111",
	"11001000",	-- XCH_1  
	"01101000",	-- XRL_1  
	"11111111",	-- MOV_5  
	"11100101",	-- MOV_2  
	"00010100",
	"11000100",	-- SWAP   
	"01010100",	-- ANL_4  
	"11110000",
	"01001000",	-- ORL_1  
	"11111110",	-- MOV_5  
	"01110100",	-- MOV_4  
	"10000000",
	"00101111",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101110",	-- MOV_1  
	"00110100",	-- ADDC_4 
	"00000010",
	"11110101",	-- MOV_8  
	"10000011",
	"11100101",	-- MOV_2  
	"10000010",
	"00101011",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11101010",	-- MOV_1  
	"00110101",	-- ADDC_2 
	"10000011",
	"11110101",	-- MOV_8  
	"10000011",
	"11101100",	-- MOV_1  
	"11110000",	-- MOVX_4 
	"10100011",	-- INC_5  
	"11101101",	-- MOV_1  
	"11110000",	-- MOVX_4 
	"00000101",	-- INC_3  
	"00010111",
	"11100101",	-- MOV_2  
	"00010111",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00010110",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00010111",
	"10010100",	-- SUBB_4 
	"00001000",
	"11100101",	-- MOV_2  
	"00010110",
	"10010100",	-- SUBB_4 
	"00000000",
	"01000000",	-- JC     
	"10100110",
	"00000101",	-- INC_3  
	"00010101",
	"11100101",	-- MOV_2  
	"00010101",
	"01110000",	-- JNZ    
	"00000010",
	"00000101",	-- INC_3  
	"00010100",
	"11000011",	-- CLR_2  
	"11100101",	-- MOV_2  
	"00010101",
	"10010100",	-- SUBB_4 
	"00001000",
	"11100101",	-- MOV_2  
	"00010100",
	"10010100",	-- SUBB_4 
	"00000000",
	"01000000",	-- JC     
	"10001110",
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"00001010",
	"11110101",	-- MOV_8  
	"00001011",
	"00100010",	-- RET    
	"00000010",	-- LJMP   
	"00001000",
	"00000000",
	"00000101",	-- INC_3  
	"00000000",
	"11111111",	-- MOV_5  
	"11000000",	-- PUSH   
	"00000000",
	"00111110",	-- ADDC_1 
	"00000000",	-- NOP    
	"00111011",	-- ADDC_1 
	"00000000",	-- NOP    
	"00110101",	-- ADDC_2 
	"00000000",
	"00101101",	-- ADD_1  
	"00000000",	-- NOP    
	"00100011",	-- RL     
	"00000000",	-- NOP    
	"00011000",	-- DEC_2  
	"00000000",	-- NOP    
	"00001100",	-- INC_2  
	"11111111",	-- MOV_5  
	"11000000",	-- PUSH   
	"00000000",
	"00110101",	-- ADDC_2 
	"00000000",
	"00011000",	-- DEC_2  
	"11111111",	-- MOV_5  
	"11110100",	-- CPL_1  
	"11111111",	-- MOV_5  
	"11010011",	-- SETB_1 
	"11111111",	-- MOV_5  
	"11000010",	-- CLR_3  
	"11111111",
	"11000101",	-- XCH_2  
	"11111111",
	"11011101",	-- DJNZ_1 
	"11111111",
	"11000000",	-- PUSH   
	"00000000",
	"00100011",	-- RL     
	"11111111",	-- MOV_5  
	"11101000",	-- MOV_1  
	"11111111",	-- MOV_5  
	"11000010",	-- CLR_3  
	"11111111",
	"11010011",	-- SETB_1 
	"00000000",	-- NOP    
	"00001100",	-- INC_2  
	"00000000",	-- NOP    
	"00111011",	-- ADDC_1 
	"00000000",	-- NOP    
	"00110101",	-- ADDC_2 
	"11111111",
	"11000000",	-- PUSH   
	"00000000",
	"00001100",	-- INC_2  
	"11111111",	-- MOV_5  
	"11000101",	-- XCH_2  
	"11111111",
	"11011101",	-- DJNZ_1 
	"00000000",
	"00101101",	-- ADD_1  
	"00000000",	-- NOP    
	"00110101",	-- ADDC_2 
	"11111111",
	"11101000",	-- MOV_1  
	"11111111",	-- MOV_5  
	"11000010",	-- CLR_3  
	"11111111",
	"11000000",	-- PUSH   
	"11111111",
	"11110100",	-- CPL_1  
	"11111111",	-- MOV_5  
	"11000101",	-- XCH_2  
	"00000000",
	"00100011",	-- RL     
	"00000000",	-- NOP    
	"00101101",	-- ADD_1  
	"11111111",	-- MOV_5  
	"11001011",	-- XCH_1  
	"11111111",	-- MOV_5  
	"11101000",	-- MOV_1  
	"00000000",	-- NOP    
	"00111110",	-- ADDC_1 
	"11111111",	-- MOV_5  
	"11000000",	-- PUSH   
	"11111111",
	"11011101",	-- DJNZ_1 
	"11111111",
	"11101000",	-- MOV_1  
	"00000000",	-- NOP    
	"00111110",	-- ADDC_1 
	"11111111",	-- MOV_5  
	"11010011",	-- SETB_1 
	"11111111",	-- MOV_5  
	"11110100",	-- CPL_1  
	"00000000",	-- NOP    
	"00111011",	-- ADDC_1 
	"11111111",	-- MOV_5  
	"11001011",	-- XCH_1  
	"11111111",	-- MOV_5  
	"11000000",	-- PUSH   
	"11111111",
	"11001011",	-- XCH_1  
	"00000000",	-- NOP    
	"00011000",	-- DEC_2  
	"00000000",	-- NOP    
	"00001100",	-- INC_2  
	"11111111",	-- MOV_5  
	"11010011",	-- SETB_1 
	"00000000",	-- NOP    
	"00111110",	-- ADDC_1 
	"11111111",	-- MOV_5  
	"11000101",	-- XCH_2  
	"00000000",
	"00100011",	-- RL     
	"11111111",	-- MOV_5  
	"11000000",	-- PUSH   
	"11111111",
	"11000010",	-- CLR_3  
	"00000000",
	"00111011",	-- ADDC_1 
	"11111111",	-- MOV_5  
	"11001011",	-- XCH_1  
	"00000000",	-- NOP    
	"00101101",	-- ADD_1  
	"11111111",	-- MOV_5  
	"11011101",	-- DJNZ_1 
	"00000000",
	"00011000",	-- DEC_2  
	"11111111",	-- MOV_5  
	"11110100",	-- CPL_1  
	"11100100",	-- CLR_1  
	"11110101",	-- MOV_8  
	"10000000",
	"00010010",	-- LCALL  
	"00000000",
	"00000011",
	"00010010",	-- LCALL  
	"00000101",
	"10011110",
	"00010010",	-- LCALL  
	"00000111",
	"10010010",
	"00010010",	-- LCALL  
	"00000000",
	"00011001",
	"01110101",	-- MOV_12 
	"10000000",
	"00000001",
	"00010010",	-- LCALL  
	"00000000",
	"00011010",
	"01110101",	-- MOV_12 
	"10000000",
	"00000010",
	"00010010",	-- LCALL  
	"00000000",
	"10000101",
	"01110101",	-- MOV_12 
	"10000000",
	"00000011",
	"00010010",	-- LCALL  
	"00000010",
	"00000001",
	"01110101",	-- MOV_12 
	"10000000",
	"00000100",
	"10000000",	-- SJMP   
	"11111110",
	"00100010",	-- RET    
	"00100010",	-- RET    
	"10010000",	-- MOV_18 
	"11111111",
	"11111110",
	"11100000",	-- MOVX_2 
	"01110000",	-- JNZ    
	"11111010",
	"10010000",	-- MOV_18 
	"11111111",
	"11111111",
	"11101111",	-- MOV_1  
	"11110000",	-- MOVX_4 
	"00100010",	-- RET    
	"01111000",	-- MOV_7  
	"01111111",
	"11100100",	-- CLR_1  
	"11110110",	-- MOV_13 
	"11011000",	-- DJNZ_1 
	"11111101",
	"01110101",	-- MOV_12 
	"10000001",
	"01000111",
	"00000010",	-- LJMP   
	"00000111",
	"11100110",
	"00000010",	-- LJMP   
	"00000111",
	"01101011",
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"10100011",	-- INC_5  
	"11111000",	-- MOV_5  
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"10100011",	-- INC_5  
	"01000000",	-- JC     
	"00000011",
	"11110110",	-- MOV_13 
	"10000000",	-- SJMP   
	"00000001",
	"11110010",	-- MOVX_3 
	"00001000",	-- INC_2  
	"11011111",	-- DJNZ_1 
	"11110100",
	"10000000",	-- SJMP   
	"00101001",
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"10100011",	-- INC_5  
	"11111000",	-- MOV_5  
	"01010100",	-- ANL_4  
	"00000111",
	"00100100",	-- ADD_4  
	"00001100",
	"11001000",	-- XCH_1  
	"11000011",	-- CLR_2  
	"00110011",	-- RLC    
	"11000100",	-- SWAP   
	"01010100",	-- ANL_4  
	"00001111",
	"01000100",	-- ORL_4  
	"00100000",
	"11001000",	-- XCH_1  
	"10000011",	-- MOVC_2 
	"01000000",	-- JC     
	"00000100",
	"11110100",	-- CPL_1  
	"01010110",	-- ANL_3  
	"10000000",	-- SJMP   
	"00000001",
	"01000110",	-- ORL_3  
	"11110110",	-- MOV_13 
	"11011111",	-- DJNZ_1 
	"11100100",
	"10000000",	-- SJMP   
	"00001011",
	"00000001",	-- AJMP   
	"00000010",
	"00000100",	-- INC_1  
	"00001000",	-- INC_2  
	"00010000",	-- JBC    
	"00100000",
	"01000000",
	"10000000",	-- SJMP   
	"10010000",
	"00000110",	-- INC_4  
	"11100110",	-- MOV_3  
	"11100100",	-- CLR_1  
	"01111110",	-- MOV_7  
	"00000001",
	"10010011",	-- MOVC_1 
	"01100000",	-- JZ     
	"10111100",
	"10100011",	-- INC_5  
	"11111111",	-- MOV_5  
	"01010100",	-- ANL_4  
	"00111111",
	"00110000",	-- JNB    
	"11100101",
	"00001001",
	"01010100",	-- ANL_4  
	"00011111",
	"11111110",	-- MOV_5  
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"10100011",	-- INC_5  
	"01100000",	-- JZ     
	"00000001",
	"00001110",	-- INC_2  
	"11001111",	-- XCH_1  
	"01010100",	-- ANL_4  
	"11000000",
	"00100101",	-- ADD_2  
	"11100000",
	"01100000",	-- JZ     
	"10101000",
	"01000000",	-- JC     
	"10111000",
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"10100011",	-- INC_5  
	"11111010",	-- MOV_5  
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"10100011",	-- INC_5  
	"11111000",	-- MOV_5  
	"11100100",	-- CLR_1  
	"10010011",	-- MOVC_1 
	"10100011",	-- INC_5  
	"11001000",	-- XCH_1  
	"11000101",	-- XCH_2  
	"10000010",
	"11001000",	-- XCH_1  
	"11001010",	-- XCH_1  
	"11000101",	-- XCH_2  
	"10000011",
	"11001010",	-- XCH_1  
	"11110000",	-- MOVX_4 
	"10100011",	-- INC_5  
	"11001000",	-- XCH_1  
	"11000101",	-- XCH_2  
	"10000010",
	"11001000",	-- XCH_1  
	"11001010",	-- XCH_1  
	"11000101",	-- XCH_2  
	"10000011",
	"11001010",	-- XCH_1  
	"11011111",	-- DJNZ_1 
	"11101001",
	"11011110",	-- DJNZ_1 
	"11100111",
	"10000000",	-- SJMP   
	"10111110",
	"11101111",	-- MOV_1  
	"11111000",	-- MOV_5  
	"10001101",	-- MOV_9  
	"11110000",
	"10100100",	-- MUL    
	"11111111",	-- MOV_5  
	"11101101",	-- MOV_1  
	"11000101",	-- XCH_2  
	"11110000",
	"11001110",	-- XCH_1  
	"10100100",	-- MUL    
	"00101110",	-- ADD_1  
	"11111110",	-- MOV_5  
	"11101100",	-- MOV_1  
	"10001000",	-- MOV_9  
	"11110000",
	"10100100",	-- MUL    
	"00101110",	-- ADD_1  
	"11111110",	-- MOV_5  
	"00100010",	-- RET    
	"11000010",	-- CLR_3  
	"11010101",
	"11101100",	-- MOV_1  
	"00110000",	-- JNB    
	"11100111",
	"00001001",
	"10110010",	-- CPL_3  
	"11010101",
	"11100100",	-- CLR_1  
	"11000011",	-- CLR_2  
	"10011101",	-- SUBB_1 
	"11111101",	-- MOV_5  
	"11100100",	-- CLR_1  
	"10011100",	-- SUBB_1 
	"11111100",	-- MOV_5  
	"11101110",	-- MOV_1  
	"00110000",	-- JNB    
	"11100111",
	"00010101",
	"10110010",	-- CPL_3  
	"11010101",
	"11100100",	-- CLR_1  
	"11000011",	-- CLR_2  
	"10011111",	-- SUBB_1 
	"11111111",	-- MOV_5  
	"11100100",	-- CLR_1  
	"10011110",	-- SUBB_1 
	"11111110",	-- MOV_5  
	"00010010",	-- LCALL  
	"00001001",
	"00010101",
	"11000011",	-- CLR_2  
	"11100100",	-- CLR_1  
	"10011101",	-- SUBB_1 
	"11111101",	-- MOV_5  
	"11100100",	-- CLR_1  
	"10011100",	-- SUBB_1 
	"11111100",	-- MOV_5  
	"10000000",	-- SJMP   
	"00000011",
	"00010010",	-- LCALL  
	"00001001",
	"00010101",
	"00110000",	-- JNB    
	"11010101",
	"00000111",
	"11000011",	-- CLR_2  
	"11100100",	-- CLR_1  
	"10011111",	-- SUBB_1 
	"11111111",	-- MOV_5  
	"11100100",	-- CLR_1  
	"10011110",	-- SUBB_1 
	"11111110",	-- MOV_5  
	"00100010",	-- RET    
	"10111011",	-- CJNE_3 
	"00000001",
	"00010000",
	"11100101",	-- MOV_2  
	"10000010",
	"00101001",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000010",
	"11100101",	-- MOV_2  
	"10000011",
	"00111010",	-- ADDC_1 
	"11110101",	-- MOV_8  
	"10000011",
	"11100000",	-- MOVX_2 
	"11110101",	-- MOV_8  
	"11110000",
	"10100011",	-- INC_5  
	"11100000",	-- MOVX_2 
	"00100010",	-- RET    
	"01010000",	-- JNC    
	"00001001",
	"11101001",	-- MOV_1  
	"00100101",	-- ADD_2  
	"10000010",
	"11111000",	-- MOV_5  
	"10000110",	-- MOV_11 
	"11110000",
	"00001000",	-- INC_2  
	"11100110",	-- MOV_3  
	"00100010",	-- RET    
	"10111011",	-- CJNE_3 
	"11111110",
	"00001010",
	"11101001",	-- MOV_1  
	"00100101",	-- ADD_2  
	"10000010",
	"11111000",	-- MOV_5  
	"11100010",	-- MOVX_1 
	"11110101",	-- MOV_8  
	"11110000",
	"00001000",	-- INC_2  
	"11100010",	-- MOVX_1 
	"00100010",	-- RET    
	"11100101",	-- MOV_2  
	"10000011",
	"00101010",	-- ADD_1  
	"11110101",	-- MOV_8  
	"10000011",
	"11101001",	-- MOV_1  
	"10010011",	-- MOVC_1 
	"11110101",	-- MOV_8  
	"11110000",
	"10100011",	-- INC_5  
	"11101001",	-- MOV_1  
	"10010011",	-- MOVC_1 
	"00100010",	-- RET    
	"11101000",	-- MOV_1  
	"10001111",	-- MOV_9  
	"11110000",
	"10100100",	-- MUL    
	"11001100",	-- XCH_1  
	"10001011",	-- MOV_9  
	"11110000",
	"10100100",	-- MUL    
	"00101100",	-- ADD_1  
	"11111100",	-- MOV_5  
	"11101001",	-- MOV_1  
	"10001110",	-- MOV_9  
	"11110000",
	"10100100",	-- MUL    
	"00101100",	-- ADD_1  
	"11111100",	-- MOV_5  
	"10001010",	-- MOV_9  
	"11110000",
	"11101101",	-- MOV_1  
	"10100100",	-- MUL    
	"00101100",	-- ADD_1  
	"11111100",	-- MOV_5  
	"11101010",	-- MOV_1  
	"10001110",	-- MOV_9  
	"11110000",
	"10100100",	-- MUL    
	"11001101",	-- XCH_1  
	"10101000",	-- MOV_6  
	"11110000",
	"10001011",	-- MOV_9  
	"11110000",
	"10100100",	-- MUL    
	"00101101",	-- ADD_1  
	"11001100",	-- XCH_1  
	"00111000",	-- ADDC_1 
	"00100101",	-- ADD_2  
	"11110000",
	"11111101",	-- MOV_5  
	"11101001",	-- MOV_1  
	"10001111",	-- MOV_9  
	"11110000",
	"10100100",	-- MUL    
	"00101100",	-- ADD_1  
	"11001101",	-- XCH_1  
	"00110101",	-- ADDC_2 
	"11110000",
	"11111100",	-- MOV_5  
	"11101011",	-- MOV_1  
	"10001110",	-- MOV_9  
	"11110000",
	"10100100",	-- MUL    
	"11111110",	-- MOV_5  
	"10101001",	-- MOV_6  
	"11110000",
	"11101011",	-- MOV_1  
	"10001111",	-- MOV_9  
	"11110000",
	"10100100",	-- MUL    
	"11001111",	-- XCH_1  
	"11000101",	-- XCH_2  
	"11110000",
	"00101110",	-- ADD_1  
	"11001101",	-- XCH_1  
	"00111001",	-- ADDC_1 
	"11111110",	-- MOV_5  
	"11100100",	-- CLR_1  
	"00111100",	-- ADDC_1 
	"11111100",	-- MOV_5  
	"11101010",	-- MOV_1  
	"10100100",	-- MUL    
	"00101101",	-- ADD_1  
	"11001110",	-- XCH_1  
	"00110101",	-- ADDC_2 
	"11110000",
	"11111101",	-- MOV_5  
	"11100100",	-- CLR_1  
	"00111100",	-- ADDC_1 
	"11111100",	-- MOV_5  
	"00100010",	-- RET    
	"11100110",	-- MOV_3  
	"11111011",	-- MOV_5  
	"00001000",	-- INC_2  
	"11100110",	-- MOV_3  
	"11111001",	-- MOV_5  
	"00001000",	-- INC_2  
	"11100110",	-- MOV_3  
	"11111010",	-- MOV_5  
	"00001000",	-- INC_2  
	"11100110",	-- MOV_3  
	"11001011",	-- XCH_1  
	"11111000",	-- MOV_5  
	"00100010",	-- RET    
	"11101100",	-- MOV_1  
	"11110110",	-- MOV_13 
	"00001000",	-- INC_2  
	"11101101",	-- MOV_1  
	"11110110",	-- MOV_13 
	"00001000",	-- INC_2  
	"11101110",	-- MOV_1  
	"11110110",	-- MOV_13 
	"00001000",	-- INC_2  
	"11101111",	-- MOV_1  
	"11110110",	-- MOV_13 
	"00100010",	-- RET    
	"10111100",	-- CJNE_3 
	"00000000",
	"00001011",
	"10111110",	-- CJNE_3 
	"00000000",
	"00101001",
	"11101111",	-- MOV_1  
	"10001101",	-- MOV_9  
	"11110000",
	"10000100",	-- DIV    
	"11111111",	-- MOV_5  
	"10101101",	-- MOV_6  
	"11110000",
	"00100010",	-- RET    
	"11100100",	-- CLR_1  
	"11001100",	-- XCH_1  
	"11111000",	-- MOV_5  
	"01110101",	-- MOV_12 
	"11110000",
	"00001000",
	"11101111",	-- MOV_1  
	"00101111",	-- ADD_1  
	"11111111",	-- MOV_5  
	"11101110",	-- MOV_1  
	"00110011",	-- RLC    
	"11111110",	-- MOV_5  
	"11101100",	-- MOV_1  
	"00110011",	-- RLC    
	"11111100",	-- MOV_5  
	"11101110",	-- MOV_1  
	"10011101",	-- SUBB_1 
	"11101100",	-- MOV_1  
	"10011000",	-- SUBB_1 
	"01000000",	-- JC     
	"00000101",
	"11111100",	-- MOV_5  
	"11101110",	-- MOV_1  
	"10011101",	-- SUBB_1 
	"11111110",	-- MOV_5  
	"00001111",	-- INC_2  
	"11010101",	-- DJNZ_2 
	"11110000",
	"11101001",
	"11100100",	-- CLR_1  
	"11001110",	-- XCH_1  
	"11111101",	-- MOV_5  
	"00100010",	-- RET    
	"11101101",	-- MOV_1  
	"11111000",	-- MOV_5  
	"11110101",	-- MOV_8  
	"11110000",
	"11101110",	-- MOV_1  
	"10000100",	-- DIV    
	"00100000",	-- JB     
	"11010010",
	"00011100",
	"11111110",	-- MOV_5  
	"10101101",	-- MOV_6  
	"11110000",
	"01110101",	-- MOV_12 
	"11110000",
	"00001000",
	"11101111",	-- MOV_1  
	"00101111",	-- ADD_1  
	"11111111",	-- MOV_5  
	"11101101",	-- MOV_1  
	"00110011",	-- RLC    
	"11111101",	-- MOV_5  
	"01000000",	-- JC     
	"00000111",
	"10011000",	-- SUBB_1 
	"01010000",	-- JNC    
	"00000110",
	"11010101",	-- DJNZ_2 
	"11110000",
	"11110010",
	"00100010",	-- RET    
	"11000011",	-- CLR_2  
	"10011000",	-- SUBB_1 
	"11111101",	-- MOV_5  
	"00001111",	-- INC_2  
	"11010101",	-- DJNZ_2 
	"11110000",
	"11101010",
	"00100010",	-- RET    
	"00000000",	-- NOP    
	"00000000");	-- NOP    
begin

    process(rst, clk)
    begin
        if( rst = '1' ) then

            data <= CD_8;
        elsif( clk'event and clk = '1' ) then

            if( rd = '1' ) then

                data <= PROGRAM(conv_integer(addr));
            else

                data <= CD_8;
            end if;
        end if;
    end process;
end BHV;