/*
 * Copyright (c) 1999-2000 University of California, Riverside.
 * Permission to copy is granted provided that this header remains
 * intact.  This software is provided with no warranties.
 *
 * Version : 1.0
 */

/*--------------------------------------------------------------------------*/

#include "ccdpp.h"
#include "codec.h"
#include "uat.h"

/*--------------------------------------------------------------------------*/

#define SZ_ROW          16
#define SZ_COL          16
#define NUM_ROW_BLOCKS  (SZ_ROW / 8)
#define NUM_COL_BLOCKS  (SZ_COL / 8)

/*--------------------------------------------------------------------------*/

static short xdata buffer[SZ_ROW][SZ_COL];

/*--------------------------------------------------------------------------*/

void CntrlInitialize(void) {
    
    /* no code */    
}

/*--------------------------------------------------------------------------*/

void CntrlCaputreImage(void) {
    
    unsigned short i, j;
    
    CcdppCapture();
    for(i=0; i<SZ_ROW; i++) {
        
        for(j=0; j<SZ_COL; j++) {
            
            buffer[i][j] = CcdppPopPixel();
        }
    }
}

/*--------------------------------------------------------------------------*/

void CntrlCompressImage(void) {
    
    const unsigned char code QuantShiftTable[8][8] = {
        
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 1, 1, 1, 1 },
        { 1, 1, 1, 1, 1, 1, 2, 2 },
        { 2, 2, 2, 2, 2, 2, 2, 3 },
        { 3, 3, 3, 3, 3, 3, 3, 4 },
        { 4, 4, 4, 4, 4, 4, 5, 5 },
        { 5, 5, 5, 5, 6, 6, 6, 6 },
        { 6, 7, 7, 7, 7, 8, 8, 8 }
    };

    short temp;
    unsigned short i, j, k, l;
    
    for(i=0; i<NUM_ROW_BLOCKS; i++) {
        
        for(j=0; j<NUM_COL_BLOCKS; j++) {
            
            /* push the block and perform FDCT */
            for(k=0; k<8; k++) {
                
                for(l=0; l<8; l++) {
                    
                    CodecPushPixel((char)buffer[i * 8 + k][j * 8 + l]);
                }
            }
            CodecDoFdct();
            
            /* pop the block and store in buffer after quantization */
            for(k=0; k<8; k++) {
                
                for(l=0; l<8; l++) {
                    
                    temp = CodecPopPixel() >> QuantShiftTable[k][l];
		    
                    buffer[i * 8 + k][j * 8 + l] = temp;
                }
            }
        }
    }
}

/*--------------------------------------------------------------------------*/

void CntrlSendImage(void) {
    
    short temp;
    unsigned short i, j;
    
    for(i=0; i<SZ_ROW; i++) {
        
        for(j=0; j<SZ_COL; j++) {
            
            temp = buffer[i][j];
            
            UatSend(((char*)&temp)[0]);    /* send upper byte */
            UatSend(((char*)&temp)[1]);    /* send lower byte */
        }
    }   
}
