--
-- Copyright (c) 1999-2000 University of California, Riverside.
-- Permission to copy is granted provided that this header remains
-- intact.  This software is provided with no warranties.
--
-- Version : 1.0
--

-------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;

-------------------------------------------------------------------------------

entity CCD is
    port(rst  : in  STD_LOGIC;
         clk  : in  STD_LOGIC;
         rd   : in  STD_LOGIC;
         data : out UNSIGNED (7 downto 0));
end CCD;

-------------------------------------------------------------------------------

architecture BHV of CCD is

    type ROW_TYPE is array (0 to 17) of UNSIGNED (7 downto 0);
    type IMAGE_TYPE is array (0 to 15) of ROW_TYPE;

    constant CD_8 : UNSIGNED (7 downto 0) := "--------";

    constant ROW_00 : ROW_TYPE := (

        "00111101","00110011","11100011","10110001",
        "00110110","00111011","00100100","01111110",
        "01011000","00000110","10100111","01011011",
        "01010101","01010010","10100001","00011011",
        "01100001","00101111"
    );

    constant ROW_01 : ROW_TYPE := (

        "01011111","11101111","11100100","00001111",
        "00110001","11101011","01111010","10011010",
        "11001000","01100100","01011100","10001011",
        "11000110","00101110","00101110","01011110",
        "01010010","11110011"
    );

    constant ROW_02 : ROW_TYPE := (

        "10001110","11010110","00011010","11011101",
        "00111100","11101110","11101001","01011110",
        "00100010","01000101","11011100","01000110",
        "01100000","01011010","01101111","10110001",
        "00111100","11110111"
    );

    constant ROW_03 : ROW_TYPE := (

        "11111101","11111101","00001001","10011001",
        "10100110","11100100","00111001","00001100",
        "01111101","01010011","11100111","00101001",
        "01100010","00100100","00010001","11001110",
        "01011110","11011111"
    );

    constant ROW_04 : ROW_TYPE := (

        "11011100","11101100","00100110","01100110",
        "01001010","00000111","01111111","11110011",
        "11111010","00000100","10011100","01100111",
        "10010010","11101011","10101111","10011101",
        "11100101","00100001"
    );

    constant ROW_05 : ROW_TYPE := (

        "01111001","11001001","11101001","00010110",
        "10011000","11110110","11111101","00110101",
        "01110010","11111000","11111011","00110010",
        "01000100","11000011","10101001","01000101",
        "11001101","10001101"
    );

    constant ROW_06 : ROW_TYPE := (

        "00001111","10100000","11100010","00011010",
        "11100001","10110001","10001100","10111010",
        "00000000","00001011","10000011","00001111",
        "10000001","10101011","10110011","11100000",
        "11000110","11010001"
    );

    constant ROW_07 : ROW_TYPE := (

        "00011011","00101101","01100110","01000010",
        "11000011","10001110","01101101","10010010",
        "10001001","10100001","01001111","11000101",
        "00000011","10101100","00101010","11110011",
        "00000011","11000111"
    );

    constant ROW_08 : ROW_TYPE := (

        "00111010","11001110","10111101","11101000",
        "11111001","00110101","11010101","00001100",
        "01110100","00001010","11111100","01000010",
        "10000011","11010010","11100110","11010000",
        "01110001","00010100"
    );

    constant ROW_09 : ROW_TYPE := (

        "11110111","00010101","11010101","11101110",
        "10111011","10110011","01100011","01001110",
        "01001100","10000000","01111001","01110100",
        "10111000","01101010","00111001","10011010",
        "10001101","01111110"
    );

    constant ROW_10 : ROW_TYPE := (

        "01100111","11001101","11001111","01101010",
        "01010000","10000000","00010010","00101011",
        "11100010","10000101","11000101","01111101",
        "11111011","01101001","11000110","11000001",
        "00001110","00000110"
    );

    constant ROW_11 : ROW_TYPE := (

        "11110111","10110001","10000111","11110110",
        "10000010","00101011","00010100","01110111",
        "11011101","10110100","00100001","11101101",
        "00111100","10100011","11011101","11100000",
        "00001011","01110000"
    );

    constant ROW_12 : ROW_TYPE := (

        "10111110","00000001","11011101","00011110",
        "11100100","00000110","01111100","10100001",
        "11100010","00001110","11010110","10010111",
        "10101000","00111010","10100001","01010110",
        "01110010","01110100"
    );

    constant ROW_13 : ROW_TYPE := (

        "01001101","00001010","00010000","00101000",
        "01000110","11001101","10111010","10100011",
        "00111100","11010101","00011101","00011000",
        "00110001","01110010","11011010","10101001",
        "11010011","10110100"
    );

    constant ROW_14 : ROW_TYPE := (

        "10011101","01100001","10111011","11001000",
        "00111001","01010010","01110111","01001000",
        "00110000","11000010","10101001","01000110",
        "00010110","11011101","01100011","00100010",
        "01110011","10101011"
    );

    constant ROW_15 : ROW_TYPE := (

        "10100111","00100000","10100001","11010110",
        "00001001","00000111","10100010","10100100",
        "01110101","00000010","00101111","00100010",
        "00011100","10111101","11011000","11110010",
        "00000010","01110111"
    );

    constant IMAGE : IMAGE_TYPE := (

        ROW_00, ROW_01, ROW_02, ROW_03, ROW_04, ROW_05, ROW_06, ROW_07,
        ROW_08, ROW_09, ROW_10, ROW_11, ROW_12, ROW_13, ROW_14, ROW_15
    );
    
    signal row : INTEGER;
    signal col : INTEGER;
begin
    process(rst, clk)
    begin
        if( rst = '1' ) then

            row <= 0;
            col <= 0;
            data <= CD_8;
        elsif( clk'event and clk = '1' ) then

            if( rd = '1' ) then

                if( row < 16 ) then
                  
                  data <= IMAGE(row)(col);
                end if;
                
                col <= col + 1;
                if( col = 17 ) then

                    col <= 0;
                    row <= row + 1;
                end if;
            end if;
        end if;
    end process;
end BHV;








