#include "systemc.h"

SC_MODULE( uart )
{
   // UART Ports
   sc_fifo_in<char>  data_in;
   
   // UART Vars
   FILE  *outputFileHandle;
   char   data;

   // UART Processes
   void uartSend(void) 
   {
      while(1) {
         data = data_in.read();
         fprintf(outputFileHandle, "%i\n", (int)data);
      }
   }

   // Module Constructor
   SC_CTOR( uart )
   {
      outputFileHandle = fopen("uart_out.txt", "w");
      SC_THREAD( uartSend );
   }

   // Module Destructor
   ~uart(void)
   {
      fclose(outputFileHandle);
   }
};   

