#include "systemc.h"
#include "ccd.h"
#include "ccdpp.h"
#include "cntrl.h"
#include "codec.h"
#include "uart.h"

int sc_main(int, char**)
{
   // Module Instances
   ccd   CCD("ccd");
   ccdpp CCDPP("ccdpp");
   codec CODEC("codec");
   uart  UART("uart");
   cntrl CNTRL("cntrl");

   // Channel Instances
   sc_fifo<bool>	startCcdCapture("startCcdCapture", 1);
   sc_fifo<bool>	doneCcdCapture("doneCcdCapture", 1);
   sc_fifo<char>    ccdPixel("ccdPixel", 1);
   sc_fifo<bool>    startCcdppCapture("startCcdppCapture", 1);
   sc_fifo<bool>	doneCcdppCapture("doneCcdppCapture", 1);
   sc_fifo<char>	ccdppPixel("ccdppPixel", 1);
   sc_fifo<short>	codecPixelPush("codecPixelPush", 1);
   sc_fifo<short>   codecPixelPop("codecPixelPop", 1);
   sc_fifo<char>    uartPixel("uartPixel", 1);

   // CCD Port Bindings
   CCD.startCcdCapture( startCcdCapture );
   CCD.doneCcdCapture( doneCcdCapture );
   CCD.pixel( ccdPixel );

   // CCDPP Port Bindings
   CCDPP.startCcdCapture( startCcdCapture );
   CCDPP.doneCcdCapture( doneCcdCapture );
   CCDPP.ccdPixel( ccdPixel );
   CCDPP.startCcdppCapture( startCcdppCapture );
   CCDPP.doneCcdppCapture( doneCcdppCapture );
   CCDPP.ccdppPixel( ccdppPixel );

   // CODEC Port Bindings
   CODEC.pixelIn( codecPixelPush );
   CODEC.pixelOut( codecPixelPop );

   // UART Port Bindings
   UART.data_in( uartPixel );

   // CNTRL Port Bindings
   CNTRL.startCapture( startCcdppCapture );
   CNTRL.doneCapture( doneCcdppCapture );
   CNTRL.ccdppPixelPop( ccdppPixel );
   CNTRL.codecPixelPush( codecPixelPush );
   CNTRL.codecPixelPop( codecPixelPop );
   CNTRL.uartPixel( uartPixel );

   // Begin UNTIMED Simulation
   sc_start(-1);

   return 0;
}
