#include "systemc.h"

const short COS_TABLE[64] = {
   64,  62,  59,  53,  45,  35,  24,  12,
   64,  53,  24, -12, -45, -62, -59, -35,
   64,  35, -24, -62, -45,  12,  59,  53,
   64,  12, -59, -35,  45,  53, -24, -62,
   64, -12, -59,  35,  45, -53, -24,  62,
   64, -35, -24,  62, -45, -12,  59, -53,
   64, -53,  24,  12, -45,  62, -59,  35,
   64, -62,  59, -53,  45, -35,  24, -12
};

SC_MODULE( codec )
{
   // CODEC Ports
   sc_fifo_in<short>    pixelIn;
   sc_fifo_out<short>   pixelOut;

   // CODEC Vars
   int   idx;
   int   i;
   short inBuffer[8][8], outBuffer[8][8];

   // FDCT Functions
   unsigned char C(int h) {
      return h ? 64 : 5;
   }

   int F(int u, int v, short img[8][8]) {

      long  s[8];
      long  r;
      unsigned char  a;

      for(a=0; a<8; a++) 
      {
         s[a] = ((img[a][0] * COS_TABLE[v])    >> 6) +
                ((img[a][1] * COS_TABLE[8+v])  >> 6) +
                ((img[a][2] * COS_TABLE[16+v]) >> 6) +
                ((img[a][3] * COS_TABLE[24+v]) >> 6) +
                ((img[a][4] * COS_TABLE[32+v]) >> 6) +
                ((img[a][5] * COS_TABLE[40+v]) >> 6) +
                ((img[a][6] * COS_TABLE[48+v]) >> 6) +
                ((img[a][7] * COS_TABLE[56+v]) >> 6);
      }

      r = 0;
      for(a=0; a<8; a++) 
      {
         r += (s[a] * COS_TABLE[a * 8 + u]) >> 6;
      }

      return (short)((((((r * 16) >> 6) * C(u)) >> 6) * C(v)) >> 6);
   }

   // CODEC Processes
   void main(void) {
      int x, y;

      i = 0;
      while(i < 128) {
         // CODEC Push Pixel
         for(idx=0; idx<64; idx++)
         {
            inBuffer[idx / 8][idx % 8] = (pixelIn.read() << 6);
         }         

         // CODEC Do FDCT
         for(x=0; x<8; x++) {

            for(y=0; y<8; y++) {
               outBuffer[x][y] = F(x, y, inBuffer);
            }
         }
         idx = 0;

         // CODEC Pop Pixel
         for(idx=0; idx<64; idx++)
         {
            pixelOut.write( outBuffer[idx / 8][idx % 8] );
         }
         ++i;
      }
   }

   // Module Constructor
   SC_CTOR( codec ) {
      SC_THREAD( main );
   }
};