#include "systemc.h"

#define CCDPP_ROW      64
#define CCDPP_COL      128

SC_MODULE( ccdpp )
{
   // CCDPP Ports
   sc_fifo_in<bool>  startCcdppCapture, doneCcdCapture;
   sc_fifo_in<char>  ccdPixel;
   sc_fifo_out<bool> doneCcdppCapture, startCcdCapture;
   sc_fifo_out<char> ccdppPixel;

   // CCDPP Vars
   char buffer[CCDPP_ROW][CCDPP_COL];
   int  rowIndex, colIndex;
   char bias;

   // CCDPP Events
   sc_event   startPop;
   
   // CCDPP Processes
   void capture(void) 
   {
      startCcdppCapture.read();
      startCcdCapture.write( true );
      doneCcdCapture.read();

      for(rowIndex=0; rowIndex<CCDPP_ROW; rowIndex++)
      {
         for(colIndex=0; colIndex<CCDPP_COL; colIndex++)
         {
            buffer[rowIndex][colIndex] = ccdPixel.read();
         }

         bias = ccdPixel.read();
         bias = ( bias + ccdPixel.read() ) / 2;
         for(colIndex=0; colIndex<CCDPP_COL; colIndex++)
         {
            buffer[rowIndex][colIndex] -= bias;
         }
      }

      doneCcdppCapture.write( true );
      notify(startPop);
   }

   void pop(void)
   {
      wait(startPop);
      for(rowIndex=0; rowIndex<CCDPP_ROW; rowIndex++) 
      {
         for(colIndex=0; colIndex<CCDPP_COL; colIndex++) 
         {
            ccdppPixel.write( buffer[rowIndex][colIndex] );
         }
      }
   }

   // Module Constructor
   SC_CTOR( ccdpp ) {
      SC_THREAD( capture );
      SC_THREAD( pop );
   }
};