#include "systemc.h"

#define CLK_CYCLE      10

SC_MODULE( uart )
{
   // UART Ports
   sc_fifo_in<char>  data_in;
   
   // UART Vars
   FILE  *outputFileHandle;
   char   data;
   double sim_time;

   // UART Processes
   void uartSend(void) 
   {
	  sim_time = sc_simulation_time();
      while(1) {
         data = data_in.read();
		 wait(2*CLK_CYCLE, SC_NS);
         fprintf(outputFileHandle, "%i\n", (int)data);
      }
   }

   // Module Constructor
   SC_CTOR( uart )
   {
      outputFileHandle = fopen("uart_out.txt", "w");
      SC_THREAD( uartSend );
   }

   // Module Destructor
   ~uart(void)
   {
      cout << "UART\tdone at " 
           << (sc_simulation_time()/1000) << " us\t"
           << "execution time = " 
           << (sc_simulation_time() - sim_time)/1000 << " us" << endl;
      fclose(outputFileHandle);
   }
};   

