#include "systemc.h"

#define CCDPP_ROW      64
#define CCDPP_COL      128
#define CLK_CYCLE      10

SC_MODULE( ccdpp )
{
   // CCDPP Ports
   sc_fifo_in<bool>  startCcdppCapture, doneCcdCapture;
   sc_fifo_in<char>  ccdPixel;
   sc_fifo_out<bool> doneCcdppCapture, startCcdCapture;
   sc_fifo_out<char> ccdppPixel;

   // CCDPP Vars
   char buffer[CCDPP_ROW][CCDPP_COL];
   int  rowIndex, colIndex;
   char bias;
   double   sim_time;

   // CCDPP Events
   sc_event   startPop;
   
   // CCDPP Processes
   void capture(void) 
   {
      startCcdppCapture.read();
	  sim_time = sc_simulation_time();
      startCcdCapture.write( true );
      doneCcdCapture.read();

      for(rowIndex=0; rowIndex<CCDPP_ROW; rowIndex++)
      {
         for(colIndex=0; colIndex<CCDPP_COL; colIndex++)
         {
            buffer[rowIndex][colIndex] = ccdPixel.read();
			wait(2*CLK_CYCLE, SC_NS);
         }

         bias = ccdPixel.read();
         bias = ( bias + ccdPixel.read() ) / 2;
		 wait(12*CLK_CYCLE, SC_NS);
         for(colIndex=0; colIndex<CCDPP_COL; colIndex++)
         {
            buffer[rowIndex][colIndex] -= bias;
			wait(4*CLK_CYCLE, SC_NS);
         }
      }

      doneCcdppCapture.write( true );
      notify(startPop);
   }

   void pop(void)
   {
      wait(startPop);
      for(rowIndex=0; rowIndex<CCDPP_ROW; rowIndex++) 
      {
         for(colIndex=0; colIndex<CCDPP_COL; colIndex++) 
         {
            ccdppPixel.write( buffer[rowIndex][colIndex] );
			wait(2*CLK_CYCLE, SC_NS);
         }
      }
	  cout << "CCDPP\tdone at " 
           << (sc_simulation_time()/1000) << " us\t"
           << "execution time = " 
           << (sc_simulation_time() - sim_time)/1000 << " us" << endl;
   }

   // Module Constructor
   SC_CTOR( ccdpp ) {
      SC_THREAD( capture );
      SC_THREAD( pop );
   }
};