#include "systemc.h"

#define CCD_ROW          64
#define CCD_COL          (128+2)

const char IMAGE[CCD_ROW * CCD_COL] = {
     86,   92,  -63,   -5,  -98,   19,  -87,  -47,   45,  -17, 
     54, -114, -114,  -60, -106, -108,  -52,  -39,  -92,   67, 
     -8,  115,   65,  -26,   91,   33,  114,   99,  121,  -56, 
     56,  -95,  -52,  109,   50,  -73,   60,  -60,  -12,  -39, 
     96,  124,   37,    2,  118,   71,   90,   96,   34,  -85, 
    -76, -125,  -23, -118,   58,   68,  108,  114,  -10,  117, 
     99,  -92,  -47,   77,   95,  -27,   47, -111,   63,    7, 
     73, -126,  109,   54,   77, -119,  -31,    2,   54,  -93, 
    -46,   48,  107, -115,   59,   63,   25,  -81,   20,  -69, 
     79,  -56,   77,   68,  -34,   93, -119,   93,  -18,  -30, 
    -98,  -12,   96,  -91,  -49,  -75,  -26,  125,  -58,   13, 
    -30,   54,   83,   -1,    1,  -70,  -26,  -86, -106,   -1, 
    -51, -107,  -74,  -77,   44,  -64,   24,  -87,   15,    4, 
    -87,    1,   82,  -93,  -15,   25,   -4, -112,   40,   54, 
     30, -128,   22,  -16,   30,  -78,  -82,   97,  -30,  -29, 
    105,   13,   13, -103,   98, -113,   -5,   48,   53,    8, 
    125,  -88, -105,   70,   83,   44,  -76,  -74,  109,   97, 
     76,   11,  -31,  115, -117,  -86,  -85,  -32,  -85,  -37, 
     38,    1,   74,  -80,   77,   93, -117,  -77,  -80,  -84, 
    -17,   82,   55,  -84,  -16,   10, -103,  -90,   98,   85, 
   -102,  -65, -120,   84,    7,   -2,   -8,   59,  113,   32, 
     47,  127,  -85,   30,  -14,  -63,    4,  122,  106,  120, 
     68,   76,   -3,   96,  103,   15,  -19,  -91,   27,   43, 
    -79,  -50,   -6,   65,   22,  106, -121,   57,   21,  123, 
    -23,   12,  113,  -90,  105,   80,   24,   23,  -85, -120, 
     53,   53,  -81,   40,   23,    9, -123,  105,   11,    1, 
    -46,  -47,   91,   -9,    6, -127,   45,  -92,   90,   60, 
   -102,   67, -117,   58,  -84,  -89,   87,  -79,  116, -118, 
    -70,   31,   38,   66,  -24,   88,  -11,   38,    9,   82, 
    -81,  -67,  -74,  -78,   23,  -85,   54,   21,    6,   90, 
    119,   30,   63,  107,  -50,   68,   21,  -38,  110,   87, 
    -66,  -13,  -87,  -42,  116,   -8,  -24,  -13,   80, -114, 
    106,   98,  -27,  -22,  -66,  -28,  -98,  -65,    1, -106, 
    -41,  -27,  -40,   -7,  -67,  -54,   43,  -64,  -27, -104, 
    -90,   92,  -82,   42,  -17,   71,   87,  -82,  -90,   19, 
    -34,   25,   33,   49,  -98,   79,  -29, -127,  -90,   14, 
    -32,  -99,  -38,  -99,  115,  -28,  -53,   56,   26,   71, 
     85,   57,  -10,  -42,   -3,    6,    5,    9,    7,  -67, 
     28,  -50,   89,  -96,  -91,   86,   18,   65,    2,    0, 
    -23,  109,   75,  -64,   70,  -39,   64,  -10,   33, -114, 
     18,  113, -100,   19,   87,  -34,   97,   95,   98,  -76, 
    -67,  124,   64,   62,  120,   -5,  112,  107,  122,   26, 
    100,   87,   30,  -74,  -70, -104,   83,  -15,   57,   73, 
    119,  -93, -116,  -41,  -14, -127,  -63, -115, -108,   14, 
   -128,  -33,  -81,   68,   10,  121,  -13,    1,   -8,    7, 
     12,   50,  -81,  -63,   -3,  -63,  -92,  -67,   57,   62, 
     84,  -13, -123,   79,    0,   15, -113,  -40,   43,   -7, 
     77,  -22,  -43,   36,   23,  108,  116, -103, -125, -118, 
    -75,  -63,    2,  -32,  -10,  -11,   62,  100, -126,  -57, 
     48,   23, -119,   13,    4,  107,  -26,  -78,  -84,  114, 
   -113,   59,   69,  -53,  -39,   25,   44,   76,  116,  -76, 
    -34,  111,   33,   51, -109,  124,   51,   12,    6,    5, 
    -53,   78,  113,  -43,  -46,  -80,  -86,  -49,  -75,   88, 
   -128,  -89,  -30,  107,   50, -117,    6,   88,   38,   61, 
      3,  -29,  -66, -121,  -78,  -13,   -8,   95,   92,   27, 
    -57,  -39,   -8,  -22,   51,  -49,   37,  -14,   49,   82, 
    -26, -104,   66,  -50,   31,  -95,  -50,   -1,  -46,  119, 
     62, -106,   24,   62,  -38,  -86,  -32, -101,  103,  -32, 
    106,   61,  127,   89, -127,   51,  -82,   94,  123,  -20, 
     80,  -52,  -16,   12,   44,   63,   60,  -11,  -48,    1, 
    -75,   16,  -86,  -80,  -84,  -34,  -22,  -79,   37,  -63, 
     26,   88,   85, -119,  120,  -46,  -34,  -63,   26,  -39, 
    -53,  -74,  -65,   22,   77,   75,  118,   83,   50,  126, 
    -16,  104,   41,  -71,  -92,  -30,  -73,  -39,  -89,  116, 
     -9,   -2,   71,   30,   20,   23,  109,   29,    9,    4, 
    -81, -104,   14,  104,   55,    7,  114,  -19,   86,   98, 
     -7,   86,  -26,   13,  -92,   11,   99, -123,   48,   72, 
    -57,  -54,  -49,  -22,   40, -118,  -96,   -1,   19,   18, 
    -14,   11,  -90,  -12,   60,   26,  110,  119,  -38, -119, 
      6,  -62, -120, -108,  106,  -57,  -97,  -98,   31,  -16, 
     17,   67,    4, -117,   36,   29,  -11,  -11,  -16,   88, 
     35, -120, -102,   -8,   53,   68,   77,  -28,   30,   63, 
     -5,  -71,  -68,  -50,  -40,   79,   53,  111, -111,   10, 
     16,  124,   80,  -31,   21, -112,  111,   47,  -28,  -73, 
     -2,   60,   86,   87,  -11, -119, -106,  -31,   56,  -34, 
     -2,   55,   78,   19,  -78,  -37,  -31,  -95,   -2,  -36, 
    -13,  -25,  111, -128,  -27,   60,  -78,  -80,   40,  -72, 
     47,   38,  -64,  -62,   99,   88,  124,   87,   15,   13, 
    -10,   32,  -58,   54,   75,   49,   31,   67, -102,  -95, 
    125,  -25,   61,  -51,  114,   84,  -55,  107, -109,  -60, 
    -57,   80,   12,  -99,   46,    1,    2,   98,  -89,   -5, 
    -84,   96,  126,  -63,   47,   20,  105,  -87,   60,   94, 
     -4,  102,  106,  103,  -25,   84,   83,   81,  -12, -122, 
    113,  -93,  -61, -113,  -75,  113,   66,   18,  -21,   78, 
    -19,   11,  -48,  -14,  -54,  -37,  -17,  -86,   33,   21, 
     63, -125,   -1,    9,  125,   52,  104,   20,   73,  -50, 
     94,  -92,    2,   37, -107,   13,   97,   -3,  -14,   14, 
    -41,  -13,  -57,   33,  -90,   49,  -48, -123,  -64,  -49, 
    -21,   11,   98,   10, -102,  -93,  111,   39,   57,  -91, 
   -115,   36,   -2,  -33,    0,   35,  -76,   98,   73, -106, 
     54,   11,  125,   42,  -83,  -45,  101,  116,    7,    9, 
     89,   92,   63,   36,  -36,   76,  -58,   74,   -9,   23, 
    -46,  -98,   85,  -86,  -51,   77,   34,  117, -102,   37, 
    -93, -106,    8,   34, -108,  -54,   22,  -70,   69,   19, 
    -20,  -25,  114,   40, -108,   -8,  -27,  -96,  123,   23, 
    -51,  -35,  -86, -103,  -37,  -71,  -61,    8,   32,  -14, 
    -68,  -16,  -87,   85,   94,  107,  -42,  -85,  123,  110, 
    126,  103,  -14,  -47,  -60,   12,   99,   31,  -75,   95, 
    -80,   34,  -87,   80,   58,   44,   86,  -88,  -41,   38, 
    -77,  114, -107,   89, -110,   42,   49,   -1,   -5,  -90, 
     84, -121,   72,  -57, -110,  -86,    5,  -33,   35,   49, 
   -123,  -32,   94, -125,   67,   73,   -6,  -15,   -2,  -49, 
      2,  -64, -111,  -50, -101,   -6, -106,  109,  120,  -12, 
    -71, -109,   25,  -99,  -36, -116,  -58, -117,    0,    6, 
     77,  -58, -117,  123,  125,   82,   83,  -97,   97,  126, 
     11, -121,   60,  -17,  116,  -35,   72,  105,  -19,  119, 
     44,   99,  -54,   72,   65,   72,  113,   13, -124, -115, 
     57,  -77,   89,  118,    1, -119,    5,  -89, -110,   42, 
    -24,  109,  -75,   40,  125,  -55,   19,  119,   17,   64, 
    -49,  -97,   69,   99,  -28,  -96,   69,   32,   63,  -94, 
    -59,  -58, -101,  100,  -65,  -39,   30,   98,  -19, -102, 
    -73,  -61,    7,   84,   53,    8,  -68,  103,   38,  117, 
    113,   21,  117,   61,  -69,   14,  -63,  112, -100,  -68, 
    126,  -92, -128,   79,  -51,  101,  -10, -121,   26,   93, 
     46,   67,  122,   66,   53,  -52,  -63, -126,  -14,  -31, 
    102,  -81,  -34, -127,   22,  -85, -123,  123,   24, -110, 
    -64,  -74,  102,  107,  -82,   64, -121, -115,    8,    8, 
     46,  -46,  -65,  -70, -109,  125,  -21,  109, -109,  -21, 
     22,   79, -119,   -4,  -48,   28,  -22,   62, -100,  -62, 
    -94,  -34,   39,  -91,   48,   78,   71,  -79, -126,  -75, 
    -70,   35, -112,   26, -102,   22,  -69,   79,  -95,  -48, 
    -29,  -99,   33,  -55,   73,   52,  -63,  127,   41,   80, 
     -8,   -5,   21,   43,   73,   32,   19,  -91,   67,  -70, 
    117,  -76,   54,   66,  122, -116,  -75,  113,  -88, -115, 
    -50, -117,  -25,  -16,   11,  103,   93,   48,   39,   64, 
     11,   56, -112,   61,   43,   81,  -96,  -63,   70,  -55, 
   -103,  115,   24,   99,  100,   11,   35, -127,    8,  -30, 
     20,   17,  -20,   55,  -40,   59,  -52,   65,  125,  -57, 
    123,   -8,  -55,   79,   93,  -94, -101,   41,  -94,   30, 
      4,   17,   66,  -13,   35, -104,  -69,   24,   12,   15, 
   -115, -128,  -74,  -77,  112,  108,  -17,  -42,   91,  110, 
     97,  -46,   52,   62, -102,  -19,   87,   64,   29, -118, 
    -57,  -47, -126,  -42,   54,   84,   78,   46,  -75,   -1, 
   -109,   81,   58,  101,   70,   74,  -43,  -63,   99,   26, 
    -79,    8,  -62,   40,  -52,  -84,  -74,  104,  117,   49, 
    105,   77, -119,  112,   -7,  111,  108,  -83,   82,   -5, 
    -56,   89,  -55,  -35,    7,  -89,  125,  -82, -111,  -48, 
    108,   94,  -59,   38,   86,  -95,  -71,  -39,   85,   26, 
    -80, -117,   56,   73,   94, -108,  -94,   52,  -35,   21, 
    -26,  -41,  109,  -65,  -97,   75,  -18,   95,   17,  -72, 
     29,   48,   66,   -5, -111,  -33,  -41,   22,  115,   93, 
    -81,   91,    0,  103,   64,   87,  -65,  -42,  -76,  126, 
   -128,  -90,  -62, -101,   27,  -57,   76,  -12,   10,    9, 
    -68,   63,  -15,  121,   30,   72,   11,   77,   -4,   95, 
    115,  -48,   -4, -126,   92,  -35,   59,   78,   35,  -52, 
    103,  -91,   79,  118,  -98,   30,   75,   10,    8,   47, 
    -27, -110,   53,   28, -124,   66,   54,  -98,   43, -122, 
    125,   83,   49,  -55,  117,  -24,  -67,    6,  -32,    6, 
      3,   15,  -13,   -1,   64,  -97,   50,   56,  117,   32, 
     11,   85,  -27,   60,   52,   38,   79,   37,  -60,   84, 
    -21,  -93,   19,  -54,   37,  -30,   81,  -29,   27,   -8, 
    -25,   88,  -41,   55, -111,  -25,   76,   55,   55,  -62, 
     17,  -95, -114,  -67,  -34,  -68,  113,   54,  -54,  -72, 
     -1,  -61,   65,  -67,  116,  -99,  -58,  -79,  -56,  -50, 
    110,  -52,    9,   27,   22,  -36,  119,  -78,  106,   87, 
     99, -108, -106,   37,  -57,  -64,  -56,   42,   10,   12, 
    108, -107,   31,   65,   38,  -22,   90,  -93, -115,  -48, 
     18,   -1,  -83, -102,   -4,   40,   58, -106,  -33,  -69, 
   -109,   24,  112, -123,  125,   68,  -16,  -75, -101,  -98, 
   -122,  -58,  -82,   82,   93,   41, -111,   67,  124,  -76, 
    -14,  -43,  104,  -50,  -47,  122,  122,   86,  -71,   -3, 
      0,   87,  -65, -112,   21,  109,   61, -106,   64,  -12, 
     78,   48,  -50,  -11,    8, -120,  -17,  -47,  123,  -32, 
   -110,  -87,  109,   89,    0, -109,  -47, -125,   58,  126, 
     11,  -88,   18,  -32,  -27,  -40,   10,   37,   79,  -78, 
    -17,  -42,  -38,   -8,   52, -117,  -15,  -48,   15, -111, 
    -36,  -39,   85,   90,  117,  -12,   20,  -89,  -90,  -49, 
    -12,  119,  -87,   49,   77,  -82,   -2,    8,    8, -124, 
     43,   50,   54,  -78,   54,   13,  113,   94,   13,   15, 
    -12,  -63,  -84,   70,  123,  -98, -126,   63,  -37,   98, 
     72,  117,   96,   26,   11,   47,  -22,   23,    2,   56, 
    -59,   98,   73,  -83,   75,  -31,   92, -119,   59,   70, 
     83,  -15,  -42,  -69,  -30,   63,  -66,   77,   14,  -48, 
   -115,   27,  -81, -115,   55,   62,  -87,   57,   32,  118, 
    -23, -128,   -5, -103,   32,  -70,  104,  -70,   65, -125, 
     76,   28,  -68,   -5,  -19,  -44,  119,  -36,  -43,   64, 
   -113,   64,   99,   42,  -46,   46,   48,  -69,   -6,  -23, 
     39,   33,  -86,   -9,   97,   -2,   41,  -13,  -60, -106, 
    -32,   18,   90,  -73, -108,  118,  114,  102,   98,   53, 
    120,   78,  126,   39, -109,  -24,  -86,  114,    3,  106, 
    119,  -43,   55,  112,   62,  -73,  -81,  107,  -36,  -18, 
   -105,  -52,   47,   80,   31,  -17,   84,   -6,    3,    7, 
   -100,   98,   95,   80,   82,   29,   87,  -84,   47,  111, 
    104,   34, -104, -105, -120,  -69,  -99,  -41,  -98,  -73, 
    -80,   69,   26,  -75,   39,   83,   82,  -99,  115,   31, 
    -93,   83,   29,  122,   67,   29, -123,  -70,  -26,  -49, 
     88,   63,   23,  -68,  -44,  -59,   82,   91,  -66,  111, 
    -28,  -69,   30, -114, -125,  -89,  -64,   53,  -84, -103, 
    106,  125,  -65,   95,  -35, -105,  -38, -115, -115, -107, 
    120,  -88,   30,   -8,  -56,   15,  -92,   -8,  -50,  -88, 
   -102, -106,   59,   78,  -98,   98,   12,   -3,  -14,   12, 
    -29,  -71,  -79,  -85,   40,   66,  -45,  -49,  -34,  121, 
    -30,   72,   69, -112,  121,  -77,   52,  -13, -128,  -55, 
     51,   -7,   40,  102,   90,   73,  -88,   90,  -20,   13, 
    -76,  -15,  -79,  -40,  -64,   67,   22,   87,    7,    3, 
      6,  -71,   -3,  106, -122,  -34,   96, -120,   18,   65, 
    -32,  -50,  -71,  -90,   98,  -11,   -7, -125,  -77,   12, 
     91,   47,   -2,   -4,  -51,  -53,   14,  -36,  -62,  -13, 
     68,  -12,   10,   36,   86, -110,  114,  -22,  -51, -112, 
     26,  -47,   59,  -96, -104,    8,   62,   93,  -48,  -43, 
     55,   17, -111,  -68,  -54,   69,  -17,  109,   20,   13, 
     99,  112,  -82,   17,  -93, -110,  101,   90,   64,   13, 
    -75,  -31,    4,  122,   10,  -41,    9,  118,  -75,  -76, 
   -104,   22,  -82,    1,  -57,   11,   14,  -27,  -49, -109, 
     74,  112,   49,   38,   47,  -87, -121,  -36,  -95,   88, 
     42,  -97,   19, -108, -120,   20,  -60,   11,   66,   73, 
    -66,   19,    8,   30, -114,  116,   51,  116,  -61,  -14, 
     38,   23,   39, -101,  100,  108,  -65,  -43,   15,    6, 
   -125,   38,  104,  -10,  -35,  -63,   95,  120,  -30,  -44, 
    125,  -40,   82, -110,  -40,  -58,   80,    2,   15,   80, 
    -32, -124,  -85,  -47,   36,   40,   52, -102,   86,  -83, 
     21,   97, -125,   90,   48,  109,   12, -128,   64,  125, 
    -36,  -54,  -15,  124,  105,   74,  -64,  -27,  108,   66, 
   -110,   -9,   95,  -75,   21, -104,  -71,  -83,  -38,    9, 
    -21,   74,   46,   77,   24, -115,  -68,   89, -105,  -23, 
    -29,   -4,   42, -124,  -42, -116,   -6,   81,  120,   84, 
     89,  -50,  -12,  -64,   53, -100,   31,   68,   93,  -61, 
   -115,   16,  119,  -62,  116,  117,  -68,   88,   67,   20, 
    120,   19,    0,  -52,   67, -100,  101,   96,   -1,  -64, 
    -72,  -22, -112,   61,  110,    3,   93,   81,  126,  -82, 
   -118,    2, -123,    8,  -15,   46,  -99,  -80,   11,   14, 
     -3,  -10,  -91,   24,   79,  -59,  -96,  -87,  -44,   81, 
    109,  -81,   57, -128, -120,   39,   54,   25,  -51,  -20, 
    -21,  -83,  -75,    2,   -6,   72,   82,  -90,   99,  -42, 
     11,   17,   34,   86,   22,   15, -119,  -64,  -71,   66, 
     93,  -74,   63,   53,  -78,  -19,  -69,   35, -122,   89, 
    126, -124,   31,   26,   89,   92,   36,   40, -110,   65, 
    125,  -64,  -89,   48,  -22, -116,  -59,   15,  100, -107, 
      5,    1,   55,  -24,  107,  108,  -37,   10,  -97,  -53, 
   -107,   27,  104,   51,  -47,  -52,  -20,  -90,   60,    1, 
    -87,   25,  -93,   69,   49,   70, -114,  -15,  -89,   50, 
   -102,   27,   -3,  124, -102,   62,  -22,  107,  108,  -82, 
    -84,  -75, -101,  -72, -126,   15,  -71, -101,  -25,  120, 
    120,   43, -114,   69, -115,   62,   32,  -21,   11,    3, 
    -73, -114,  -30,   42,   25,   77,  -66,   17,  -76,   74, 
     29,  -79,   92,  122,  -48, -120,  -59,   50, -113,   96, 
    -63,  108,   18,   -4,   58,  -35,  -12, -126,  -18,  -73, 
     70,  -90,  -20,   61,  -11, -102,  -48,   10,  -36,  -72, 
    -64,   32,  -89,  -20,   37,  -77,  109,  -30,   41,  -78, 
     11,  -13,  -12,   25,   65,  -49,  -91,   -8, -114,  -23, 
     16,   66,  -53,  -90,   61,   85, -119,   69, -101,   76, 
     42, -116,    7,    7,  -63,   54, -128,  -10,  -87,   30, 
    -91,  -88,  -26,   43,  -10,   23,   62,   -6,  -58,  -80, 
     21,   76,    1,   35,   12,   53,  -94,  -17,   88,    0, 
    -14,  -84,  -30,  -28, -127,   22,   35,  104,  -28,  -36, 
    -68, -107,   50,   45,  -42,  -32,   63,   -2,   63,  -43, 
   -106,   27,   64, -125,   55,  -12,   63,  -86,   10,   11, 
     25,  -91,   76,  -64,   59,   24,   37,  100, -123,   89, 
    -54,   -3,  -34,  -98,  -56,   87, -107,  -21,   72,  101, 
    126,  -72,   13,   83,  -57,  101,   43,   76,  -98,   93, 
   -116,   10, -124,   12,   34,   33,  109, -127,  -20,   10, 
    -97,  -31,  -86,  -15,   71, -110,   95,   63,  -38,   35, 
   -119,  -26,   49,   -4,   34,  110,   99,  -54,   85,  -62, 
     96,  -89,    0,  -70,   81,   12,  -20,  103,  -79,  118, 
    -50,   33,   41,  -39,   -5,   80,   47,  -56,  -18,   -3, 
     94,   97,  122,   23, -110,   -7,  -50, -123,  -54, -117, 
     44,  -16,  -67,  -32,  104,   76,   56,  125,   34,   42, 
     61,   80,  -62,  -65,  -36,   25,   55,  -78,  -49, -103, 
    110,  -87,  -41,  124, -110, -110,  -39,    6,    9,  -79, 
    -74,  127,   41,  108,  -19,   94,  -67,  -40,   13,    7, 
     59,    2,   75,  102,  -63,   -3,  111,  120,  -45,  -81, 
     94,   92,  -42,   91,   -1,   76,   74,  -19,   60,  123, 
    -54,    8,  -34,  126,  -60,  -49,   40,  124,   -9,  118, 
     54,   20,  -80, -121,   18,   16,  -61,  -13, -102,  -50, 
     74,  -33,   20,  105,   31,   43, -115,  -86,   26,  -63, 
    -11,  -79,   10,  -93,   -6,   97,  116,  -78,  -89, -113, 
     14,   62,  -69,  -22,   -8,   80,  -54,  -89,  -65,  -71, 
     21,  -12,   18,  -38,   41,   25,   65,   49,   57,  109, 
    122,  -89,   58,   -1,  -63, -102,  -61,    0,  -78,  -85, 
    -95,  -15,   -7,   71,   60, -111, -115,   -9,  -84, -125, 
    -81,  103, -103,  -63,  -92,   56,  -43,  -61,   52, -123, 
    -69,  110,  -31,   53,   69,  -66,  -25,    5,  -17,   50, 
    -10,   83,   78,   -6,  -79,  -85,  110,  -31,   10,   12, 
    -18,   -5, -120,   21,  -36,   14,  120, -112,   81,  -64, 
    -17,   62,  -53, -124,  -56,    4,   77,   69,  115,   -4, 
     56,  -49,  -72,   66,  -26,    1,   46, -127,   10,  -77, 
    120,   59,  -54,  103,   69,  -37, -104,  -78,    5,  124, 
    -44,  103,  107,  118,   34, -120,  -90,  -84, -117,  -20, 
     94, -105,   85,  -80,  111,   16,  -95,   94,  103,  -32, 
    -55,  -34,  -64,    9,  119,   32,  -36,  -47, -124, -123, 
    -60, -110, -106,   17,  -96,   67,  119,   81,  -12,  -59, 
     53,   12,  -97,  -18,   -2,  -84, -108,   85,  -72,  106, 
     85,  -30,   98,   59,   51,   19,   45,  125,   70,   15, 
     88,   96,   45,  108,  -49,   21, -123,  -65, -126,  -72, 
     42,  -25, -123,   -3,   48,   24,  -21, -100,  -98,  -87, 
     98,  124,  -17,  -99, -115,  -94,   73,  -13,   11,    8, 
    123,  -83,  -51,   26,  -73,  -96,  -73,  -53,   19,    0, 
     -5, -108,  -64,  -86,  -78,   22,    6,   47,  -43,   87, 
      6,  -92,  -41,  -19,   47,   43,    2,  -23,  124,   63, 
   -107, -123,  114,  -62, -103, -116,  -37,  -56, -121, -116, 
     66,   32, -102,  -67,   45,  -90,  -12,  -81,   28,   74, 
    114,  -75,   68,  -34,   79,   20,   11,  -94,  122,  -22, 
     66, -112,  -74,  -33,   36,  104,  118, -115,   17,  122, 
    118,  -80,    9,   53,   24,   12,  -22,  114, -125,   33, 
    104, -128,  124, -113,  -48,  -18,    2,   74,  124,   27, 
    -85,  125,   20,  127,  -63,   62, -119,  -75,   27,  -10, 
    -48,   79,  -69, -115,   97,   88,   44,   88,  110,  -88, 
   -104,  -61,  -29,  -21,  -86,  -67,   33,  110,   41,  -26, 
    121,  -81,   79,  121,  105,  -94,  -19,   -6,    7,   12, 
     64,  -98, -110,  -33, -111,  126,   66,  -95, -114,  122, 
     51,  -33,  105,  -19, -123,  -95,  -76,   22,  -80,  -11, 
     -6,   64,   -5,  116,   29,  -74,  -70, -110,  114,  105, 
     74,  -88,  -99,   94,  -52,  -62,   45,  -40,  -93,   41, 
    -10,   73,  -81,  -82,   48,   -8,   70,  -69,   83,  114, 
    -11,   26,  -81,  -79,   -6, -125,  -50,   13,  127,  -25, 
   -119,  -26, -105,  126,  -21,   13,   -7, -112,  -56,  -11, 
    126,    6,   28,  -98,   90,  -81,   36,   60,   29,   82, 
     61,  -86,  103,  119,  127, -112,  109,  -12,   24,   86, 
     47,   57,  104,  -58,  118,   91,  -31, -125, -113,  -31, 
   -101,   45,  -56,   81,  -72,   80,  -82,  120,  125,   16, 
      2,  124,   44, -107,  127,  -94,  -94,   54,   78,  -33, 
    -76,  103,   68,   32,   73,   99,  -32,   88,    8,    6, 
      7,   77,  -35,  -41,  124,   34, -125,   55,   33,  -93, 
    116,  -52,  -17,   82,  -41,   11,  -75,   53,   81,   -6, 
   -110,   92,   91,   27,   52,   52,   99,   21,  -51, -115, 
    -91,   38,  -40,  108,  -58,   75, -112, -111,   52,   44, 
     43,  -58,   63,  -55,  -38,  -20,  -10,  -27, -128,  -58, 
    -62,   53,   52, -125,  -60,   71,  119,   12,  -18,   51, 
     52,   18,  -29,    3,  124,  -42, -114,  -30,   -3,  -75, 
   -125,    7,   70,  122,   24,   94,  -68,   98,   66,   -5, 
     89,  -18,   47,   62,   42,  107,  -89,  -59, -122,   66, 
     35,   22,   15,   -1,  -87,    7,  105,   34,  109,  -12, 
    -69,  -88,   40,  -98,  -24,   87,   54,  -28, -116,  -52, 
    113,   36,  -72,   69,  -49,  110,  109,   46,  -67,  109, 
    -39,  109,   56,   20,   83,  108,  -80,   11,    8,    5, 
   -100,  -41,  -63, -127,  -36,  -52, -118,  -11,  -47,  -78, 
     67,   66,   61,   56,   21,   99,  -38,   28,  -11,  -29, 
    -68,   22,  -24,   36,  103, -120,   -5,  113,  -81,  -26, 
      0,  -59,   82,  -26,    8,   87,   85,  102,  -93,  -20, 
     33,   33,  -39,  -36,   93,   16,  -25,  -32, -119,  -96, 
    -71,  -95,   94, -104,   42,    1,  -25,  -57,   -3,   38, 
     94,  113, -102,   74,  -57,  118, -120,   68,   77,   70, 
    -84,  -44,   95, -120,   70,  -78, -119, -125,  -89,   84, 
     18,   83,  -78, -126,   90,  -52,   24, -102,  -16,   44, 
     82,  -93,  117, -125,   93,   19,   51,  -31,   56,   94, 
    123,   68,   29,   69,  -62,   63, -127,  -36,  121,  106, 
    -52,   87,  -81, -116,  -40, -100,  104, -119,   42, -119, 
    -70,   12,  -14,   -1,  -84,  -12,  -61,  -74,    1,    0, 
     17,  -65, -105,   55,  110,  -41, -127,  -97, -125,  113, 
    -26, -100,  -49, -127, -105,  -92,   34,    9,   64,  -88, 
    -41,  100,  126,  -63,  -44,   84,  -68,  -99,   66,  -52, 
    -47,  -89,   11,  125,   90,   -9,   22,   34,  -41,   -1, 
     68, -117, -122,  -15,   40,  106,    2,  -14, -119,  -33, 
   -101,    0, -104,  -60,  114,  -93,  -15,  -71,   92,   85, 
     82,  -19,  114,  -79,   29,  -78,  122,   93, -114,  -66, 
     -7,  -72,  -69,   64,   19,   66,   79,  -86,   40,  -49, 
      5,   56,   47,  106,  -27,   66,  -48,    9,   65,   69, 
     68,  -11,  109,  -78,  -21,  -10,   64,  116,  -79,   65, 
     78,   67,   32,   33,  -31,  -86,   68,  103,  -69,  -40, 
     66, -110, -115,   42,  -74,  -67,   54,  116,  -49,   75, 
    -69,   18,   44,   84,    9,  -79,  115,  -51,    3,    3, 
    -74,  121,  -51,   72, -123, -109,  -82,  -33,  -47,   55, 
    -27, -114, -121, -109,   26,  -50,  -25,  -47,    2,  -13, 
    -88,  -62,   88,   54,  -52,   74,  -97, -125,   67, -113, 
   -104,    2,   65,  -33, -124,  103,   95,  101,   25,   -7, 
    115, -118,   69,   99,   46,   43,  -92,   60,  122,  127, 
    -62,   87, -111,  -59,   16,  -54,  -36,  -80,  -90,  -64, 
   -111, -109,  -67,   -2,   10,   75,  -22,   54,  -26,  -17, 
     27,   14,  -32,   57,   82,  -18,  114,  -79,   35, -116, 
     40,  -98,  -19,   56,  -60,  -83,  -38,  -25,   21,   94, 
   -105,    0, -105,   49,  -45,  -24,  -54, -108,  121,   79, 
     82, -118,  -84,   55,  -46,   27, -123,  -56, -120,  126, 
   -114,  -42,  -89,    7,   -4,   46,  119,  -47,  -81,  -93, 
     46,   43,  -22,  -37, -116,  -62,  -46,  -40,    8,   12, 
    -89,   72,  -37, -115,  -61, -116,    0,    8,   86, -118, 
    -87,  -23,  -34,   50,  -79, -111,  103,  -47,  -28, -118, 
   -121,   23,  -33,  -17,   23,  -23,  -88,  -98,  -79,  -26, 
     11,   31,  -19,  -70,  -70,   81,   89,   38,   34,  -39, 
     60,  -54,   14,   75,   10,  -72,   -3,   21,  -90,  -72, 
     67,   47,   90,   91,  -32, -125, -107,  -63,   35,   28, 
    105,   42,   -3,   16,  -62,   62,   38,   45,  102,   27, 
    -15,  102,  -80,   33,  -18,   -5,   12, -128,   67,  106, 
     48,  125,  -54,   24,   31, -121,  -22,  -66,  -35,   -3, 
     53, -108,  -15,  -68,  -59,   63,  -97,  106,   87,  122, 
    -30, -124,   35, -122,   42,   39, -127,   82,  -38,  -95, 
     59,  105,  126,  -73,  -78,  -98,  -49,  -77,  -77,  121, 
    103,   52,   23,   95,   67,  -77,   28, -125,    3,    8, 
   -123, -113,  -60,  121,  114,   17,   34,  117,   -1,  -89, 
    108,   53,  -98,  -23,    8,   -3,   52,   24,   97,   -9, 
    -11, -117,  -86,   -3,    0,  -44,   85,   41,  -71,  -75, 
     80,   29,  -24,  -59,    5,   17, -107,  -32,   15,  -95, 
    -96,   82,  -69,   83,   35,  -62,   69,  -23, -121,  -33, 
    -50,  107,  103,  -52,   31,  -14,   40,   76,   31,   53, 
     83,  -84,   21,  -44,  -72,  115, -100,  102,   68,  -54, 
    106,   68,  -99,  -84,  -65,   18, -126,  -51,  -82,   17, 
    -29,   74,   14,   39,  -63,   21,   62,  -87,  -57,   30, 
   -101,  -18,  -92,   64,  -64, -108,   46,  -15, -125, -113, 
     55,  -88,  -86,  -10,   44,   12,  112, -116,  115,  -31, 
    -69,   15, -128,  -78,   25,   66,  -68,   61,  126,  -68, 
     21,  -94,  -65,  110,   99,   74,  -52,  -11,   14,    7, 
    -80,  -92,   39,   81,   72,   78, -121,  -53,  -59,  -41, 
    -82,  -41,  -29,  121, -105,  110,  -26,  -42,   14,   29, 
     88,  -63,   75,   49, -125,  -53,   73,  -94,  -81, -113, 
    -23,  -65,   27,  -68,  -54,  -99,  -68,  -26,  -26,   64, 
    -72,   12,  -21, -122,  -97,  -24,   95,  -41,  110,   -6, 
    113, -115,   68,   81,  -97,   34,  -31,   30,   12,   31, 
    -30,   -7,  -98,  -65,  -66,  -15,  -38,  101,  126,   85, 
    127,  -60,   62,   68,  -29,  -57,  103,  -11,   15,   67, 
    -87,  -59, -100,   99,  -71,    4,   75,  -50,  -49,  127, 
    102, -103,  -35,  -51,  -39,  -17, -113,   89,   14, -127, 
      5,   51, -117,  -82,   82, -107,   77,  113,  -78,   54, 
    -31,   13, -114,   80,   71,  121,   48,  115, -122, -116, 
     70,    7,   14,  -23,   23,  -94,  -48,  -88,    9,    1, 
     30,  -56,  -54,   23,   67,   86,  -22,   24,  -31,   92, 
     -6,   68,   13, -117,   22,  -76,   42,  -89,   33,   52, 
   -119,  -75,   61,  -52,  -68,  -26,    9,   15,  -67,   65, 
    -99,   38,  -61,   18,   69, -101,  -34,   21,   -1,  -27, 
     87,   97,  -76,  -73,  -55,   21,   57,    7,   -2,  -60, 
      4,  -32, -118,  -96,  -83,  -25,   40,  104,   43,  -82, 
    -41,   18,  -54,  -70,  -77,   56,  -19,   85, -108,   66, 
   -120,   20,  103,   87,   91,   39,   79,    4,  -18,   98, 
    122,  -88,   80,   15,  -61,  -90, -114,  112,   11,   72, 
    -12,   21,   86,  116,    5,  -29,  -88,   17,   59,  -33, 
    -99,   54,  126,  -67,  -54,   23,  101,   44,  -42,  -81, 
     46,  -34,   86,   44,  126,   88,  106,   30,  -40,  127, 
     28,   94,  -35,  -35,  115,  -65,   72,  -73,    6,   10, 
    -89,  -49,   50,   72,  -39,   -8,   55,  120,   75,   93, 
   -107,  110,  -15, -111,   74,   40,    5,   85,  -71,   96, 
   -126,   44,   18, -127,   94,  -97,  100,   73, -119,   79, 
    126,   61,  -88,  -66, -119,  -47, -111,  -35,  102,   83, 
   -124,   84,  -57, -102,   47, -108,   14,  114,   95,  -99, 
    -24,  -59, -123, -113,  -89, -119,  -18,  -15,   99,  109, 
    -63,  -61,  -48,   65,  -73,   69,  -36,   40,  -99, -124, 
     15,  127, -118,  -88,  -95, -117,  -33,   -1,   90,  -28, 
      1,  -56,   45,  -92,  -40,  -65, -109,   79,    6,  108, 
    -89, -128,  -25,   43,    5,   88,   76,   -6,   98,  -91, 
    -10,    4,  -22,  -44,  -45,  -15,   93, -104,   -6,  -22, 
    -25,   86,  102,  109,  -62,   86,  117,  -42, -116,  -86, 
     30,  -88,  104,  -36,  -11,  -97,  -41,   90,    0,    9, 
     83,  -95, -109,  119,  -80,   43,  -41,  -58,   49,   25, 
    119,  109,  108,  -97,    4,   38,  -35,   50,   81,  -21, 
     76,  115,  -82,   61,  -33,  -39,  -32,   55,   -3,   32, 
    -25,   81,  -24,  116,  110,  -12,   23,   92,   16,  -63, 
     87,  103,   79,  -96,  -95, -104,   84, -119,  -72, -111, 
    103,   21, -118, -127,   45,  -61,   66,  -50,  -93,   11, 
     47, -127,  -35,   35,   87,  117,  125, -110,  -39,   62, 
    -12,  120,    6,  -39,  122, -102,   62,   24,  -50,   48, 
   -117,  -54,  -83,  110,   -2,  -83,   20,  -46,  -53,   19, 
     52,   50,   37,   86,   56, -124,  -38,   -4,  -72,  107, 
    -83,  -87,   -5, -123,  119,  -56,  -16,  117,   -5,   -9, 
    -23,  -79, -116,   54,   28,   12,   96,  -50,  -38,    2, 
    -79,    1, -116,  -58, -104,  118,  113,   12,    7,   13, 
     25, -107,   76,  118,  -97,  126,  -32, -117,  -88,   72, 
   -111,   14,   30,  -90,  -12,   43,  -84,    8,  104,  -68, 
     -8,  -21,   44,  -17,  -93,  -34,   62,  -71,    0,   82, 
     -7,   -2, -106,   41,  108,  124,   86,   -4,  123,  122, 
   -101,   42,  -73,   52,  -27,  -91,   -4,    4,   85,  123, 
    -49,   80,  -26,   37,  116,   54,  112, -111,  -47,   -8, 
     93,  -16,    5,   40,   40,   64,  -57, -109, -103, -105, 
    127,  -18,  -63,   53,   37,   66,  -74,   71,  -37,   23, 
     14,  123,   75,   97,   28,   71,  -63,   45,  -20,   -7, 
      8,   11,   -1,  125,    5,   57,  -58,  -16,   20, -108, 
    -33,  -24,   36,   63,   17,  127, -109,   15,    8,   36, 
    -55,  -68,  -49,   33, -106,  -56,   17,  -21,   76,   45, 
     15,   44, -101,  -55,   95, -112,   47, -119,    6,   13, 
     11,   87,  -95, -123,  -94,  -61, -124,   34,  -71,  115, 
     84,  -44,   -2,   76, -110, -123,  103,   92,   62,  -88, 
     76, -115,  -48,   67,   67,   10,  -11,  -61,  -67,  111, 
      9,  126,  100,  -77,   87,    7,   49,  -43,   18,   52, 
     79,   71,   17,  -17,  -77,   30,   77,  -65,  119,  -10, 
     27,   21,   -7,  -91,   40,   87,  -74,  -89,   56,  -84, 
    -26,   67,  -99, -116,  -41, -128,  121,    6,   10,  -54, 
    -78,  -50,   14,   99,  -72,   13,   30, -118,   -7,  -25, 
    124,  109,   31,  -52, -117,  -50,   15,  126,  -82,  119, 
    -95,  -27,  -29,   94,   31, -108,   29, -105,  126,   26, 
    100,   -4,   93,    9,  -83,  -98,  -63,  -58,  121,  -23, 
   -115,   21,   48, -103,  -61,   99,   58,   96,  124,  -47, 
    -30,   82,  -88,    4,  -22,   23, -124,  -82,    3,    0, 
    -33,  -38,  119,  -61,   11,   -5,  -28,  -48,  -92,  -78, 
     -5, -109,    3,   97,   74,   83,  127,  115,   63,  -79, 
    105,  104,   10,   17,  -60,  -93,   53,  -57,  -57,  -14, 
     -2,    1,   19,  -32,  123,  118,  -76,  -67,  107,  -46, 
    -40,  105,  -35,  -33,   80,  -29, -126,  114,  -54, -108, 
    -47,   28,  -53,   91,  -33, -116,  110,   88,   -6,  -59, 
    -34,  120,   11,    4, -109,  -61,  -88,  109,   79,  103, 
     -5,  123,  -42, -126,   85,   37,  111,  -77, -112,  -49, 
     29,   95,   40,  -10,  -99,  -62,   23, -102,   30,  -68, 
    115,  105,  -62,   87,  -55,  -80,  -41,   27,   55,    1, 
    -43,   17,   74,  -92,   22, -105,  -99,  -66,   86,  -23, 
     44,   65,  -16,  106,  124, -103,  -43,  -75,  108,   19, 
     75,  103,  -40,   12,  107,  -87,  -15,  -34,    8,    0, 
     94, -118,   61,  -45,   18,   36,   15,   63,  -21,    1, 
     -2, -100,   15,  -95,  -69,   78,    5,   93,  108,   76, 
   -107,  -48,  111,  -15,   95,    6,  -48, -123,   60,  102, 
   -118, -119,   87,   94, -128,  -60,   10,  -45,   58,   17, 
    121,   70,   95,  -26,  -16,  -58,  -11,  -93,   -4, -103, 
     90,  -97,   74,  -88,   -1,  -14,   65,  -82,  -22,    2, 
     97,   30,  -23,  -49,   89,  -40, -106,   -2,  -22, -118, 
     14,  -89,  126,  -26,  112,  -35, -121, -119,   23,    1, 
   -105,  -91, -106,  -58,   67,  116,  118,    2,  -73,   92, 
    -79,   58,   24,  -31,  -20,  -21,  -99,   77,  119, -104, 
    107,   32,    5, -105,   51,   57,   42, -101, -116,  -63, 
   -104,    0,   16,  -38,   25,  -40,   57,   11,   74,  -71, 
     -8,  105,   28,   67,   25, -124,   10,  115,    6,    8, 
     26,  -86,   67,  110, -107,  122,  -50, -106, -123,   54, 
    -73,   70,  -14,   55,  -98, -112,  -38,  -17,  -30,   70, 
    -12,  -81,   60,   44,   36,   54,   29,  -31,  -67,    0, 
    -57, -114,  120,   75,   44,   76,   55,  -23, -119,   85, 
    120,  -57,  -63,  -15, -102,   64,  122,   29,  -45,   33, 
     -8,   -5,  -20,  123,  -68,   -3,  -63,   44,  -38,  -48, 
    122,   42,   30,    9, -119, -107,  -35, -112,   98,  122, 
   -101,  -49,   -4,  103,   97, -103,   11,  -78,  -38,  -37, 
     -6, -120,   50,    5,  -87,  -73,  -82,   53,  -22,   59, 
     10,   40,  -68, -118, -106,  -32,   68,  -98,   14,   20, 
   -113,  -58,   60,   91,    9,   44,   79,   23,  -69,   37, 
     -8,   34,   71,   58,   72,   58,  -92,   -6,   76,   44, 
   -104,  124,  100,  -62,   -7,  -74,  103,  108,   13,   15, 
    119,  -80,   54,  101,  -92,   82, -105,   47,   67,   66, 
     35,   48,   11,   73,  -76,   81,  -13,  114,   85,  -37, 
    -51,   57,  -61,    7,  -96,  116,  -86,   71,  -55,    4, 
   -101,   81,  -47,   59,  -49,  -17,   12,   11,  -99, -120, 
    -11,  -13,  -69,  109,   75,  -87,   55,  -29,  -23, -122, 
     51,  -12,  105,  -76,   99,  -12,  119,   25,   70,  -43, 
    -11,    1,   38,   42,  -45, -115,  -47,   -4,  -86,  -33, 
     20,   79,   29,    1,   -6,  114,  -16, -104,  -55,    9, 
    -28,   77,  -73,  -37,   88,  -10,  111,   91,  -97, -121, 
     70,   -8,   34,  -70,   60,   35,   53,  127,  -75,   36, 
    -72,   37,  -13, -100,  116,   68,   89,  -40,   50,  113, 
     97,  -37, -101,  -97,   89,   41,  -46,   86,  -32,   84, 
    -46, -106,   34,   71, -120, -120,  -43,   85,    0,    6, 
    -14,   -1,  109,   53,   51, -121,  -79, -107,   80,   56, 
     74, -118,   -8,  114,  -58,   86, -112,  119,   16,   45, 
    -83,   -9,  -57,   30,   82,   92,   95,  -62,  -23,  -42, 
     -7,  -95,    1,   36,    1,  104,  -52,   40, -116,  -52, 
     87,   40,  110,   59, -122,  -28,   30,   71,  -43,   91, 
     73,  -46,  -49,   92,   54,   -8,   77,  -50,  -33,  -64, 
    111,  -65,  -53, -126,   90,   45,  -83,   21,  -74, -106, 
    -67,  -64,  -27,   65,  -40,  -36,    2,   74,   89,   76, 
    -96,  110,  -75,  -99,   62, -101,  -40,   -4, -116,   53, 
     65,  -37,   96,   40,  -34,   97,  117,  -79,  -89, -107, 
    -24,  -21,   -3,   73,  114,   27,  -64,  -57,  102,  -68, 
     49,   60,  104,   72, -116,  -25,  -14,  -53,   99,    1, 
   -121,   40,  -68,  106,  -77,   40,  -23,   24,    6,    8, 
     41,   63,   91,   62,    2,   63,  120,   78,   92,   81, 
    -88,   81,   93,  -16,  -89, -127,    6,    8,  -30,    6, 
   -111,  -33,  -75,   65, -121,  -58,   97,  -39,  -92,  127, 
    -49, -119,  106,  108,    7,  -90, -122,  124,  109,  114, 
    -27,  -44,  -64,   35, -107,   63,  -46,  -79,   92,   86, 
      7,   98,   25,  111, -113,   22,  -35,   70,   98,   82, 
    -57,  109,   -1,   13,  -94,  115,  -29,   61,   64,  -43, 
    -54,   31, -108,  -88,  -89,   73, -111,    2,  100,  112, 
    -59,   44,   89,   -7,  -77, -120, -115,   65,  -13,   67, 
    -82,  -85,   10,  -70,  -48,  109,   10,  -84,  -24,   25, 
    -24,   36,    6,  -19,  -96,   35,   85,  -37,   10,   16, 
    -45,   86,  120,  -33,  -49,  -31,   23,    3,   38,   88, 
      2,   20,   60,   -5,   38,   63,  -69,   63,    7,   15, 
     14,   84,   55,   65, -101,  116,   65,  -96,  -62,  -16, 
    -74,   66, -104,   -5,  -80,  -54,   98,   52,   -2,  -73, 
    -45,  -12,   67,   17,    5,   92,  -46,  -45,   56,   28, 
     70,   23,   76,    4,  -29,    2,   -1,   76,  -81,  116, 
    -27,  -94,   79,  111,   43,   -9,  -94,   66,   10,    8, 
     30,  125,   12,  -83,  -19, -109,    1,  -27,  -58,   79, 
    -65,  -99, -117,   -9, -101,   66,  -90,   66,  -86,   12, 
     35,   -6,  -73,    7, -116,  111,    3,  -31, -121,  -95, 
    -65,  118,   49,   44,   72,   28,   56,  -14,   39,  -83, 
    -70, -118,  -57,   88,  -33,  107,  -13,   38,   55,  -42, 
     22,   78,  -45, -121,   48,   57,   37,   27, -103,   83, 
   -104,   63,  120, -106,  -18, -100,    1,  -41,   92, -123, 
    112,  -51,  102,   92,  -56,  -26,  122,  -56,    3,    6, 
     78, -103,  -72,  -87,   -7,  117,   71,   78,  -45,   74, 
    101,  -29,   12,  115,   45, -128,   13,  -90,  -84,  119, 
   -111,  -92,  -44,   94, -126,  -98,   60,  -33, -107,  104, 
    -99,   65,  -93,   96,   11,  -76,  -52,   28,  -11,   95, 
     76,  -43,  -34,   43,   27, -107,  -40,   76,   71,   34, 
    -60, -108,   16,  -88,   74,  118,  -57,   40, -103,  -37, 
    102,  -93,  -34,  -89,  -17,    5, -122,    8, -124,  -45, 
     50, -123,   74, -109,  125,  -63,   -3,   -2,  111,   18, 
     82,  -26,  -65,  -58,   16,  -24,  -53,   46,  -20,  -47, 
     88,  114,   39,  -48,    9,   19,  -24,   96,  -96,   62, 
     90,  -14,  -10,  -42, -124,   93,  -70,   63,  -21,    5, 
    -21,  -22,  -24,  -51,   22,  -92,  -55,  -68,   79,  -98, 
    -87,  113,  -15,   59,   15,   71,   20, -100,    7,    7, 
    -47,  -20, -124,  -46,   56,  107,  -78,   10,   12,   59, 
     27,    3,   68,  -20,  -64,  -84,   65,  -56,  115,  125, 
    -50,  -34,  -74,  -31,  -37,  -48,   86,   97,   -8,   92, 
    -58, -107, -109,  -85,   60,  -54,  -16,   92, -115,  114, 
    -20,   78,  -57,   79,  113,   48, -110,   93,  -73,  -55, 
     70, -125,   63,    6,  -52,   -8, -113,  -56,   53,  118, 
    -83,  106,   26,   32,   92,   20,  -71,   51,   24,  -63, 
    -53,  110,  -46,   16,   38,   65,  107,  -50,   22,  -72, 
    -15,   63,  123,   37, -101,   46,  -95, -113, -124,  -69, 
    -30,  -36,   42,  -34,   -3,  -64,  -91,  -67,   51,  100, 
    -90,  -78,   38,  -43,   53,   25,  112,   50,   41,  -35, 
      5, -108,  102,  -63,   73,  -69,  -39,  110,  -17,  125, 
     52,   64, -105,  -18,  104,  -49,   37,   78,   10,    0, 
    -30,  -75, -109,   71,   85, -128, -114,    1,  -34,  122, 
    -91,  119,   22,  -55, -112,  -23,  -24,  -98,  -13,  -34, 
    109, -102,   21,  -15, -117,    1,   95,   87,   76,  -95, 
   -107,   50,   -1,  127,  -41, -104,   16,   70,   85,   96, 
    -90,  111,  -43,  -78,    0,   48,  -27,   77, -112,   37, 
    -34, -106,  -45,  -65,  -97,  100,  -10,  111,    6, -116, 
     41, -111,   45,   46,  -63,   26,  105,  -68,   15,    0, 
      2,  -50,    2,  108,  -79,  -88,  126,  -96,  -35, -121, 
    121,  -87, -107,  -82,  -38,  -60,   76,   50,   17, -112, 
     86, -120,  116,   -9,   37,  -53,   96,  -35,   66,  -51, 
     11, -123,   12,  -29,   41,  -58,   51,  111,   69,  -14, 
    -14,   45,  -37, -127,   14,   61,   56,  127, -110,  -12, 
     18,  -69,   71,   97,  -26,  -85,  -12,  -96,   11,   15, 
     89,  -30,  -70,  -82,  -20,   55,   83,  -40,   81,   33, 
     14,   -3, -102,  -40,  -17,    5,   66,   93,  -89,  -53, 
    -22,   64,   51,   72,  -48,   49,   53, -124,   19,   71, 
     21,   60,  -88,   18,  -42,   82,   26,   98,  -72,   -9, 
      3,  -44, -110, -102,   78,   32,  -20, -114,   41,   36, 
    -34,  125,  -53,  -81,  -85, -112,  -22,   14,   27,   90, 
     -7,   87, -101, -120,   37,  119,   22,   73,   13,   -5, 
   -111,  125,   67,  -95, -120,  -96, -123,  -99,   10,  115, 
    -70,  -84, -107,  111,  -82,  -39,  -78,  -22, -115,   17, 
     79,    6,   32,  103,  -33,   92,  -56,   39,   50,  108, 
     62, -100,   20,  -62,    7,  -96,  -88,  -25,  -72,  -24, 
   -127,   13,  -18,   11, -124,  121,   11,   86, -128,  -81, 
    -80,   82, -119,   95,   -2,   17,   24,   17,    4,    4, 
    -29, -110,   36,  -36,  123,   29,   72,  -23,  -86,   72, 
     95, -105, -118,  -76,  -67,   91,  100,  114,   89,  -66, 
     77,   54,   76,  -23, -127,   61,   11,  -21,  126,   -1, 
    100,  -52,  -33, -108,   57,   82,   -3,  -26,   -3, -108, 
     70, -102,  -14,   67,   91,  -66,   30,  -78,  -20,   50, 
     18,  -87,   82,  -41,   89,  -18,  -16,  122,  -63, -113, 
     73,  125,   76,  -16,  -32,   73,  -13, -105,  -45,  118, 
     31,  -71,   53,  -74,  -24, -125,   46, -123,   11,   41, 
    -45, -110,  -85,  -81,  -58,  -21,  -49,  121, -115,  -21, 
   -106, -109,  -79,  -29,   58,  -64,  -99, -118,  -53,   68, 
     51,   36,  -90,  112,   46,  115,  -70,  -15,   58,   97, 
    121,  -40,  -44,  106,  -97,  104,  -31,  -54,  -91,  -94, 
     15,  106,    2, -111,  -17, -118,   39,   84,    1,    1, 
     56,  -17,   87,   72, -118,  -47,  -23,  -86,  -33,   36, 
    -73,  -87,   99,  -41,  -92, -112,  100,  108,  -37,  -53, 
    -44, -127,   48,  -50,  127,   31,   58,  -55,   11,  -60, 
     43,   13,  -77,   49,  117,   60,  -62,  -12,   30,   50, 
    -48,  -76,  -35,  -75,  -65,   62,   -4,  -33,  115,   83, 
    -19,   70,   83,   46,  -88,  -16, -125,  -42,  -54,   -7, 
    -34,   40,  109,    0,  -76,  -93,  -57,   85,   71,  -15, 
   -123,  -28,    5,   56,  -27,  -34, -122,   37, -107,   44, 
     68,  -76,   77, -108,   28,  -64,   45,  -89, -121,   78, 
    -41,  113, -105, -104,   75,  -34,  -78,  -37, -123,  -19, 
     17,  -33,  -41, -106,  -10,   74,    6,  124,  -81,  -92, 
     38,   81,   78,   41,   53,   12,   37,   81,  121,  -52, 
      2,   31, -103, -119,   47,   44,  125, -128,    9,   13, 
    -27,   91,   23,  -40,  -54,   35,   26, -127,  120,  -27, 
     52,  -45,  103,   38,   10,   72,  -36,    7,  102,   -8, 
     67,   54,  109,  -31,   73, -102,  -99,   -4,  -69,  -67, 
   -120,    0,   33,   -8,   82,  -13,   24,   97,  -22,  116, 
    115,  116,   10,  -54,   16, -126,  -16,  -85,  122,  -36, 
    -39,  -52,   67,  -66,   64,   44,   29,   -4,  -38,   32, 
    -67,  110,   80,   29,  111,   28,  -70,   71,  120,   40, 
    -34,  -68,   47,  126,   44,  -96,  -39,   61,  119,  -24, 
     71,  -29,  116,  -26,   49,   59,  -13, -104,   79,    6, 
    -34,  -81,   59,  106,  -11,   96,    9,   29,   70,  -19, 
    -93,   81,  109,  -14,  -27,   93, -112,  111,  123,   48, 
     24, -104,  124,  117,   47,   95,  -59, -123,   -3,  -67, 
     22,   16,  -95,  -61,  -18, -118,  -16,   99,    9,   10, 
    -17,   -2,   79,  -77,   17,  -84,  -53,  105,   47,   78, 
    -83,   50,   75,   84,   80,  -23,    4,   77,  -72,  117, 
    -41,   51,  -86,  115,   26,  114, -115,  -91,  -72,  -67, 
     -1,   28,  -83, -112,   54,   38,   63, -125,   27,   -7, 
      1,   84,   38,   28, -121,  -78,   -5, -104,  -23,  -55, 
    -64,  -30,   -7, -111,   68, -122,   66,  -42,  -48, -109, 
    -57,    6,  -54,  -55,  119,  -68,   15, -125,  114,   15, 
     12,  101,   -3, -101,  -95,  -59,   70,   75,  -75,  -39, 
    -41,  -20, -105,  -91,  -38,  113,   27,  -95,   17,    5, 
    111,   45, -109,  -43,  -63,  -75,   70, -102, -110,  -94, 
     32,  -23,  -42,    6,   28,   57,  -45,    6,   -3,  -73, 
    -74,    5,  -59,  -52,  -12, -107,  -13,  105,  102,   30, 
    126,   25,   35,   74, -108,  -60,   27,   54,   13,   12, 
    119,   90,  -62,  -89,  -78,   51,   86,   71,  117,  -74, 
     39, -114,   54,  115,  -84, -126, -112, -117,  -68,   19, 
     95,   82, -126,   40,  -94,  -61,   68,  105,   16,  -89, 
    -45,  -51,  118, -125,  -49,  -30,  -42,   69,  -93,  -34, 
     64,  -83,   58,  104,  110,  124, -124,   38,   33,   94, 
    -84,    5,   62, -105,   21,   75,  -90,  111,   25,   94, 
    -40,   94, -128,   81,   72,  -10,  -64,   49,  124, -109, 
     -6,   20,  -21,  -60,  -81,  -35, -107,  119,   69,  -48, 
     97,  -26,   60,  -39,   57,   68,   47, -102,  -26,   39, 
   -117,   57,  -85,  -77,   18,  -26,  -93, -118,   13,   46, 
    -37,  118,   83,    2,   46,  -46,   -3, -123,  -29,  -68, 
    -26, -104,    7,   -4,  -28,   37, -118,  -78,  -57,   46, 
     26,  -62,   20, -109,  -62,   -2, -128,  -90,   14,    7, 
     46,  112,   43,   69,  -88,  -64,  -63,  -80,  -98,   -8, 
   -112,  -92,   96, -107,  -53,  120,   27, -126,  103,   56, 
    -42,   29,   -6,   24,   42,    5,   84, -104,  -61,  -88, 
    -38,  119, -102, -113,  -91,   88,  -17,  102,   93,   53, 
      8,  -51,  -44, -122,  -86,  -31,  101,   48,   90, -120, 
     10,   47,   83, -128,   63,    2,   70,   37, -103,  -39, 
    -45,    4,   36,  127,  -54,   34,  127,    8,   33,   12, 
    -72,   58,  -77,  -98,  -24,  -69,  -66, -109, -115,   -1, 
     25,  -48,  -86,  -18,   55,  111,  -96,   87,  -33, -116, 
    -55,   24,  -88,  -47,  -40,    9,   54,  -61,  -13,  -84, 
     53,  -54, -116, -106,   25,    2,    3, -102, -110,  -61, 
     -4,  -70,  -49,  -16, -128,  -50,  122,    1,  -43,  -16, 
    110,  -46,   28,  -83,   57,   41,  -81,  -19,   10,    6, 
     56,  -99,   37,  -72, -112,   33,  -80, -112,   93,  124, 
     30, -120,  105,   59,  -10, -127,  -62,   38,   20,   80, 
   -106,  -92,  107, -113,  -53,  -15,  127,   35,   96,    1, 
    -96, -117, -122,   50,  -25,  -18,  124,  -76,  -16,  -31, 
     46,  -72,   91,   -4, -116,   90,    3,   27,  -86,   78, 
     -4,  115, -101,   76,   78,   91,   13,   59,  114,  -42, 
    -93,   32, -113,  -30,   21,  -60,  115, -125,    9,   39, 
     83, -114,  -82,  -89,   66,   53,   29,  -18,  113,   85, 
    111,  -97,   43, -126, -100,  -65, -114,  -50,   26,  -28, 
      9,   91,   48,   31, -103,  -89,   30,  -86,  -62, -111, 
    -19,   80,   79,   45,   22,  -97,  -56,   76,  -44,  -49, 
    -74,  -55,   73,  112, -103, -108,   82,  -42,  -92,  127, 
     42,   67,   61,  -53,  -64,  -39,   55,  112,    8,    3, 
    -52,   47,  -30,   10,   92,   87, -100,   -5,  -24,   90, 
    106,  -42,   75,   14,  112,   26,   61,  -61,  116,  104, 
      7,    8,  117,  -79,    6,   60,    9,   35,  -31,  -42, 
    122,  -45, -119,  116,  -97,   42,  -12,  -91,  122,   17, 
   -104,  117, -106,  -38,  -88,  -68,   29,  -12,   16,   37, 
    -70,   77,   49,    0,   52, -123,   91,  -57,  -59,  -41, 
     14,  113,   62,  -57,  -16,  122,  -36, -118, -115,  -83, 
    -25,   57,  -48,  -74,   15,  -76,   68,  106, -122,   87, 
     10,  -44,  -36,   94, -104,   -2,  -99,   23,   54, -123, 
    -85,  -51,   56,  -38,   91,  111,   -6,   87,   81,    2, 
    -96,    8,   28,  -52, -118,   53, -112,   59, -104,  -78, 
    -27, -102,   34,  -26, -109,  114,  -76, -100,  -22,  -64, 
   -116, -116,  115,  -36,  -44,  -89,   10,   35,    0,   11, 
    -73,  105,  -92,   78,   79,   33,  -68,   10,  -50,   72, 
     28,   42,  113,   21,   81,  116, -107,   98,   -1,  112, 
     82,  -40,   88,  -11,  -42,  -36,   93,  113, -127,   60, 
    -41,   -6,  -59, -105,   18,   23,  -70, -112,   95,   77, 
   -126,  -78,   71,  108,   98,   33, -113, -105, -100,    5, 
    -17,   20,   13,  -75, -112,  -40, -118,  -90,   73,  -49, 
     -6,   17, -103,  -17,   50,  101,   98,   -5, -108,  114, 
    106,   22,  101,   82, -110,   14,  -15,   21,  -45,  101, 
     95,   52,   -4,   30,   84,  -78,   45,   77,   73,   17, 
     17,   91,  -84,   -6,  -35,   28,  -71,  -85,   12, -110, 
     21,   31,  -41,  125,   46,   -2,  117,  -86,   84,   74, 
     22,   -9, -106,  -58,  -96,   40,   93,   36,   38,  107, 
    -54,  -11,   45,  -84,  -49,   80,  -99, -103,    0,    0, 
   -121,  115,  117,  -18, -100, -102, -107, -111,  103,  -42, 
    -59,   23,   80,  101,   -7, -109,   81,  -56,   98,  101, 
    117,   76,  -59,   44,   20,   90, -100,  107,  -49,  126, 
    -19,   -4,   76,   56,  -20,   55,  -79, -123,   82,  -31, 
    -31,   43,  123,  -43,  121,  -57,   65,  116, -120, -105, 
   -102,  -51,   16,    7,  -13, -117,   63,   -4,   73,  -94, 
    108,  -29,   12,  -73,  -45,  120,  -77,   83,   15,   85, 
     30,  -58,   91,   65,  -82,  -37, -120,   53,   37,   64, 
    -68,   45,   61,  -77,  -17,  -76,   10,  -20,   37,   44, 
     16,   77,  107,  -32,   35,   74, -109,  -54,    1, -103, 
    -82,   36,  -81,   25,   77,  -80, -106, -126,  118,  -57, 
     93,  -48,  102,   34, -124,  111,   12,  106,  -60,   38, 
     64, -127,   40,  -59,  -58, -115,  -22, -115,   10,    7, 
     14,   97, -122,    9,  -65,  -79,   46,   16,  108,   33, 
     58, -107,  -95,   -5,   -2,   14,  -91,   90,   93,   67, 
    -40,   18,    6, -110,  -55,   97,  115,    1,   25,   87, 
    -95,    8,   18,    4, -114,   27,    5,  102,  119,   -7, 
    102,   16,  -50,  -74,  -87, -102,   -4, -119,  -38,  -53, 
    -38,   85,   -2, -120,  -17,   -8,   43,  121,  106,   86, 
    104, -128,  -34,   36,   69,  -38,  -65,  116,   57,   17, 
    -97,    3,  -66,  -88,   39,   68,   45, -124,  -41,   43, 
     90,   27,  125,  -70,  -18,   94,  117,   76, -121,  103, 
    -92,  -93, -112,  -31,   53,  -78,  -32,   58,   17,   42, 
     20, -118,   31,  -58,  -85,   64,   64,   86,  -26, -110, 
      8, -116,   93,  -95,   60, -120,   97,  110,   14,   36, 
     19, -128,   25,   -1,   72,   81,   30,   75,    6,    3, 
    123,   86,   76,  -89,  111,  -38,  102,   49,   15,    3, 
   -117, -101,    6,   67,   27,  -74,   15,  -40,   13, -112, 
     51,   25,    9,   30,  -63, -124,   71,  -87,   16, -121, 
     42,   -7,  -10,   17, -101,   67,    7,  -42,   37,  -46, 
   -115,  101,  -44,  119,   75,  -22,  -51,  -79,  -16,  -62, 
    -84, -101,   91,  -61,  -96, -104, -109,   72,   72,  -64, 
   -124,   -1,   74,    8,  122,  113,  -72,   52,   94,   84, 
     34,  124,  -78, -110,  121,   -1,   77,   24,  -86,  -22, 
    -43,   95,  -11,  103,   -1,  -70,   17,   71, -120,  101, 
      0,  111,  -14,   73,  -78,    2,   -1, -113,   91,   82, 
    -19,  -22, -108, -122,  118,  -93,   51,   10, -124,  100, 
    -23,  -70,  -73,  -59,  -96,  -51, -105, -105, -110, -126, 
   -104,  -15,   40, -115,  -46,   -2, -104,   62,    3,   12, 
     60,  117,   44,   50,  -77,   72,  -48,  -79,  -72,  113, 
    106,  104,  -60,  121, -115,   13,  102,  -91, -101,  -17, 
     93,  -94,  -69,    5,  121,  -14, -101,  -74,   54,   21, 
    -22,  101,   20,  118, -110,  -62,  -73,   27,  -72,  -46, 
    -62,   11,  117,  -70,  115,  125,   80,   79,   -3,  -59, 
   -126,   93,  -88,   -2,  -24,  -70,  -86,  119,  -58,    8, 
    -61,  -34,   64,   77, -103,   45, -104,   52,  -40,   87, 
     40,   31,    8,  -79,   29,  -13,   44,   33,   -8,  -93, 
     31,    8,  -59,  120,  -83,  -17,   23,   38,  115,  -13, 
    -54, -114,  119,  -15,  119,   83, -123,  113,  -74,   30, 
     79,   82,   22,  -80,   66,   58,  -36,  -84,   41,  -70, 
    125,   32, -125,   67,  -37,  -40,  -93,  -52,   66,   98, 
   -116,   63,   33,  -33, -118,  -89, -121, -113,    0,    5, 
     99,   25,   83,  103,  123,  -99,   40,  126,   40,  123, 
    -95,  -94,  -42,  -32,  -31,   80,   62,   21,  -61,  -19, 
     95, -122,  -82,   50,   64, -109,   52,   87,  104,   24, 
    111,    1,   25,  -67,   27,  -21,   78,   -2,  115,   86, 
    122,   -7,  -52,   49,   -4,   -6,  -15,    7,   99,  -58, 
     67,  -85,  103,  -86, -113,  -91,  -94,   65,  -82,   90, 
     17,    8,  -34,   -3,   77,  -93,  -30,   56, -120,  -21, 
    -38, -103,   73,  -66,  -30,  -66,  -25, -122,  108,   63, 
    -59, -123,   93,   94,   82,  -26,  -23,  111,  -67, -125, 
     47,    7,  123,  118, -110,  -25,  122,   97,  -35,  -90, 
     33,  124,   21,   32,   14,   98,   27,  -95, -114, -101, 
      9,  -48,  -38,  -24,   72,   92,   23,   81,  115,  104, 
     10,  -17,  -18,  -73,  -98,  121,   69, -106,    9,   15, 
     69, -116,   17,  -55,  -36,  -62,   65,  125,  -80,   51, 
    -22,   83,  127, -109,   27, -119,   60,    0,  -81,    5, 
    -27,  105,    1,   31,   38,  -63,  113,   43,  -82,  -30, 
   -102,  -56,   83,   66,   79,  -22,  -25,   88,   90,  -89, 
    -41,  -53,  -13,  -60, -119,   95,    0,   -2,  113,  -97, 
     17,   25,   -8,   74,   25,  -87,   12,  125,  -19,  -94, 
   -123,  -92,  125,  -96,   62,   33,  -44,  -10,  -18,  -71, 
    -48,  120,  -54,  -62,  -96,    8,  -36,   13,    1,  -31, 
     32, -109,   55,  -91,   98,  -31,  -52,   39,  -39,   68, 
     10,   -8, -125,  -76,   57,  -78,   62, -128, -104,    7, 
    -86,  -66,   28, -120,  -64,  111,  -22,   53,   49,  116, 
   -107,  -56, -128,   52,   22,  -64,  -35,    9, -113,   47, 
    -58,  110,  -65,   67,   94,  -23,   68, -107,    4,    7, 
   -110,   51,  -46,   62,  -75,  111,  -14,   43,  -55,  100, 
     65,  109,   52,   76,  -56,  -39,  -87, -124,   32, -105, 
    -35,   90,   10,   81,    5, -100,  -48,   27,   22,  -31, 
     94,   32,  -69, -108,   30,   17,   21,  -60, -106,   77, 
     52,  -82,  -61,  -49,   88,    5,   50,  -38,  -25,    7, 
    -29,  102,   44,   64,  -35,   72,  -44,   27, -112,   35, 
     40,   45,  -19,   17,   11,   64,   70,   16,  -79,   33, 
    -26,   45,   36,   41,  111,  114,  119, -117,  -10, -112, 
    -57,   99,  -34,   75,  -11,  121,  119,  -88,   36,  -40, 
     86,  -40,  -14,   19,  114,  -30,  121,   81,    3,   18, 
      4,   28,   25,   36, -111,  -18,   -3,   47,   10,  118, 
     74,   82,   65,  -82,  -54,   32,  -81,  -99,   17,  -53, 
    -20,  -20,  -38,   19,  -20,   41,   36,  -21,    1,    2, 
     11,  -16, -124,   79,  103, -119,  115,   21,   37,  -35, 
   -120,   94,  104,  121,   79,    1,   94,  -67,  -45,   68, 
    -30,    9,   37,  109,  -43,  -85, -115,    9,   59, -123, 
   -110,   -3,   24, -127,  -85,   80,    8,  -75,  -63,  -74, 
    -96,   85,  106,  -37, -122,   92,  -25,  116,   81,   -8, 
    -39,    6,   33,  -71,  -58,  115,   -2,  120,   78,   73, 
    -16,    8,   44,  -55,  -31,  -98,  -18,  -71,   53,   -1, 
    116,  -23,   37,  110,   40, -123,  -34,   84,    2,   32, 
     94,  -84,   57,  123,    8,   51,  -56,   24,   12,   83, 
    -89, -126,  121,  -54,  -59,   90,   30,   30,  -56,   32, 
     36,  -64, -125,  -58,  108,    1,   58,  -12,  -88,  -72, 
   -105,   27,   58,  -82,  106,   59,  -49,  -48,   35,  115, 
    -71,   19,   16,   77,   16,   38,   85,  -58,    8,    6};

SC_MODULE( ccd )
{
   // CCD Ports
   sc_fifo_in<bool> startCcdCapture;
   sc_fifo_out<bool> doneCcdCapture;
   sc_fifo_out<char> pixel;
   
   // CCD Vars
   char buffer[CCD_ROW][CCD_COL];
   int  rowIndex, colIndex;
   double   sim_time;
   
   // CCD Events
   sc_event   startPop;

   // CCD Processes
   void capture(void) 
   {
      startCcdCapture.read();
	  sim_time = sc_simulation_time();
      for(rowIndex=0; rowIndex<CCD_ROW; rowIndex++) 
      {
         for(colIndex=0; colIndex<CCD_COL; colIndex++) 
         {
            buffer[rowIndex][colIndex] = IMAGE[rowIndex*CCD_COL + colIndex];
         }
      }
      doneCcdCapture.write( true );
      notify(startPop);
   }

   void pop(void) 
   {
      wait(startPop);
      for(rowIndex=0; rowIndex<CCD_ROW; rowIndex++)
      {
         for(colIndex=0; colIndex<CCD_COL; colIndex++) 
         {
            pixel.write( buffer[rowIndex][colIndex] );
         }
      }
	  cout << "CCD\tdone at " 
           << (sc_simulation_time()/1000) << " us\t"
           << "execution time = " 
           << (sc_simulation_time() - sim_time)/1000 << " us" << endl;
   }

   // Module Constructor
   SC_CTOR( ccd ) {
      SC_THREAD( capture );
      SC_THREAD( pop );
   }
};