/******************************************************************************
* Title: uart.sc
* Author: Rob Walstrom
* Date: 07/9/2004
******************************************************************************/
import "global";

behavior uartInitialize(out FILE *outputFileHandle) {
	void main(void) {
		outputFileHandle = fopen("uart_out.txt", "w");
		printf("UART starting...\n");
	}
};

behavior uartSend(in FILE *outputFileHandle, in char data, in event dataSent, 
			out event dataRecv) {
	int i = 0;
	void main(void) {
		for(i=0; i < 16384; i++) {
			wait(dataSent);
			fprintf(outputFileHandle, "%i\n", (int)data);
			notify(dataRecv);
		}
		printf("	...UART exiting\n");
	}
};

behavior uart(in char data, in event dataSent, 
			out event dataRecv) {
	
	FILE *outputFileHandle;
	
	uartInitialize	uartInit(outputFileHandle);
	uartSend	uartS(outputFileHandle, data, dataSent, dataRecv);
	
	void main(void) {
		uartInit.main();
		uartS.main();
	}
};
