/******************************************************************************
* Title: top.sc
* Author: Rob Walstrom
* Date: 07/9/2004
******************************************************************************/
import "global";
import "ccd";
import "ccdpp";
import "cntrl";
import "codec";
import "uart";

behavior Main {

	event	startCcdCapture, 
		doneCcdCapture,
		ccdPixelReq,
		ccdPixelSent,
		startCcdppCapture,
		doneCcdppCapture,
		ccdppPixelReq,
		ccdppPixelSent,
		codecPixelPushRecv,
		codecPixelPushSent,
		codecPixelPopReq,
		codecPixelPopSent,
		startFdct,
		doneFdct,
		uartPixelSent,
		uartPixelRecv;

	char	ccdPixelOut,
		ccdppPixelOut,
		uartData;
		
	short	codecPixelPop,
		codecPixelPush;

	ccd U00(startCcdCapture, ccdPixelReq, doneCcdCapture, ccdPixelSent, ccdPixelOut);
	
	ccdpp U01(startCcdppCapture, ccdppPixelReq, doneCcdppCapture, ccdppPixelSent, ccdppPixelOut,
		doneCcdCapture, ccdPixelSent, ccdPixelOut, startCcdCapture, ccdPixelReq);
	
	codec U02(codecPixelPush, codecPixelPushSent, startFdct, codecPixelPopReq,
		codecPixelPop, codecPixelPushRecv, doneFdct, codecPixelPopSent);
		
	uart U03(uartData, uartPixelSent, uartPixelRecv);
	
	cntrl U04(doneCcdppCapture, ccdppPixelSent, ccdppPixelOut, startCcdppCapture, ccdppPixelReq,
		codecPixelPushRecv, codecPixelPopSent, doneFdct, codecPixelPop,
		codecPixelPushSent, codecPixelPopReq, startFdct, codecPixelPush,
		uartPixelRecv, uartPixelSent, uartData);
	
	int main(void) {
		par {	
			U00.main();
			U01.main();
			U02.main();
			U03.main();
			U04.main();
		}
		
		return 0;
	}
};
