/******************************************************************************
* Title: codec.sc
* Author: Rob Walstrom
* Date: 07/9/2004
******************************************************************************/
import "global";

const short COS_TABLE[64] = {
	32768,  32138,  30273,  27245,  23170,  18204,  12539,   6392,
	32768,  27245,  12539,  -6392, -23170, -32138, -30273, -18204,
	32768,  18204, -12539, -32138, -23170,   6392,  30273,  27245,
	32768,   6392, -30273, -18204,  23170,  27245, -12539, -32138,
	32768,  -6392, -30273,  18204,  23170, -27245, -12539,  32138,
	32768, -18204, -12539,  32138, -23170,  -6392,  30273, -27245,
	32768, -27245,  12539,   6392, -23170,  32138, -30273,  18204,
	32768, -32138,  30273, -27245,  23170, -18204,  12539,  -6392
};

behavior codecPushPixel(inout int idx, in short pixelIn, in event pixelInSent, 
			out event pixelInRecv, out short buffer[8][8]) {
	int i;
	
	void main(void) {
		printf("CODEC PushPixel starting...\n");
		for(i=0; i< 8192; i++) {
			if( idx == 64 ) {
	        		idx = 0;    		
    			}
    			
			wait(pixelInSent);
			buffer[idx / 8][idx % 8] = pixelIn;
			notify(pixelInRecv);
			
			idx++;
		}
		printf("	...CODEC PushPixel exiting\n");
	}
};			

behavior codecDoFdct(inout short buffer[8][8], in event startFdct, 
			out event doneFdct, out int idx) {
	int x, y;
	int i;
	short tempBuffer[8][8];
	
	// FDCT Functions
	double Y(int a, int b) {

		return COS_TABLE[(a*8)+b] / 32768.0;
	}
	
	double C(int h) {
		return h ? 1.0 : 23170 / 32768.0;
	}
	
	int F(int u, int v, short img[8][8]) {
	
		double s[8], r = 0;
		int a;
	
		for(a=0; a<8; a++) {
	
		s[a] =  img[a][0] * Y(0, v) +
			img[a][1] * Y(1, v) +
			img[a][2] * Y(2, v) +
			img[a][3] * Y(3, v) +
			img[a][4] * Y(4, v) +
			img[a][5] * Y(5, v) +
			img[a][6] * Y(6, v) +
			img[a][7] * Y(7, v);
		}
	
		for(a=0; a<8; a++) {
	
			r += s[a] * Y(a, u);
		}
	
		return (short)(r * .25 * C(u) * C(v));
	}

	//  FDCT Behavior
	void main(void) {
		printf("CODEC DoFDCT starting...\n");
	
		for(i=0; i < 128; i++) {
			
			wait(startFdct);
			
			for(x=0; x<8; x++) {

				for(y=0; y<8; y++) {

					tempBuffer[x][y] = F(x, y, buffer);
				}
			}
			for(x=0; x<8; x++) {

				for(y=0; y<8; y++) {

					buffer[x][y] = tempBuffer[x][y];
				}
			}
			idx = 0;
			
			notify(doneFdct);
		}
		printf("	...CODEC DoFDCT exiting\n");
	}
};
		
behavior codecPopPixel(inout int idx, in short buffer[8][8], in event pixelOutReq, out short pixelOut, out event pixelOutSent) {
	int i;
	
	void main(void) {
		printf("CODEC PopPixel starting...\n");
		for(i=0;i < 8192;i++) {
			if (idx == 64)
			{
				idx = 0;
			}	
					
			wait(pixelOutReq);
			pixelOut = buffer[idx/8][idx%8];
			notify(pixelOutSent);
			idx++;
		}
		printf("	...CODEC PopPixel exiting\n");
	}
};

behavior codec(in short pixelIn, in event pixelInSent, in event startFdct, in event pixelOutReq,
		out short pixelOut, out event pixelInRecv, out event doneFdct, out event pixelOutSent) {
	
	int idx = 0;
	short buffer[8][8];
	
	codecPushPixel	codecPushP(idx, pixelIn, pixelInSent, pixelInRecv, buffer);
	codecDoFdct	codecFdct(buffer, startFdct, doneFdct, idx);
	codecPopPixel	codecPopP(idx, buffer, pixelOutReq, pixelOut, pixelOutSent);
	
	void main(void) {
		par {
		codecPushP.main();
		codecFdct.main();
		codecPopP.main();
		}
	
	}
};
