/******************************************************************************
* Title: cntrl.sc
* Author: Rob Walstrom
* Date: 07/9/2004
******************************************************************************/
import "global";
#include <assert.h>

#define SZ_ROW          64
#define SZ_COL          128
#define NUM_ROW_BLOCKS  (SZ_ROW / 8)
#define NUM_COL_BLOCKS  (SZ_COL / 8)

behavior cntrlCaptureImage(in event doneCapture, in event ccdppPixelSent, in char ccdppPixel,
			out short buffer[SZ_ROW][SZ_COL], out event startCapture, out event ccdppPixelReq) {
	int i, j;
	
	void main(void) {
		printf("CNTRL starting...\n");
		notify(startCapture);
		wait(doneCapture);
		
		for(i=0; i<SZ_ROW; i++) {

			for(j=0; j<SZ_COL; j++) {
				notify(ccdppPixelReq);
				wait(ccdppPixelSent);
				buffer[i][j] = ccdppPixel;
			}
		}   
	}
};

behavior cntrlCompressImage(in event codecPixelPushRecv, in event codecPixelPopSent, in event doneFdct, in short codecPixelPop,
		inout short buffer[SZ_ROW][SZ_COL], out event codecPixelPushSent, out event codecPixelPopReq, out event startFdct, out short codecPixelPush) {

	char QuantShiftTable[8][8];
	
	int i, j, k, l;
	
	void main(void) {
	
		/* part 0 - initialize the array */	
		QuantShiftTable[0][0] = 0;
		i = 1;
		k = 11;
		l = 0;
		while(k > 2) {
			for(j=0; j<k; j++) {
				QuantShiftTable[i/8][i%8] = (char) l;
				i++;
			}
			k--;
			l++;
		}	
	
		/* part 1 - FDCT */
		for(i=0; i<NUM_ROW_BLOCKS; i++) {
			
			for(j=0; j<NUM_COL_BLOCKS; j++) {
				
				/* push the block and perform FDCT */
				for(k=0; k<8; k++) {
					for(l=0; l<8; l++) {
						codecPixelPush = (char)buffer[i * 8 + k][j * 8 + l];
						notify(codecPixelPushSent);
						wait(codecPixelPushRecv);
					}
				}
				notify(startFdct);
				wait(doneFdct);
            
				/* pop the block and store in buffer */
				for(k=0; k<8; k++) {
					for(l=0; l<8; l++) {
						notify(codecPixelPopReq);
						wait(codecPixelPopSent);
						buffer[i * 8 + k][j * 8 + l] = codecPixelPop;
					}
				}
			}
		}

		/* part 2 - quantization */ 
		for(i=0; i<NUM_ROW_BLOCKS; i++) {

			for(j=0; j<NUM_COL_BLOCKS; j++) {

				/* quantize the block in place */
				for(k=0; k<8; k++) {

					for(l=0; l<8; l++) {

						buffer[i * 8 + k][j * 8 + l] >>= QuantShiftTable[k][l];
					}
				}
			}
		}
	}
};

behavior cntrlSendImage(in event uartPixelRecv, in short buffer[SZ_ROW][SZ_COL], out event uartPixelSent, out char uartPixel) {
	short temp;
	int i, j;
	
	void main(void) {
		for(i=0; i<SZ_ROW; i++) {
			for(j=0; j<SZ_COL; j++) {
				temp = buffer[i][j];
				
				notify(uartPixelSent);
				uartPixel = ((char*)&temp)[0];    /* send upper byte */
				wait(uartPixelRecv);
				
				notify(uartPixelSent);
				uartPixel = ((char*)&temp)[1];    /* send lower byte */
				wait(uartPixelRecv);
			}
		}
		printf("	...CNTRL exiting\n");
	}
};

behavior cntrl(	in event doneCapture, in event ccdppPixelSent, in char ccdppPixel, 
		out event startCapture, out event ccdppPixelReq,
		in event codecPixelPushRecv, in event codecPixelPopSent, in event doneFdct, in short codecPixelPop,
		out event codecPixelPushSent, out event codecPixelPopReq, out event startFdct, out short codecPixelPush,
		in event uartPixelRecv,
		out event uartPixelSent, out char uartPixel) {
	
	short buffer[SZ_ROW][SZ_COL];
	
	cntrlCaptureImage cntrlCapt(doneCapture, ccdppPixelSent, ccdppPixel, buffer, startCapture, ccdppPixelReq);
	
	cntrlCompressImage cntrlComp(codecPixelPushRecv, codecPixelPopSent, doneFdct, codecPixelPop,
		buffer, codecPixelPushSent, codecPixelPopReq, startFdct, codecPixelPush);
		
	cntrlSendImage	cntrlSend(uartPixelRecv, buffer, uartPixelSent, uartPixel);
	
	void main(void) {
		cntrlCapt.main();
		cntrlComp.main();
		cntrlSend.main();		
	}
};
