/******************************************************************************
* Title: ccdpp.sc
* Author: Rob Walstrom
* Date: 07/9/2004
******************************************************************************/
import "global";

#define SZ_ROW      64
#define SZ_COL      128

behavior ccdppCapture(in event startCcdppCapture, in event doneCcdCapture, in event ccdPixelSent, in char ccdPixel, 
			out char buffer[SZ_ROW][SZ_COL], out event startCcdCapture, out event ccdPixelReq, out event doneCcdppCapture)
{
	char bias;
	
	int rowIndex, colIndex;
	
	char tempRow[SZ_COL];
	
	void main(void)
	{
		printf("CCDPP starting...\n");
		wait(startCcdppCapture);
		notify(startCcdCapture);
		wait(doneCcdCapture);
		
		for(rowIndex=0; rowIndex<SZ_ROW; rowIndex++) {
			for(colIndex=0; colIndex<SZ_COL; colIndex++) {
            			notify(ccdPixelReq);
            			wait(ccdPixelSent);
				tempRow[colIndex] = ccdPixel;
			}
			
			notify(ccdPixelReq);
			wait(ccdPixelSent);
			bias = ccdPixel;
			notify(ccdPixelReq);
			wait(ccdPixelSent);
			bias = (bias + ccdPixel) / 2;
			
			for(colIndex=0; colIndex<SZ_COL; colIndex++) {

				tempRow[colIndex] -= bias;
				buffer[rowIndex][colIndex] = tempRow[colIndex];
			}
		}
		rowIndex = 0;
		colIndex = 0;
		
		notify(doneCcdppCapture);
	}
};

behavior ccdppPopPixel(in event pixelReq, in char buffer[SZ_ROW][SZ_COL],
			out event pixelSent, out char pixel)
{
	int rowIndex, colIndex;

	void main(void)
	{
		for(rowIndex=0; rowIndex<SZ_ROW; rowIndex++)
		{
			for(colIndex=0; colIndex<SZ_COL; colIndex++)
			{
				wait(pixelReq);
				pixel = buffer[rowIndex][colIndex];
				notify(pixelSent);
			}
		}
		printf("	...CCDPP exiting\n");
	}
};

behavior ccdpp( in event startCcdppCapture, in event ccdppPixelReq,
		out event doneCcdppCapture, out event ccdppPixelSent, out char ccdppPixel,
		in event doneCcdCapture, in event ccdPixelSent, in char ccdPixel,
		out event startCcdCapture, out event ccdPixelReq)
{
	char buffer[SZ_ROW][SZ_COL];
	
	ccdppCapture	ccdppCapt(startCcdppCapture, doneCcdCapture, ccdPixelSent, ccdPixel, buffer,
			startCcdCapture, ccdPixelReq, doneCcdppCapture);
	ccdppPopPixel	ccdppPop(ccdppPixelReq, buffer,
			ccdppPixelSent, ccdppPixel);

	
	void main(void)
	{
		ccdppCapt.main();
		ccdppPop.main();		
	}
};
