/******************************************************************************
* Title: ccd.sc
* Author: Rob Walstrom
* Date: 07/9/2004
******************************************************************************/
import "global";
#include <assert.h>

#define SZ_ROW	64
#define SZ_COL	(128 + 2)

behavior ccdInitialize( out FILE *imageFileHandle) {
	void main(void) {
		printf("CCD starting...\n");
		assert( "image.txt" );
		imageFileHandle = fopen("image.txt", "r");

		//assert( imageFileHandle );
	}
};

behavior ccdCapture(in FILE *imageFileHandle, in event startCapture, 
out char buffer[SZ_ROW][SZ_COL], out event doneCapture)
{
	int pixel;
	int rowIndex, colIndex;
	
	void main(void) {
		assert( imageFileHandle );
		rewind(imageFileHandle);
		
		wait(startCapture);
		
		for(rowIndex=0; rowIndex<SZ_ROW; rowIndex++) {
			for(colIndex=0; colIndex<SZ_COL; colIndex++) {
				if( fscanf(imageFileHandle, "%i", &pixel) == 1 ) {
					assert( pixel >= -128 && pixel <= 127 );
					buffer[rowIndex][colIndex] = (char)pixel;
				}
				else {
					assert( 0 );
				}
			}
		}
		rowIndex = 0;
		colIndex = 0;
		
		notify(doneCapture);
	}
};

behavior ccdPopPixel(in char buffer[SZ_ROW][SZ_COL], in event pixelReq,
	out event pixelSent, out char pixel)
{
	int rowIndex, colIndex;

	void main(void) {

		for(rowIndex=0; rowIndex<SZ_ROW; rowIndex++)
		{
			for(colIndex=0; colIndex<SZ_COL; colIndex++)
			{
				wait(pixelReq);
				pixel = buffer[rowIndex][colIndex];
				notify(pixelSent);
			}
		}
		printf("	...CCD exiting\n");
	}
};

behavior ccd(in event startCcdCapture, in event pixelReq, 
	out event doneCcdCapture, out event pixelSent, out char pixel)
{
	FILE *imageFileHandle;
	char buffer[SZ_ROW][SZ_COL];
	
	ccdInitialize	ccdInit(imageFileHandle);
	ccdCapture	ccdCapt(imageFileHandle, startCcdCapture, buffer, doneCcdCapture);
	ccdPopPixel	ccdPopP(buffer, pixelReq, pixelSent, pixel);
	
	void main(void) {
		ccdInit.main();
		ccdCapt.main();
		ccdPopP.main();
	}
};
