/******************************************************************************
* Title: uart.sc
* Author: Rob Walstrom
* Date: 08/06/2004
******************************************************************************/
import "global";
import "interfaces";

behavior uartInitialize(out FILE *outputFileHandle) {
	void main(void) {
		outputFileHandle = fopen("uart_out.txt", "w");
		printf("UART starting...\n");
	}
};

behavior uartSend(uartBus0 Bus0, in FILE *outputFileHandle, inout int i) {
	void main(void) {
		for(i=0; i < 16384; i++) {
			fprintf(outputFileHandle, "%i\n", (int)Bus0.uartRecv());
		}
		printf("	...UART exiting\n");
	}
};

behavior uart(uartBus0 Bus0) {
	
	FILE *outputFileHandle;
	int i;
	
	uartInitialize	uartInit(outputFileHandle);
	uartSend	uartS(Bus0, outputFileHandle, i);
	
	void main(void) {
		uartInit.main();
		uartS.main();
	}
};
