/******************************************************************************
* Title: codec.sc
* Author: Rob Walstrom
* Date: 08/06/2004
******************************************************************************/
import "global";
import "interfaces";

const short COS_TABLE[64] = {
	32768,  32138,  30273,  27245,  23170,  18204,  12539,   6392,
	32768,  27245,  12539,  -6392, -23170, -32138, -30273, -18204,
	32768,  18204, -12539, -32138, -23170,   6392,  30273,  27245,
	32768,   6392, -30273, -18204,  23170,  27245, -12539, -32138,
	32768,  -6392, -30273,  18204,  23170, -27245, -12539,  32138,
	32768, -18204, -12539,  32138, -23170,  -6392,  30273, -27245,
	32768, -27245,  12539,   6392, -23170,  32138, -30273,  18204,
	32768, -32138,  30273, -27245,  23170, -18204,  12539,  -6392
};

behavior codecPushPixel(codecBus0 Bus0, inout int idx, out short buffer[8][8]) {
	void main(void) {
		for(idx=0; idx< 64; idx++) {
			buffer[idx / 8][idx % 8] = Bus0.codecRecv();
		}
	}
};			

behavior codecDoFdct(codecBus0 Bus0, inout short buffer[8][8], inout short tempBuffer[8][8],
		inout int x, inout int y, inout int z, inout double r, inout double s[8]) {
	// FDCT Functions
	double Y(int a, int b) {

		return COS_TABLE[(a*8)+b] / 32768.0;
	}
	
	double C(int h) {
		return h ? 1.0 : 23170 / 32768.0;
	}
	
	//  FDCT Behavior
	void main(void) {		
		Bus0.startFdct();

		for(x=0; x<8; x++) {

			for(y=0; y<8; y++) {
			
				r = 0;			
				for(z=0; z<8; z++) {
					s[z] =	buffer[z][0] * Y(0, y) +
						buffer[z][1] * Y(1, y) +
						buffer[z][2] * Y(2, y) +
						buffer[z][3] * Y(3, y) +
						buffer[z][4] * Y(4, y) +
						buffer[z][5] * Y(5, y) +
						buffer[z][6] * Y(6, y) +
						buffer[z][7] * Y(7, y);
				}
				
				for(z=0; z<8; z++) {
					r += s[z] * Y(z, x);
				}
				

				tempBuffer[x][y] = (short)(r * .25 * C(x) * C(y));
			}
		}
		for(x=0; x<8; x++) {

			for(y=0; y<8; y++) {

				buffer[x][y] = tempBuffer[x][y];
			}
		}
		Bus0.doneFdct();
	}
};
		
behavior codecPopPixel(codecBus0 Bus0, inout int idx, in short buffer[8][8]) {
	void main(void) {
		for(idx=0; idx<64; idx++) {
			Bus0.codecSend(buffer[idx/8][idx%8]);
		}
	}
};

behavior codec(codecBus0 Bus0) {
	
	int i;
	int x, y, z;	// index vars for DoFdct
	double r;
	double s[8];
	int idx = 0;
	short buffer[8][8];
	short tempBuffer[8][8];
	
	codecPushPixel	codecPushP(Bus0, idx, buffer);
	codecDoFdct	codecFdct(Bus0, buffer, tempBuffer, x, y, z, r, s);
	codecPopPixel	codecPopP(Bus0, idx, buffer);
	
	void main(void) {
		for(i=0; i<128; i++) {
			codecPushP.main();
			codecFdct.main();
			codecPopP.main();
		}
	
	}
};
