/******************************************************************************
* Title: cntrl.sc
* Author: Rob Walstrom
* Date: 08/06/2004
******************************************************************************/
import "global";
import "interfaces";
#include <assert.h>

#define SZ_ROW          64
#define SZ_COL          128
#define NUM_ROW_BLOCKS  (SZ_ROW / 8)
#define NUM_COL_BLOCKS  (SZ_COL / 8)

behavior cntrlCaptureImage(cntrlBus0 Bus0) {
	void main(void) {
		printf("CNTRL starting...\n");
		Bus0.startCapture();
	}
};

behavior cntrlCompressImage( IMem mem, cntrlBus0 Bus0, inout char QuantShiftTable[8][8], 
			inout int i,  inout int j, inout int k, inout int l, inout short temp) {
	void main(void) {
	
		/* part 0 - initialize the array */	
		QuantShiftTable[0][0] = 0;
		i = 1;
		k = 11;
		l = 0;
		while(k > 2) {
			for(j=0; j<k; j++) {
				QuantShiftTable[i/8][i%8] = (char) l;
				i++;
			}
			k--;
			l++;
		}	
	
		/* part 1 - FDCT */
		for(i=0; i<NUM_ROW_BLOCKS; i++) {
			
			for(j=0; j<NUM_COL_BLOCKS; j++) {
				
				/* push the block and perform FDCT */
				for(k=0; k<8; k++) {
					for(l=0; l<8; l++) {
						Bus0.codecPush(mem.read( (i * 8 + k)*SZ_COL + (j * 8 + l) ));
					}
				}
				Bus0.runFdct();
            
				/* pop the block and store in buffer */
				for(k=0; k<8; k++) {
					for(l=0; l<8; l++) {
						mem.write( (i * 8 + k)*SZ_COL + (j * 8 + l), Bus0.codecPop() );
						//buffer[i * 8 + k][j * 8 + l] = codecPixelPop;
					}
				}
			}
		}

		/* part 2 - quantization */ 
		for(i=0; i<NUM_ROW_BLOCKS; i++) {

			for(j=0; j<NUM_COL_BLOCKS; j++) {

				/* quantize the block in place */
				for(k=0; k<8; k++) {

					for(l=0; l<8; l++) {
						temp = mem.read( (i * 8 + k)*SZ_COL + (j * 8 + l) );
						temp >>= QuantShiftTable[k][l];
						mem.write( (i * 8 + k)*SZ_COL + (j * 8 + l), temp );
					}
				}
			}
		}
	}
};

behavior cntrlSendImage( IMem mem, cntrlBus0 Bus0, inout int i, inout int j, inout short temp) {
	void main(void) {
		for(i=0; i<SZ_ROW; i++) {
			for(j=0; j<SZ_COL; j++) {
				temp = mem.read( i*SZ_COL + j );
				Bus0.uartPush( ((char*)&temp)[0] );    /* send upper byte */		
				Bus0.uartPush( ((char*)&temp)[1] );    /* send lower byte */
			}
		}
		printf("	...CNTRL exiting\n");
	}
};

behavior cntrl(	IMem mem, cntrlBus0 Bus0) {

	char QuantShiftTable[8][8];
	int i, j, k, l;
	short temp;

	cntrlCaptureImage cntrlCapt(Bus0);
	
	cntrlCompressImage cntrlComp(mem, Bus0, QuantShiftTable, i, j, k, l, temp);
		
	cntrlSendImage	cntrlSend(mem, Bus0, i, j, temp);
	
	void main(void) {
		cntrlCapt.main();
		cntrlComp.main();
		cntrlSend.main();		
	}
};
