import "global";
import "interfaces";

channel Bus0() implements ccdBus0, ccdppBus0, cntrlBus0, codecBus0, uartBus0
{
	char	pixel, uartVal;
	bool	ccdValid, 
		codecPushValid,
		codecPopValid,
		uartValid;
	event	ccdppWakeup,
		ccdPixelReady,
		startCcdCapt,
		doneCcdCapt,
		startCcdppCapt,
		doneCcdppCapt,
		codecRecvWakeup,
		codecPopWakeup,
		codecRecvReady,
		codecPopReady,
		FdctBegin,
		FdctEnd,
		uartWakeup,
		uartReady;
	short	pushVal, popVal;
	
	//ccdBus0 functions
	void ccdSend(char x) {
		pixel = x;
		ccdValid = true;
		notify(ccdppWakeup);
		wait(ccdPixelReady);
	}
	
	void doCcdCapture(void) {
		wait(startCcdCapt);
		notify(doneCcdCapt);
	}
	
	// ccdppBus0 methods
	char ccdRecv(void) {
		while(!ccdValid) {wait(ccdppWakeup);}
		ccdValid = false;
		notify(ccdPixelReady);
		return (pixel);
	}
	
	void startCcdCapture(void) {
		notify(startCcdCapt);
		wait(doneCcdCapt);
	}
	
	void startCcdppCapture(void) {
		wait(startCcdppCapt);
	}
	
	void doneCcdppCapture(void) {
		notify(doneCcdppCapt);
	}
	
	// cntrlBus0 methods
	void startCapture(void) {
		notify(startCcdppCapt);
		wait(doneCcdppCapt);
	}
	
	void codecPush(short x) {
		pushVal = x;
		codecPushValid = true;
		notify(codecRecvWakeup);
		wait(codecRecvReady);
	}
	
	short codecPop(void) {
		while(!codecPopValid) {wait(codecPopWakeup);}
		codecPopValid = false;
		notify(codecPopReady);
		return (popVal);
	}
	
	void runFdct(void) {
		notify(FdctBegin);
		wait(FdctEnd);
	}
	
	void uartPush(char x) {
		uartVal = x;
		uartValid = true;
		notify(uartWakeup);
		wait(uartReady);
	}
	
	// codecBus0 methods
	short codecRecv(void) {
		while(!codecPushValid) {wait(codecRecvWakeup);}
		codecPushValid = false;
		notify(codecRecvReady);
		return (pushVal);
	}
	
	void codecSend(short x) {
		popVal = x;
		codecPopValid = true;
		notify(codecPopWakeup);
		wait(codecPopReady);
	}
	
	void startFdct(void) {
		wait(FdctBegin);
	}
	
	void doneFdct(void){
		notify(FdctEnd);
	}
	
	// uartBus0 methods
	char uartRecv(void) {
		while(!uartValid) {wait(uartWakeup);}
		uartValid = false;
		notify(uartReady);
		return uartVal;
	}
	
};
