/******************************************************************************
* Title: ccdpp.sc
* Author: Rob Walstrom
* Date: 08/06/2004
******************************************************************************/
import "global";
import "interfaces";

#define SZ_ROW      64
#define SZ_COL      128

behavior ccdppCapture(	IMem mem, ccdppBus0 Bus0, inout char bias, inout int rowIndex, inout int colIndex, inout char tempRow[SZ_COL])
{
	void main(void)
	{
		printf("CCDPP starting...\n");
		Bus0.startCcdppCapture();
		Bus0.startCcdCapture();
		
		for(rowIndex=0; rowIndex<SZ_ROW; rowIndex++) {
			for(colIndex=0; colIndex<SZ_COL; colIndex++) {
				tempRow[colIndex] = Bus0.ccdRecv();
			}
			bias = Bus0.ccdRecv();
			bias = (bias + Bus0.ccdRecv()) / 2;
			for(colIndex=0; colIndex<SZ_COL; colIndex++) {

				tempRow[colIndex] -= bias;
				mem.write(rowIndex*SZ_COL + colIndex, (short) tempRow[colIndex]);
			}
		}
		Bus0.doneCcdppCapture();
		printf("	...CCDPP exiting\n");
	}
};

behavior ccdpp( IMem mem, ccdppBus0 Bus0)
{

	char	bias;
	int	rowIndex, colIndex;
	char	tempRow[SZ_COL];
	
	ccdppCapture	ccdppCapt(mem, Bus0, bias, rowIndex, colIndex, tempRow);
	
	void main(void)
	{
		ccdppCapt.main();
	}
};
