function [Altmintime,Bhat, Uhat,iter,ERRinit, err_iter, time_iter] = alt_min_phs_rtv_2D(Y, Params, Afull, Afull_t, Afull_tk,X)
Den_X      =   norm(X,'fro');
err_iter = zeros(Params.T_altmin+1, 1);
time_iter = zeros(Params.T_altmin +1, 1);
%  Truncating measurements%////////////////////////////////////////
tic;
Ytrk    =   zeros(Params.n_1,Params.n_2,Params.L,Params.q);
for ni = 1 : Params.q
    Yk  =   reshape(Y(:,:,:,ni), Params.n_1*Params.n_2*Params.L, 1);
    %normest =   sum(Yk(:))/numel(Yk);
    normest =   sum(Yk(:))/Params.m;
    Eyk     =   (Yk <= Params.alpha_y^2*normest);
    % num_larg = sum(Eyk);
    Ytrk(:,:,:,ni)  =   reshape(Eyk.*Yk,Params.n_1,Params.n_2,Params.L);
end

%/////////////////////////////////////////////////////////////////
% Block power method for estimating initial U
fprintf('Initialization begins\n');
U_tmp1  = randn(Params.n_1*Params.n_2,Params.r);
%[Uupdt, v, w]   =   qr(reshape(randn(n_1, n_2, r), n_1*n_2, r), 0);
[U_upd_vec, ~, ~]   =   qr(U_tmp1, 0);

Uupdt          =   reshape(U_upd_vec, Params.n_1, Params.n_2, Params.r);

U_tmp   =  zeros(Params.n_1,Params.n_2,Params.r) ;

for t = 1 : Params.itr_num_pow_mth
    for nr  =   1 : Params.r
        U_tmp(:,:,nr)           = Afull_t( Ytrk.* Afull(repmat(Uupdt(:,:,nr), [1,1,Params.q])));
    end
    [Uupdt3, ~, ~]   =   qr(reshape(U_tmp, Params.n_1*Params.n_2, Params.r), 0);
    Uupdt            =     reshape(Uupdt3, Params.n_1, Params.n_2, Params.r);
    
    % Uupdt          =   reshape( U_tmp, Params.n_1, Params.n_2, Params.r);
end


Uhat_vec    =   reshape(Uupdt, Params.n_1*Params.n_2, Params.r);
Uhat            =    Uhat_vec;
%Err_U       =   norm(Uvec - Uhat_vec * Uhat_vec' * Uvec);
Altmintime(1) = toc;

%////////////////////////////////////////////////////////////////
%  Finding the initial estimate of B
tic;
AUnew   =   zeros(Params.n_1*Params.n_2*Params.L,Params.q,Params.r);
Ybk     =   zeros(Params.n_1,Params.n_2,Params.r,Params.q);
for nr  =   1 : Params.r
    AUnew(:,:,nr) =  reshape(Afull(repmat(Uupdt(:,:,nr),[1,1,Params.q])), Params.n_1*Params.n_2*Params.L,Params.q);
    Ybk(:,:,nr,:) =  Afull_tk(Y.* Afull(repmat(Uupdt(:,:,nr), [1,1,Params.q])));
end
Bhat     =  zeros(Params.r,Params.q);
for na = 1 : Params.q
    ybk = Uhat_vec' * reshape(Ybk(:,:,:,na),Params.n_1*Params.n_2,Params.r);
    [b_t1,~,~]   =   svd(ybk);
    nb =   sqrt(sum(reshape(Y(:,:,:,na),Params.n_1*Params.n_2*Params.L,1))/Params.m);
    nc = Params.m*Params.r/(norm(reshape(AUnew(:,na,:),Params.n_1*Params.n_2*Params.L,Params.r),'fro')^2);
    norm_b_a_hat1=   sqrt(nc)* nb;
    Bhat(:,na)   =   norm_b_a_hat1 * b_t1(:,1);
end
%///////////////////////////////////////////////////////////////
Altmintime(2)=toc;

time_iter(1) = toc;
%Chat    =   zeros(Params.m, Params.q);
D      =        Uhat*Bhat;
%D       =        reshape(DX,n,q);
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%initialization error
    for na = 1 : Params.q
        xa_hat      =   D(:,na);
        xa          =   X(:,na);
        %                 %  Tmp_Err_X(na)   =   min(norm(xa-xa_hat)^2, norm(xa+xa_hat)^2);
        Tmp_Err_X1(na) 	=   norm(xa - exp(-1i*angle(trace(xa'*xa_hat))) * xa_hat, 'fro');
    end
    % Rel_Err(:,t)=  Tmp_Err_X;
    Err      = sum(Tmp_Err_X1);
    ERRinit     =   Err / Den_X;
    fprintf('Our initialization Error is:\t%2.2e\n',ERRinit);
    err_iter(1) = ERRinit;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tic;
Xhat    =   Uhat*Bhat;
Xhat2   =   reshape(Xhat,Params.n_1,Params.n_2,Params.q);
Chat     =   exp(1i*angle(Afull(Xhat2))); % Initial phase
%Chat2   =    reshape(Chat,Params.n_1*Params.n_2*Params.L,Params.q);


Ysqrt   =   sqrt(Y);
%Ysqrt2  =   reshape(Ysqrt,Params.n_1*Params.n_2*Params.L,Params.q );

%////////////////////////////////////////////////////////////////////////
%           Main Loop
%///////////////////////////////////////////////////////////////////////

for t = 1 : Params.T_altmin
    fprintf('iteration # %d ... \n', t)
    %//////////////////////////////////////////////////////////////////////
    %                Updating Uhat
    %//////////////////////////////////////////////////////////////////////
    %Uvec    =  zeros(Params.n_1*Params.n_2,Params.r);
    K1       =   Chat .* Ysqrt;
    
    Zvec     =   reshape(K1,Params.n_1*Params.n_2*Params.L*Params.q,1);
    
    
    [Uvec,flag,resNE,iter]    =   cgls_new(@mult_H2, @mult_Ht2 , Zvec, 0,1e-6 ,3);
  %   [Uvec,flag,resNE,iter]    =   cgls_new(@mult_H2, @mult_Ht2 , Zvec);
    
    Uhat    =   reshape(Uvec, Params.n_1*Params.n_2, Params.r);
    
    %//////////////////////////////////////////////////////////////////////
    %               Updating Bhat and Chat
    %/////////////////////////////////////////////////////////////////////
    
    %K        =   reshape(K1,Params.n_1*Params.n_2*Params.L*Params.q,1);
    K2       =   reshape(K1,Params.n_1*Params.n_2*Params.L,Params.q);
    
    U2       =    reshape(Uhat,Params.n_1,Params.n_2, Params.r);
    
    R1     =  zeros(Params.n_1,Params.n_2,Params.L,Params.q,Params.r);
    Bhat   =   zeros(Params.r,Params.q);
    for nr  =   1 : Params.r
        R1(:,:,:,:,nr)            =   Afull(repmat(U2(:,:,nr), [1,1,Params.q]));
    end
    for aa  =  1:Params.q
        R            =   reshape(R1(:,:,:,aa, :),Params.n_1*Params.n_2*Params.L,Params.r);
        K           =   reshape(K2(:,aa),Params.n_1*Params.n_2*Params.L,1);
        Bhat(:,aa)   =   mldivide(R , K);
        %  Bhat(:,aa)   =  R \K3;
    end
    
    %//////////////////////////////////////////////////////////////////////
    %                   Updating Chat
    %//////////////////////////////////////////////////////////////////////
    Xhat1    =   Uhat*Bhat;
    Xhat3   =   reshape(Xhat1,Params.n_1,Params.n_2,Params.q);
    Chat     =   exp(1i*angle(Afull(Xhat3))); % Initial phase
    
    Tmp_Err_X2   =   zeros(Params.q, 1);
    for   ct    =  1  :   Params.q
             xa_hat        =   Xhat1(:,ct);
             xa            =   X(:,ct);
            Tmp_Err_X2(ct)  =   norm(xa - exp(-1i*angle(trace(xa'*xa_hat))) * xa_hat, 'fro');
    end
    Nom_Err_X_twf	    =   sum(Tmp_Err_X2);
    err_iter(t+1)             =  Nom_Err_X_twf / Den_X;
    time_iter(t+1) = toc;
end
%Altmintime(3)=toc;
%
%///////////////////////////////////////////////////////////////////////
%                   Defining Functions
%///////////////////////////////////////////////////////////////////////

%   Defining mult_H

    function i_out = mult_H2(i_in)
        I_mat    =   reshape(i_in,(Params.n_1*Params.n_2), Params.r);
        % i_out    =   zeros(Params.q*Params.m, 1);
        Xmat        =    I_mat * Bhat;
        Xmat2   =   reshape(Xmat,Params.n_1,Params.n_2,Params.q);
        Iout        =     Afull(Xmat2);
        i_out       =     reshape(Iout,Params.q*Params.m, 1);
    end

%   Defining mult_Ht

    function w_out = mult_Ht2(w_in)
        w_out   =   zeros(Params.n_1*Params.n_2*Params.r, 1);
        TmpVec  =    permute(Afull_tk(reshape(w_in, Params.n_1,Params.n_2,Params.L,Params.q)), [1,2,4,3]);
        for nk = 1: Params.q
            w_out    =   w_out + kron(Bhat(:,nk), reshape(TmpVec(:,:,nk), Params.n_1*Params.n_2, 1));
        end
        
    end
Altmintime(3)=toc;
end
