/* ---------------------------------------------------------------
 File:                           ReadFileVar.java
 Package:                        FSM Analyzer 2.0
 Author:                         Dr. Ratnesh Kumar and Greg Stamp
 V2.0 10/28/2006
 Initial Developers: Bharath Oruganti
 ---------------------------------------------------------------*/
 
/*
 * Dr. Ratnesh Kumar, Greg Stamp.
 * Department of Electrical and Computer Engineering
 * Iowa State University
 * October, 2006.
 *
 * Copyright (c) 2006
 * All rights reserved.
 */
package mainAnalyzer;

import java.util.*;
import java.io.*;


class MenuInfo {
    String parameter = new String();
    Vector input = new Vector(2, 2);
    String output = new String();
    String title = new String();
    String helpfile = new String();

    public MenuInfo() {}

    public MenuInfo(MenuInfo m) {
        title = m.title;
        parameter = m.parameter;
        output = m.output;
        helpfile = m.helpfile;
        for (int i = 0; i < m.input.size(); i++) {
            input.addElement(m.input.elementAt(i));
        }
    }

    public void settitle(String s) {
        title = s;
    }

    public String gettitle() {
        return title;
    }

    public String getoutput() {
        return output;
    }

    public String gethelpfile() {
        return helpfile;
    }

    public String getparameter() {
        return parameter;
    }

    public int getinputsize() {
        return input.size();
    }

    public String getinputstring(int i) { 

        String str = new String();

        str = (String) input.elementAt(i);
        return str;
    }

    public void setparameter(String s) {
        parameter = s;
    }

    public void setoutput(String s) {
        output = s;
    }

    public void sethelp(String s) {
        helpfile = s;
    }

    public void addtoinput(StringBuffer s) {
        input.addElement(new String(s.toString()));
    }

    public void showinput() {
        String str = new String();

        for (int i = 0; i < input.size(); i++) {
            str = (String) input.elementAt(i);
            System.out.print(str + "\n");
        }

    }
 
    public void Clear() {
        while (input.isEmpty() == false) {
            input.removeElementAt(0);
        }
    }

    public void showtitle() {
        System.out.print(title + "\n");
        System.out.flush();
    }

    public void showparameter() {
        System.out.print(parameter + "\n");
    }

    public void showhelp() {
        System.out.print(helpfile + "\n");
    }

    public void showoutput() {
        System.out.print(output + "\n");
    }

} 


public class ReadFileVar {
    MenuInfo m = new MenuInfo();
    StringBuffer sb = new StringBuffer();
    public ReadFileVar(String FileName, Vector v1)
        throws IOException,
                FileNotFoundException {
        FileInputStream fis;

        fis = new FileInputStream(FileName);
        int oneChar;

        while ((oneChar = fis.read()) != -1) {
            if (oneChar == '(' || oneChar == ',' || oneChar == ':'
                    || oneChar == ')' || oneChar == ';' || oneChar == '*'
                    || oneChar == '@') {
                if (oneChar == '(') {
                    m.settitle(sb.toString());
                }

                if (oneChar == ')') {
                    m.setparameter(sb.toString());
                }

                if (oneChar == ':') {
                    m.setoutput(sb.toString());
                }

                if (oneChar == '@') {
                    m.sethelp(sb.toString());
                }

                if (oneChar == ',') {
                    m.addtoinput(sb);
                }

                if (oneChar == ';') {
                    v1.addElement(new MenuInfo(m));
                    m.Clear();
                }
                sb.setLength(0);
                continue;        
            }
            if (((char) oneChar) != '\n') {
                sb.append((char) oneChar);
            }
            
        }// end of while
        fis.close();
    }
}


class WriteFileVar {

    WriteFileVar(String FileName, String s, boolean flag)
        throws IOException {
        FileOutputStream fos;
        int i;

        fos = new FileOutputStream(FileName, flag);
        for (i = 0; i < s.length(); i++) {
            fos.write(s.charAt(i));
        }
        fos.close();
    }
}

