/* ---------------------------------------------------------------
 File:                           LoadImag.java
 Package:                        FSM Analyzer 2.0
 Author:                         Dr. Ratnesh Kumar and Greg Stamp
 V2.0 10/28/2006
 Initial Developers: Bharath Oruganti
 ---------------------------------------------------------------*/
 
/*
 * Dr. Ratnesh Kumar, Greg Stamp.
 * Department of Electrical and Computer Engineering
 * Iowa State University
 * October, 2006.
 *
 * Copyright (c) 2006
 * All rights reserved.
 */
 
package mainAnalyzer;


import java.awt.Image;
import java.awt.Dimension;


// ********************************************
// * This loads an image in a Canvas area which 
// * paints itself as necessary.
// ********************************************
public class LoadImag extends java.awt.Canvas {
    
	static final long serialVersionUID = 1L;
	Image currImg;
    int width = 32, height = 32;

    public LoadImag(Image imageFile) {
        currImg = imageFile;
    }

    public LoadImag(Image imageFile, int w, int h) {
        currImg = imageFile;
        width = w;
        height = h;
    }

    public void paint(java.awt.Graphics g) {
        if (currImg != null) {
            g.drawImage(currImg, 0, 0, width, height, getBackground(), this);
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(width, height);
    }

    public Dimension getgetPreferredSize() {
        return getMinimumSize();
    }
}

