/* ---------------------------------------------------------------
 File:                           Input.java
 Package:                        FSM Analyzer 2.0
 Author:                         Dr. Ratnesh Kumar and Greg Stamp
 V2.0 10/28/2006
 Initial Developers: Bharath Oruganti
 ---------------------------------------------------------------*/
 
/*
 * Dr. Ratnesh Kumar, Greg Stamp.
 * Department of Electrical and Computer Engineering
 * Iowa State University
 * October, 2006.
 *
 * Copyright (c) 2006
 * All rights reserved.
 */

package mainAnalyzer;


import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;
import flap.*; //added

// **********************************
// * This class provides the Applet
// **********************************
public class Input extends Applet {
    
	// Data members
	static final long serialVersionUID = 1L;
	static InputFrame appFrame = null;
    Toolkit   toolKit = Toolkit.getDefaultToolkit();
    public TextArea  taText;
    public Frame parent;
    Label     statusBar;
    static InputFileFrame ipff = null;//added
    String OPER;
    static String MI_NEW = "New",
            MI_OPEN = "Open",
            MI_SAVE = "Save",
            MI_SAVEAS = "Save As",
            MI_SHOWGRAPHIC = "Show Graphic",
					
            DEF_FNAME = "Courier",
            DEF_FSIZE = "16",
            NEW_FILE = "untitled.txt";

    StringBuffer currFile = null;
    boolean FileState = true, inAnApplet = true, Edited = false, showStatusMsgInBrowser = true;
    Panel topPanel, buttonPanel;
    flap.MainMenu flapMainMenu = null;

    public Input(flap.MainMenu fMainMenu) {
        flapMainMenu = fMainMenu;
    }

    public void init() {
        setBackground(new Color(225, 225, 225));

        // Initialize variables
        currFile = new StringBuffer(NEW_FILE);

        // Push Button Tool Bar
        buttonPanel = new Panel();
        buttonPanel.setFont(new Font("Helvetica", Font.BOLD, 10));
        buttonPanel.setLayout(new GridLayout(1, 5));
        Button btNew, btOpen, btSave, btSaveAs, btShowGraphic;//REMOVED btClose,

        buttonPanel.add(btNew = new Button(MI_NEW));
        buttonPanel.add(btOpen = new Button(MI_OPEN));
        buttonPanel.add(btSave = new Button(MI_SAVE));
        buttonPanel.add(btSaveAs = new Button(MI_SAVEAS));
        buttonPanel.add(btShowGraphic = new Button(MI_SHOWGRAPHIC));
        btShowGraphic.addActionListener(new MyActionListener());
        btNew.addActionListener(new MyActionListener());
        btOpen.addActionListener(new MyActionListener());
        btSave.addActionListener(new MyActionListener());
        btSaveAs.addActionListener(new MyActionListener());

        // Top of screen panel
        topPanel = new Panel();
        topPanel.setLayout(new BorderLayout(1, 2));
        topPanel.add("Center", buttonPanel);

        // Text Editing Area (20 rows x 80 cols)
        taText = new TextArea(11, 1);
        taText.setBackground(Color.white);

        // Status Bar
        statusBar = new Label(NEW_FILE, Label.LEFT);

        // Add Panels to Applet (a Panel itself)
        setLayout(new BorderLayout(1, 2));
        add("North", topPanel);
        add("Center", taText);
        super.enableEvents(AWTEvent.WINDOW_EVENT_MASK | AWTEvent.KEY_EVENT_MASK);

    }

    // Set padding for fill3DRect() in paint()
    public Insets getInsets() {
        return new Insets(4, 4, 4, 4);
    }

    public void callProcessEvent(AWTEvent evt) {
        processEvent(evt);
    }

    protected void processEvent(AWTEvent evt) {
        if (evt.getID() == Event.WINDOW_DESTROY) {
            parent.dispose();
        } else if (evt.getSource() instanceof TextArea) {
            if (evt.getID() == Event.KEY_PRESS) {
                Edited = true;
            }
        }
    }

    protected void newFile() {
        saveWarning();
        // Clear screen for new file
        taText.setText("");
        currFile.setLength(0);
        currFile.append(NEW_FILE);
        statusMsg(NEW_FILE);
    }

    // Read a local file
    protected void readFile(String filename) {
        saveWarning();

        statusMsg("Please wait...");
        try {
            new ReadFile(filename, taText);
            currFile.setLength(0);
            currFile.append(filename);
            statusMsg(currFile.toString());
        } catch (FileNotFoundException e) {
            showCatchError(e);
        } catch (IOException e) {
            showCatchError(e);
        } finally {
            statusMsg("");
        }
    }

    // Write to local file
    protected void writeFile(String filename) {
        statusMsg("Please wait...");
        try {  
            new WriteFile(filename, taText);
            currFile.setLength(0);
            currFile.append(filename);
            statusMsg(currFile.toString());
            Edited = false;
        } catch (IOException e) {
            showCatchError(e);
        } finally {
            statusMsg("");
        }
    }

    protected void statusMsg(String msgText) {
        statusBar.setText(msgText);
        if (inAnApplet && showStatusMsgInBrowser) {
            showStatus(msgText);
        }
    }
   
    protected void showCatchError(Throwable e) {
        statusMsg(e.toString());
        if (inAnApplet) {
            showStatus(e.getMessage());
        } else {
            System.err.println(e.getMessage());
        }
    }

    protected void saveWarning() {
        if (Edited == true) {
            ;
        }  // Add warning message here later
        Edited = false;
    }

    protected void terminate(int rc) {
        saveWarning();
        System.exit(rc);
    }

    class MyActionListener implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            statusMsg("");

            // Button or Menu item selected
            if (evt.getSource() instanceof Button) {
                String  buttonLabel = evt.getActionCommand();
                
                if (buttonLabel.equals(MI_SHOWGRAPHIC)) {
                	if(currFile.toString().indexOf(".data_events")==-1)//if not cont/mask table
                		flapMainMenu.OpenFileAsGraphic(currFile.toString());
                	else
                	{
                		ipff = new InputFileFrame(flapMainMenu,currFile.toString());
                	}
                } else if (buttonLabel.equals(MI_OPEN)) {
                    saveWarning();
                    DoFileDialog fd;

                    try {
                        if (inAnApplet) {
                            setEnabled(false); // Simulate modality
                            fd = new DoFileDialog(null, "Open a File");
                        } else {
                            fd = new DoFileDialog(appFrame, "Open a File");
                        }

                        if (fd.getPath() != null) { 
                            readFile(fd.getPath());
                        }

                    } catch (AWTError e) {
                        showCatchError(e);
                        if (inAnApplet) {
                            statusMsg(
                                    e.toString()
                                            + "  (probably due to security restrictions)");
                        }
                    } finally {
                        if (inAnApplet) {
                            setEnabled(true);
                        }
                    }
                } else if (buttonLabel.equals(MI_SAVEAS)) {
                    saveWarning();
                    DoFileDialog fd;

                    try {
                        if (inAnApplet) {
                            setEnabled(false); // Simulate modality
                            fd = new DoFileDialog(null, "Save File As",
                                    FileDialog.SAVE);
                        } else {
                            fd = new DoFileDialog(appFrame, "Save File As",
                                    FileDialog.SAVE);
                        }
                        if (fd.getPath() != null) {
                            writeFile(fd.getPath());
                        }
                    } catch (AWTError e) {
                        showCatchError(e);
                        if (inAnApplet) {
                            statusMsg(
                                    e.toString()
                                            + "  (probably due to security restrictions)");
                        }
                    } finally {
                        if (inAnApplet) {
                            setEnabled(true);
                        }
                    }
                } else if (buttonLabel.equals(MI_SAVE)) {
                    writeFile(currFile.toString());
                } else if (buttonLabel.equals(MI_NEW)) {
                    newFile();
                }

            }

            taText.requestFocus();
        }// end of actionPerformed
    }// end of MyActionListener

}

