/* ---------------------------------------------------------------
 File:                           DoFileDialog.java
 Package:                        FSM Analyzer 2.0
 Author:                         Dr. Ratnesh Kumar and Greg Stamp
 V2.0 10/28/2006
 Initial Developers: Bharath Oruganti
 ---------------------------------------------------------------*/
 
/*
 * Dr. Ratnesh Kumar, Greg Stamp.
 * Department of Electrical and Computer Engineering
 * Iowa State University
 * October, 2006.
 *
 * Copyright (c) 2006
 * All rights reserved.
 */

package mainAnalyzer;


import java.io.*;
import java.awt.*;


// ************************************************
// * This loads a local file into a TextArea
// ************************************************
class ReadFile {
    StringBuffer sb = new StringBuffer();

    ReadFile(String FileName, TextArea taText)
        throws IOException,
                FileNotFoundException {
        FileInputStream fis;

        sb = new StringBuffer();

        fis = new FileInputStream(FileName);
        int oneChar;

        while ((oneChar = fis.read()) != -1) {
            sb.append((char) oneChar);
        }
        fis.close();
        taText.setText(sb.toString());
    }

}


// ****************************************************
// * This writes to a local file from a TextArea
// ****************************************************
class WriteFile {
    StringBuffer sb;

    WriteFile(String FileName, TextArea taText)
        throws IOException {
        FileOutputStream fos;

        sb = new StringBuffer();
        sb.append(taText.getText());
        int i;

        fos = new FileOutputStream(FileName);
        for (i = 0; i < sb.length(); i++) {
            fos.write(sb.charAt(i));
        }
        fos.close();
    }
}


// ************************************************
// * This provides the FileDialog services.  If the
// * parent frame is null, then it creates its own
// ************************************************
public class DoFileDialog {
    FileDialog fd;
    Frame f;

    public DoFileDialog(Frame parent,
            String Title, int Mode)
        throws AWTError {
        f = null;
        if (parent == null) {
            f = new Frame(Title);
            f.pack();
            fd = new FileDialog(f, Title, Mode);
        } else {
            fd = new FileDialog(parent, Title, Mode);
        }

        if (Analyzer.workingDirectory.endsWith(Analyzer.fileSeparator)) {
            fd.setDirectory(Analyzer.workingDirectory + "../data/");
        } else {
            fd.setDirectory(
                    Analyzer.workingDirectory + Analyzer.fileSeparator
                    + "../data/");
        }
        fd.setVisible(true);
        if (f != null) {
            f.dispose();
        }
    }

    public DoFileDialog(Frame parent, String Title) {
        this(parent, Title, FileDialog.LOAD);
    }

    public String getPath() {
        if (fd != null && fd.getDirectory() != null && fd.getFile() != null) {
            return (fd.getDirectory() + fd.getFile());
        }
        return null;
    }
}
