/* ---------------------------------------------------------------
 File:                           Transition.java
 Package:                        FLAP
 Author:                         Dr. Ratnesh Kumar and Greg Stamp
 V2.0 10/28/2006
 Initial Developers: Bharath Oruganti and Magda & Octavian Procopiuc
 ---------------------------------------------------------------*/
 
/*
 * Dr. Ratnesh Kumar, Greg Stamp.
 * Department of Electrical and Computer Engineering
 * Iowa State University
 * October, 2006.
 *
 * Copyright (c) 2006
 * All rights reserved.
 */

package flap;


/**
 * This class implements the transition function of a machine.
 */

public class Transition {
    public int            id; // ranga's addition
    public State		from;
    public State		to;
    public String		label;
    public int		distance; // the dist. label->from
    public int		st; // NORMAL or FOCUSED 
    public boolean rename = false; // true if user chooses to rename transition label

    final static int NORMAL = 0;
    final static int SELECTED = 1;
    final static int FOCUSED = 2;

    /**
     * Creates a transition with the given
     * from and to states and with the given label.
     */
    public Transition(int id, State from, State to, String symbol) {
        this.id = id;
        this.from = from;
        this.to = to;
        this.label = symbol;
        distance = (from != to) ? Params._t_distance : Params._t_ltheight;
    }

    /**
     * Creates a transition with the given
     * from and to states.
     */
    public Transition(int id, State from, State to) {
        this(id, from, to, "");
    }

    public void setLocation(int x, int y) {
        if (from == to) {
            distance = Math.max(Params._t_ltheight, from.p.y - y);
        }
    }

    /**
     * Returns the slope of the line between the from and to states.
     */
    public double slope() {
        if (to.p.x != from.p.x) {
            return (double) (((double) from.p.y - to.p.y) / (from.p.x - to.p.x));
        } else  if (to.p.y < from.p.y) {
            return (double) 20000;
        } else {
            return (double) (-20000);
        }
    }

}	// end of class Transition.

